/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.DefaultSiteParser;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.Messages;
import org.xml.sax.SAXException;

public class SiteModelFactory {
    private static DefaultSiteParser parser = new DefaultSiteParser();
    public URL url;

    public boolean canParseSiteType(String type) {
        return type == null || type.trim().equals("");
    }

    public SiteModel parseSite(InputStream stream, URL url) throws CoreException, InvalidSiteTypeException {
        SiteModel result = null;
        this.url = url;
        try {
            parser.init(this);
            result = parser.parse(stream);
            if (parser.getStatus() != null) {
                MultiStatus status = parser.getStatus();
                throw new CoreException((IStatus)status);
            }
        }
        catch (SAXException e) {
            if (e.getException() instanceof InvalidSiteTypeException) {
                throw (InvalidSiteTypeException)e.getException();
            }
            throw Utilities.newCoreException(Messages.SiteModelObject_ErrorParsingSiteStream, e);
        }
        catch (IOException e) {
            throw Utilities.newCoreException(Messages.SiteModelObject_ErrorAccessingSiteStream, e);
        }
        return result;
    }

    public SiteModel createSiteMapModel() {
        return new SiteModel();
    }

    public SiteFeatureReferenceModel createFeatureReferenceModel() {
        return new SiteFeatureReferenceModel();
    }

    public ArchiveReferenceModel createArchiveReferenceModel() {
        return new ArchiveReferenceModel();
    }

    public URLEntryModel createURLEntryModel() {
        return new URLEntryModel();
    }

    public CategoryModel createSiteCategoryModel() {
        return new CategoryModel();
    }
}

