/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.ConfigOperation;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IConfigFeatureOperation;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.OperationsManager;

public class BatchConfigOperation
extends Operation
implements IBatchOperation {
    protected IConfigFeatureOperation[] operations;
    private boolean bVerifyComplete = false;

    public BatchConfigOperation(IConfigFeatureOperation[] operations, boolean bVerifyComplete) {
        this.operations = operations;
        this.bVerifyComplete = bVerifyComplete;
    }

    public IFeatureOperation[] getOperations() {
        return this.operations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor monitor, IOperationListener listener) throws CoreException, InvocationTargetException {
        boolean bl;
        IStatus status;
        int configCount = 0;
        if (this.operations == null) return false;
        if (this.operations.length == 0) {
            return false;
        }
        if (!this.bVerifyComplete && (status = OperationsManager.getValidator().validatePendingChanges(this.operations)) != null && status.getCode() == 4) {
            throw new CoreException(status);
        }
        OperationsManager.setInProgress(true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                if (listener != null) {
                    listener.beforeExecute(this, null);
                }
                monitor.beginTask(Messages.OperationsManager_installing, this.operations.length);
                int i = 0;
                while (true) {
                    if (i >= this.operations.length) {
                        bl = SiteManager.getLocalSite().save();
                        Object var7_11 = null;
                        break;
                    }
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1, 4);
                    if (this.operations[i] instanceof ConfigOperation) {
                        ConfigOperation configOper = (ConfigOperation)this.operations[i];
                        configOper.setBatchConfigOperation();
                    }
                    this.operations[i].execute((IProgressMonitor)subMonitor, listener);
                    OperationsManager.addPendingOperation(this.operations[i]);
                    this.operations[i].markProcessed();
                    if (listener != null) {
                        listener.afterExecute(this.operations[i], null);
                    }
                    ++configCount;
                    ++i;
                }
            }
            catch (InstallAbortedException e) {
                if (configCount <= 0) throw new InvocationTargetException((Throwable)((Object)e));
                SiteManager.getLocalSite().save();
                throw new InvocationTargetException((Throwable)((Object)e));
            }
            catch (CoreException e) {
                if (configCount <= 0) throw new InvocationTargetException(e);
                SiteManager.getLocalSite().save();
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            OperationsManager.setInProgress(false);
            monitor.done();
            throw throwable;
        }
        OperationsManager.setInProgress(false);
        monitor.done();
        return bl;
    }
}

