/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ScrolledText
extends Composite {
    public Text text;
    private int maxTextHeight = Integer.MAX_VALUE;

    public ScrolledText(Composite parent, int compositeAttribute, int textAttribute) {
        super(parent, compositeAttribute);
        this.init(textAttribute, -1);
    }

    public ScrolledText(Composite parent, int compositeAttribute, int textAttribute, int maxLineCount) {
        super(parent, textAttribute);
        this.init(textAttribute, maxLineCount);
    }

    private void init(int textAttribute, int maxLineCount) {
        this.setLayout((Layout)new FormLayout());
        this.setLayoutData(new GridData(768));
        this.text = new Text((Composite)this, textAttribute | 0x40 | 0x200);
        this.text.setEditable(false);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment(0, 0);
        fdName.bottom = new FormAttachment(100, 0);
        fdName.left = new FormAttachment(0, 0);
        fdName.right = new FormAttachment(100, 0);
        this.text.setLayoutData((Object)fdName);
        if (maxLineCount != -1) {
            this.text.setText("");
            this.maxTextHeight = this.text.computeSize((int)-1, (int)-1).y * maxLineCount;
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle result = super.computeTrim(x, y, width, height);
        if (result.height > this.maxTextHeight) {
            return new Rectangle(result.x, result.y, result.width, this.maxTextHeight);
        }
        return result;
    }

    public void setText(String labelMessage) {
        this.text.setText(labelMessage);
    }

    public void setEditable(boolean b) {
        this.text.setEditable(b);
    }
}

