/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.mirror;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.FeaturePackagedContentProvider;
import org.eclipse.update.internal.core.SiteFileContentProvider;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.mirror.MirrorSite;
import org.eclipse.update.internal.model.BundleManifest;
import org.eclipse.update.internal.model.DefaultPluginParser;
import org.eclipse.update.standalone.StandaloneUpdateApplication;
import org.xml.sax.SAXException;

public class MirrorSiteFactory
extends BaseSiteFactory {
    public SiteModel createSiteMapModel() {
        return new MirrorSite(this);
    }

    public ISite createSite(URL uRL) throws CoreException, InvalidSiteTypeException {
        return this.createSite(new File(uRL.getFile()));
    }

    public ISite createSite(File file) throws CoreException, InvalidSiteTypeException {
        URL uRL;
        FileInputStream fileInputStream = null;
        if (!file.exists() && !file.mkdirs()) {
            throw Utilities.newCoreException("Directory " + file.getAbsolutePath() + " could not be created.", null);
        }
        if (!file.isDirectory() || !file.canWrite()) {
            throw Utilities.newCoreException(String.valueOf(file.getAbsolutePath()) + " is not a directory or is not writtable.", null);
        }
        MirrorSite mirrorSite = null;
        if (new File(file, "site.xml").exists()) {
            try {
                fileInputStream = new FileInputStream(new File(file, "site.xml"));
            }
            catch (FileNotFoundException fileNotFoundException) {}
            mirrorSite = (MirrorSite)this.parseSite(fileInputStream, this.url);
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        if (mirrorSite == null) {
            mirrorSite = (MirrorSite)this.createSiteMapModel();
        }
        this.parseDownloadedPluginsAndFragments(mirrorSite, new File(file, "plugins/"));
        this.parseDownloadedFeatures(mirrorSite, new File(file, "features/"));
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException("A URL for site " + file.getAbsolutePath() + " could not be created.", malformedURLException);
        }
        SiteFileContentProvider siteFileContentProvider = null;
        siteFileContentProvider = new SiteFileContentProvider(uRL);
        mirrorSite.setSiteContentProvider(siteFileContentProvider);
        siteFileContentProvider.setSite(mirrorSite);
        try {
            mirrorSite.resolve(uRL, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException("Unable to resolve URL " + (uRL == null ? "" : uRL.toExternalForm()), malformedURLException);
        }
        return mirrorSite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseDownloadedPluginsAndFragments(MirrorSite mirrorSite, File file) throws CoreException {
        if (!file.exists()) {
            return;
        }
        String[] stringArray = file.list(FeaturePackagedContentProvider.filter);
        int n = 0;
        while (n < stringArray.length) {
            block16: {
                Object var10_12;
                InputStream inputStream = null;
                try {
                    try {
                        Object object;
                        File file2 = new File(file, stringArray[n]);
                        JarContentReference jarContentReference = new JarContentReference(null, file2);
                        ContentReference contentReference = jarContentReference.peek("META-INF/MANIFEST.MF", null, null);
                        if (contentReference != null && ((BundleManifest)(object = new BundleManifest(inputStream = contentReference.getInputStream()))).exists()) {
                            mirrorSite.addDownloadedPluginEntry(((BundleManifest)object).getPluginEntry());
                            var10_12 = null;
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block16;
                        }
                        contentReference = jarContentReference.peek("plugin.xml", null, null);
                        if (contentReference == null) {
                            contentReference = jarContentReference.peek("fragment.xml", null, null);
                        }
                        if (contentReference != null) {
                            inputStream = contentReference.getInputStream();
                            object = new DefaultPluginParser().parse(inputStream);
                            mirrorSite.addDownloadedPluginEntry((IPluginEntry)object);
                        }
                    }
                    catch (IOException iOException) {
                        StandaloneUpdateApplication.exceptionLogged();
                        UpdateCore.log(iOException);
                    }
                    catch (SAXException sAXException) {
                        StandaloneUpdateApplication.exceptionLogged();
                        UpdateCore.log(sAXException);
                    }
                    var10_12 = null;
                    if (inputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    var10_12 = null;
                    if (inputStream == null) throw throwable;
                    try {}
                    catch (IOException iOException) {}
                    inputStream.close();
                    throw throwable;
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                inputStream.close();
            }
            ++n;
        }
    }

    private void parseDownloadedFeatures(MirrorSite mirrorSite, File file) throws CoreException {
        if (file.exists()) {
            String string = null;
            try {
                String[] stringArray = file.list(FeaturePackagedContentProvider.filter);
                int n = 0;
                while (n < stringArray.length) {
                    File file2 = new File(file, stringArray[n]);
                    JarContentReference jarContentReference = new JarContentReference("", file2);
                    ContentReference contentReference = null;
                    try {
                        contentReference = jarContentReference.peek("feature.xml", null, null);
                    }
                    catch (IOException iOException) {
                        UpdateCore.warn("Exception retrieving feature.xml in file:" + file2, iOException);
                    }
                    if (contentReference == null) {
                        UpdateCore.warn("Unable to find feature.xml in file:" + file2);
                    } else {
                        URL uRL = file2.toURL();
                        SiteFeatureReferenceModel siteFeatureReferenceModel = this.createFeatureReferenceModel();
                        siteFeatureReferenceModel.setSiteModel(mirrorSite);
                        siteFeatureReferenceModel.setURLString(uRL.toExternalForm());
                        siteFeatureReferenceModel.setType("org.eclipse.update.core.packaged");
                        siteFeatureReferenceModel.setFeatureIdentifier(siteFeatureReferenceModel.getVersionedIdentifier().getIdentifier());
                        siteFeatureReferenceModel.setFeatureVersion(siteFeatureReferenceModel.getVersionedIdentifier().getVersion().toString());
                        mirrorSite.addDownloadedFeatureReferenceModel(siteFeatureReferenceModel);
                    }
                    ++n;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw Utilities.newCoreException("Unable to create URL for file " + string + ".", malformedURLException);
            }
        }
    }
}

