/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.widgets.Widget;

class NativeScrollbar {
    private int handle;
    private boolean ownsNativeWidget;

    NativeScrollbar(Widget widget, int parentHandle, int widgetHandle) {
        if (widgetHandle == 0) {
            this.handle = OS.Scrollbar_New(parentHandle);
            int orientation = 0;
            if ((widget.internal_style & 0x100) != 0) {
                orientation = 16;
            } else if ((widget.internal_style & 0x200) != 0) {
                orientation = 8;
            }
            OS.Scrollbar_SetOrientation(this.handle, orientation);
            this.ownsNativeWidget = true;
        } else {
            this.handle = widgetHandle;
            this.ownsNativeWidget = false;
        }
    }

    void releaseNativeWidget() {
        if (this.ownsNativeWidget) {
            OS.Widget_Dispose(this.handle);
            this.handle = 0;
        }
    }

    int getHandle() {
        return this.handle;
    }

    int getIncrement() {
        return OS.Adjustable_GetUnitIncrement(this.handle);
    }

    int getMaximum() {
        return OS.Adjustable_GetMaximum(this.handle);
    }

    int getMinimum() {
        return OS.Adjustable_GetMinimum(this.handle);
    }

    int getPageIncrement() {
        return OS.Adjustable_GetBlockIncrement(this.handle);
    }

    int getSelection() {
        return OS.Adjustable_GetValue(this.handle);
    }

    int getThumb() {
        return OS.Adjustable_GetVisibleAmount(this.handle);
    }

    void setIncrement(int value) {
        OS.Adjustable_SetUnitIncrement(this.handle, value);
    }

    void setMaximum(int value) {
        int selMax;
        int sel;
        if (value < 0) {
            return;
        }
        int min = OS.Adjustable_GetMinimum(this.handle);
        if (value <= min) {
            return;
        }
        int thumb = OS.Adjustable_GetVisibleAmount(this.handle);
        if (min + thumb > value) {
            thumb = value - min;
            OS.Adjustable_SetVisibleAmount(this.handle, thumb);
        }
        if ((sel = OS.Adjustable_GetValue(this.handle)) > (selMax = value - thumb)) {
            OS.Adjustable_SetValue(this.handle, selMax);
        }
        OS.Adjustable_SetMaximum(this.handle, value);
    }

    void setMinimum(int value) {
        if (value < 0) {
            return;
        }
        int max = OS.Adjustable_GetMaximum(this.handle);
        if (value >= max) {
            return;
        }
        if (value + OS.Adjustable_GetVisibleAmount(this.handle) > max) {
            OS.Adjustable_SetVisibleAmount(this.handle, max - value);
        }
        if (OS.Adjustable_GetValue(this.handle) < value) {
            OS.Adjustable_SetValue(this.handle, value);
        }
        OS.Adjustable_SetMinimum(this.handle, value);
    }

    void setPageIncrement(int value) {
        OS.Adjustable_SetBlockIncrement(this.handle, value);
    }

    void setSelection(int value) {
        int min = OS.Adjustable_GetMinimum(this.handle);
        if (value < min) {
            value = min;
        }
        int thumb = OS.Adjustable_GetVisibleAmount(this.handle);
        int max = OS.Adjustable_GetMaximum(this.handle);
        int maxSel = max - thumb;
        if (value > maxSel) {
            value = maxSel;
        }
        OS.Adjustable_SetValue(this.handle, value);
    }

    void setThumb(int value) {
        if (value < 1) {
            return;
        }
        int min = OS.Adjustable_GetMinimum(this.handle);
        int max = OS.Adjustable_GetMaximum(this.handle);
        if (value > max - min) {
            value = max - min;
        }
        OS.Adjustable_SetVisibleAmount(this.handle, value);
        int sel = OS.Adjustable_GetValue(this.handle);
        if (sel > max - value) {
            OS.Adjustable_SetValue(this.handle, max - value);
        }
    }

    void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.setMaximum(maximum);
        this.setMinimum(minimum);
        this.setThumb(thumb);
        this.setSelection(selection);
        this.setIncrement(increment);
        this.setPageIncrement(pageIncrement);
    }
}

