/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.JFaceUtil;
import org.eclipse.ui.internal.SharedImages;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.util.SWTResourceUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.IViewRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WorkbenchPlugin
extends AbstractUIPlugin {
    private static final String UI_BUNDLE_ACTIVATOR = "org.eclipse.ui.internal.UIPlugin";
    private static WorkbenchPlugin inst;
    private BundleContext bundleContext;
    public static boolean DEBUG;
    public static String PI_WORKBENCH;
    public static char PREFERENCE_PAGE_CATEGORY_SEPARATOR;
    private WorkbenchPreferenceManager preferenceManager;
    private ViewRegistry viewRegistry;
    private PerspectiveRegistry perspRegistry;
    private SharedImages sharedImages;

    static {
        DEBUG = false;
        PI_WORKBENCH = "org.eclipse.ui";
        PREFERENCE_PAGE_CATEGORY_SEPARATOR = (char)47;
    }

    public WorkbenchPlugin() {
        inst = this;
    }

    void reset() {
        this.preferenceManager = null;
        if (this.perspRegistry != null) {
            this.perspRegistry.dispose();
            this.perspRegistry = null;
        }
        this.sharedImages = null;
        DEBUG = false;
    }

    public static Object createExtension(IConfigurationElement iConfigurationElement, String string) throws CoreException {
        try {
            if (BundleUtility.isActivated(iConfigurationElement.getDeclaringExtension().getNamespace())) {
                return iConfigurationElement.createExecutableExtension(string);
            }
            Object[] objectArray = new Object[1];
            CoreException[] coreExceptionArray = new CoreException[1];
            try {
                objectArray[0] = iConfigurationElement.createExecutableExtension(string);
            }
            catch (CoreException coreException) {
                coreExceptionArray[0] = coreException;
            }
            if (coreExceptionArray[0] != null) {
                throw coreExceptionArray[0];
            }
            return objectArray[0];
        }
        catch (CoreException coreException) {
            throw coreException;
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, PI_WORKBENCH, 4, WorkbenchMessages.WorkbenchPlugin_extension, (Throwable)exception));
        }
    }

    protected ImageRegistry createImageRegistry() {
        return WorkbenchImages.getImageRegistry();
    }

    public static WorkbenchPlugin getDefault() {
        return inst;
    }

    public IElementFactory getElementFactory(String string) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_WORKBENCH, "elementFactories");
        if (iExtensionPoint == null) {
            WorkbenchPlugin.log("Unable to find element factory. Extension point: elementFactories not found");
            return null;
        }
        IConfigurationElement iConfigurationElement = null;
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string2 = iConfigurationElementArray[n].getAttribute("id");
            if (string.equals(string2)) {
                iConfigurationElement = iConfigurationElementArray[n];
                break;
            }
            ++n;
        }
        if (iConfigurationElement == null) {
            WorkbenchPlugin.log("Unable to find element factory: " + string);
            return null;
        }
        IElementFactory iElementFactory = null;
        try {
            iElementFactory = (IElementFactory)WorkbenchPlugin.createExtension(iConfigurationElement, "class");
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Unable to create element factory.", coreException.getStatus());
            iElementFactory = null;
        }
        return iElementFactory;
    }

    private Object createExtension(String string, String string2, String string3) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_WORKBENCH, string);
        if (iExtensionPoint == null) {
            WorkbenchPlugin.log("Unable to find extension. Extension point: " + string + " not found");
            return null;
        }
        IConfigurationElement iConfigurationElement = null;
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string4;
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            if ((string2 == null || string2.equals(iConfigurationElement2.getName())) && string3.equals(string4 = iConfigurationElement2.getAttribute("id"))) {
                iConfigurationElement = iConfigurationElement2;
                break;
            }
            ++n;
        }
        if (iConfigurationElement == null) {
            WorkbenchPlugin.log("Unable to find extension: " + string3 + " in extension point: " + string);
            return null;
        }
        try {
            return WorkbenchPlugin.createExtension(iConfigurationElement, "class");
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Unable to create extension: " + string3 + " in extension point: " + string + ", status: ", coreException.getStatus());
            return null;
        }
    }

    public synchronized IPerspectiveRegistry getPerspectiveRegistry() {
        if (this.perspRegistry == null) {
            this.perspRegistry = new PerspectiveRegistry();
            this.perspRegistry.load();
        }
        return this.perspRegistry;
    }

    public synchronized PreferenceManager getPreferenceManager() {
        if (this.preferenceManager == null) {
            this.preferenceManager = new WorkbenchPreferenceManager(PREFERENCE_PAGE_CATEGORY_SEPARATOR);
            PreferencePageRegistryReader preferencePageRegistryReader = new PreferencePageRegistryReader(this.getWorkbench());
            preferencePageRegistryReader.loadFromRegistry(Platform.getExtensionRegistry());
            this.preferenceManager.addPages(preferencePageRegistryReader.getTopLevelNodes());
        }
        return this.preferenceManager;
    }

    public synchronized ISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = new SharedImages();
        }
        return this.sharedImages;
    }

    public synchronized IViewRegistry getViewRegistry() {
        if (this.viewRegistry == null) {
            this.viewRegistry = new ViewRegistry();
        }
        return this.viewRegistry;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
    }

    public static void log(String string) {
        WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, string, null));
        System.err.println(string);
    }

    public static IStatus getStatus(Throwable throwable) {
        String string = StatusUtil.getLocalizedMessage(throwable);
        return WorkbenchPlugin.newError(string, throwable);
    }

    public static void log(Throwable throwable) {
        WorkbenchPlugin.getDefault().getLog().log(WorkbenchPlugin.getStatus(throwable));
    }

    public static IStatus getStatus(String string, Throwable throwable) {
        return WorkbenchPlugin.newError(string, throwable);
    }

    public static IStatus newError(String string, Throwable throwable) {
        String string2 = WorkbenchPlugin.getDefault().getBundle().getSymbolicName();
        int n = 0;
        if (throwable instanceof CoreException) {
            CoreException coreException = (CoreException)throwable;
            string2 = coreException.getStatus().getPlugin();
            n = coreException.getStatus().getCode();
        }
        return new Status(4, string2, n, string, StatusUtil.getCause(throwable));
    }

    public static void log(String string, Throwable throwable) {
        IStatus iStatus = StatusUtil.newStatus(4, string, throwable);
        WorkbenchPlugin.log(string, iStatus);
    }

    public static void log(Class clazz, String string, Throwable throwable) {
        String string2 = MessageFormat.format("Exception in {0}.{1}: {2}", clazz.getName(), string, throwable);
        WorkbenchPlugin.log(string2, throwable);
    }

    public static void log(String string, IStatus iStatus) {
        if (string != null) {
            WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, string, null));
            System.err.println(String.valueOf(string) + "\nReason:");
        }
        WorkbenchPlugin.getDefault().getLog().log(iStatus);
        System.err.println(iStatus.getMessage());
    }

    public static void log(IStatus iStatus) {
        WorkbenchPlugin.getDefault().getLog().log(iStatus);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.bundleContext = bundleContext;
        JFaceUtil.initializeJFace();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        try {
            bundle.loadClass(UI_BUNDLE_ACTIVATOR);
        }
        catch (ClassNotFoundException classNotFoundException) {
            WorkbenchPlugin.log("Unable to load ui activator", classNotFoundException);
        }
    }

    public Bundle[] getBundles() {
        return this.bundleContext == null ? new Bundle[]{} : this.bundleContext.getBundles();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        SWTResourceUtil.shutdown();
    }

    public IPath getDataLocation() {
        try {
            return this.getStateLocation();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }
}

