/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

public class ListViewer
extends AbstractListViewer {
    private List list;

    public ListViewer(Composite composite) {
        this(composite, 2818);
    }

    public ListViewer(Composite composite, int n) {
        this(new List(composite, n));
    }

    public ListViewer(List list) {
        this.list = list;
        this.hookControl((Control)list);
    }

    public Control getControl() {
        return this.list;
    }

    public List getList() {
        return this.list;
    }

    public void reveal(Object object) {
        Assert.isNotNull(object);
        int n = this.getElementIndex(object);
        if (n == -1) {
            return;
        }
        int n2 = this.list.getItemCount();
        if (n2 == 0) {
            return;
        }
        int n3 = this.list.getItemHeight();
        Rectangle rectangle = this.list.getClientArea();
        int n4 = this.list.getTopIndex();
        int n5 = Math.max((rectangle.x + rectangle.height) / n3, 1);
        int n6 = Math.min(n4 + n5 + 1, n2 - 1);
        if (n4 <= n && n <= n6) {
            return;
        }
        int n7 = Math.min(Math.max(n - n5 / 2, 0), n2 - 1);
        this.list.setTopIndex(n7);
    }

    protected void listAdd(String string, int n) {
        this.list.add(string, n);
    }

    protected void listSetItem(int n, String string) {
        this.list.setItem(n, string);
    }

    protected int[] listGetSelectionIndices() {
        return this.list.getSelectionIndices();
    }

    protected int listGetItemCount() {
        return this.list.getItemCount();
    }

    protected void listSetItems(String[] stringArray) {
        this.list.setItems(stringArray);
    }

    protected void listRemoveAll() {
        this.list.removeAll();
    }

    protected void listRemove(int n) {
        this.list.remove(n);
    }

    protected void listSetSelection(int[] nArray) {
        this.list.setSelection(nArray);
    }

    protected void listDeselectAll() {
        this.list.deselectAll();
    }

    protected void listShowSelection() {
        this.list.showSelection();
    }
}

