/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.internal.core.UpdateCore;

public class PluginEntry
extends PluginEntryModel
implements IPluginEntry {
    private VersionedIdentifier versionId;

    public VersionedIdentifier getVersionedIdentifier() {
        if (this.versionId != null) {
            return this.versionId;
        }
        String string = this.getPluginIdentifier();
        String string2 = this.getPluginVersion();
        if (string != null && string2 != null) {
            try {
                this.versionId = new VersionedIdentifier(string, string2);
                return this.versionId;
            }
            catch (Exception exception) {
                UpdateCore.warn("Unable to create versioned identifier:" + string + ":" + string2);
            }
        }
        this.versionId = new VersionedIdentifier("", null);
        return this.versionId;
    }

    public void setVersionedIdentifier(VersionedIdentifier versionedIdentifier) {
        this.setPluginIdentifier(versionedIdentifier.getIdentifier());
        this.setPluginVersion(versionedIdentifier.getVersion().toString());
    }

    public boolean equals(Object object) {
        if (!(object instanceof IPluginEntry)) {
            return false;
        }
        IPluginEntry iPluginEntry = (IPluginEntry)object;
        return this.getVersionedIdentifier().equals(iPluginEntry.getVersionedIdentifier());
    }
}

