/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WrappedLabel
extends Composite {
    public Label label;
    private int maxLabelHeight = Integer.MAX_VALUE;

    public WrappedLabel(Composite parent, int compositeAttribute, int labelAttribute) {
        super(parent, compositeAttribute);
        this.init(labelAttribute, -1);
    }

    public WrappedLabel(Composite parent, int compositeAttribute, int labelAttribute, int maxLineCount) {
        super(parent, compositeAttribute);
        this.init(labelAttribute, maxLineCount);
    }

    private void init(int labelAttribute, int maxLineCount) {
        this.setLayout((Layout)new FormLayout());
        this.setLayoutData(new GridData(768));
        this.label = new Label((Composite)this, labelAttribute | 0x40);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment(0, 0);
        fdName.bottom = new FormAttachment(100, 0);
        fdName.left = new FormAttachment(0, 0);
        fdName.right = new FormAttachment(100, 0);
        this.label.setLayoutData((Object)fdName);
        if (maxLineCount != -1) {
            this.label.setText("");
            this.maxLabelHeight = this.label.computeSize((int)-1, (int)-1).y * maxLineCount;
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle result = super.computeTrim(x, y, width, height);
        if (result.height > this.maxLabelHeight) {
            return new Rectangle(result.x, result.y, result.width, this.maxLabelHeight);
        }
        return result;
    }

    public void setText(String labelMessage) {
        this.label.setText(labelMessage);
    }

    public void setFont(Font labelFont) {
        this.label.setFont(labelFont);
    }
}

