/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.util.BookmarkSite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BookmarkUtil {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public static void load(String fileName, Vector bookmarks) {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        if (bookmarks == null) {
            bookmarks = new Vector();
        } else {
            bookmarks.removeAllElements();
        }
        try {
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            Document doc = parser.parse(file);
            Element root = doc.getDocumentElement();
            BookmarkUtil.processRoot(root, bookmarks);
        }
        catch (ParserConfigurationException e) {
            UpdateCore.log((Throwable)e);
        }
        catch (SAXException e) {
            UpdateCore.log((Throwable)e);
        }
        catch (IOException e) {
            UpdateCore.log((Throwable)e);
        }
    }

    private static void processRoot(Node root, Vector bookmarks) {
        if ("bookmarks".equals(root.getNodeName())) {
            NodeList children = root.getChildNodes();
            BookmarkUtil.processChildren(children, null, bookmarks);
        }
    }

    private static void processChildren(NodeList children, Object folder, Vector bookmarks) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            BookmarkSite sb = null;
            if (child.getNodeType() == 1) {
                if ("site".equals(child.getNodeName())) {
                    sb = new BookmarkSite(BookmarkUtil.getAttribute(child, "name"), BookmarkUtil.getAttribute(child, "url"), "true".equals(BookmarkUtil.getAttribute(child, "web")), "true".equals(BookmarkUtil.getAttribute(child, "selected")), "true".equals(BookmarkUtil.getAttribute(child, "local")), BookmarkUtil.readDescription(child));
                } else if ("folder".equals(child.getNodeName())) {
                    System.out.println("!!! Warning. Got a folder node." + child.getLocalName());
                }
            }
            if (sb != null && folder == null) {
                bookmarks.add(sb);
            }
            ++i;
        }
    }

    private static String readDescription(Node data) {
        String description = "";
        NodeList children = data.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && "description".equals(child.getNodeName())) {
                NodeList allContents = child.getChildNodes();
                int j = 0;
                while (j < allContents.getLength()) {
                    Node content = allContents.item(j);
                    if (content.getNodeType() == 3) {
                        description = String.valueOf(description) + content.getNodeValue();
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return description;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void store(String fileName, Vector bookmarks) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        try {
            try {
                fos = new FileOutputStream(fileName);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                writer = new PrintWriter(osw);
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<bookmarks>");
                int i = 0;
                while (true) {
                    if (i >= bookmarks.size()) {
                        writer.println("</bookmarks>");
                        writer.flush();
                        writer.close();
                    }
                    Object obj = bookmarks.get(i);
                    BookmarkUtil.writeObject("   ", obj, writer);
                    ++i;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (osw != null) {
            osw.close();
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (fos == null) return;
        fos.close();
    }

    private static void writeObject(String indent, Object obj, PrintWriter writer) {
        if (obj instanceof BookmarkSite) {
            BookmarkSite bookmark = (BookmarkSite)obj;
            String name = bookmark.getName();
            String url = bookmark.getURL().toString();
            String web = bookmark.getWeb() ? "true" : "false";
            String sel = bookmark.getSelected() ? "true" : "false";
            String local = bookmark.getLocal() ? "true" : "false";
            writer.print(String.valueOf(indent) + "<site name=\"" + UpdateManagerUtils.getWritableXMLString((String)name) + "\" url=\"" + url + "\" web=\"" + web + "\" selected=\"" + sel + "\" local=\"" + local + "\"");
            if (bookmark.getDescription() != null) {
                writer.println(">");
                if (bookmark.getDescription() != null) {
                    writer.print(String.valueOf(indent) + "  <description>");
                    writer.print(UpdateManagerUtils.getWritableXMLString((String)bookmark.getDescription()));
                    writer.println("</description>");
                }
                writer.println(String.valueOf(indent) + "</site>");
            } else {
                writer.println("/>");
            }
        }
    }

    private static String getAttribute(Node node, String name) {
        NamedNodeMap atts = node.getAttributes();
        Node att = atts.getNamedItem(name);
        if (att != null) {
            return att.getNodeValue();
        }
        return "";
    }

    public static int searchByName(Vector bookmarks, String newName) {
        int i = 0;
        while (i < bookmarks.size()) {
            BookmarkSite sbm = (BookmarkSite)bookmarks.elementAt(i);
            if (newName.equals(sbm.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

