/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class DisableCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private IFeature feature;

    public DisableCommand(String string, String string2, String string3, String string4) throws Exception {
        super(string4);
        try {
            IFeature[] iFeatureArray;
            IConfiguredSite[] iConfiguredSiteArray = this.getConfiguration().getConfiguredSites();
            if (string3 != null) {
                iFeatureArray = new File(string3).toURL();
                if (SiteManager.getSite((URL)iFeatureArray, null) == null) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_noSite, (Object[])new String[]{string3}));
                }
                this.targetSite = SiteManager.getSite((URL)iFeatureArray, null).getCurrentConfiguredSite();
            }
            if (this.targetSite == null) {
                int n = 0;
                while (n < iConfiguredSiteArray.length) {
                    if (iConfiguredSiteArray[n].isProductSite()) {
                        this.targetSite = iConfiguredSiteArray[n];
                        break;
                    }
                    ++n;
                }
            }
            if ((iFeatureArray = UpdateUtils.searchSite(string, this.targetSite, true)) == null || iFeatureArray.length == 0) {
                throw new Exception(NLS.bind((String)Messages.Standalone_noFeatures3, (Object[])new String[]{string}));
            }
            if (string2 == null || string2.trim().length() == 0) {
                this.feature = iFeatureArray[0];
            } else {
                int n = 0;
                while (iFeatureArray != null && n < iFeatureArray.length) {
                    if (iFeatureArray[n].getVersionedIdentifier().getVersion().toString().equals(string2)) {
                        this.feature = iFeatureArray[n];
                        break;
                    }
                    ++n;
                }
            }
            if (this.feature == null) {
                throw new Exception(NLS.bind((String)Messages.Standalone_noFeatures4, (Object[])new String[]{string, string2}));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (CoreException coreException) {
            throw coreException;
        }
    }

    public boolean run(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = OperationsManager.getValidator().validatePlatformConfigValid();
        if (iStatus != null) {
            UpdateCore.log(iStatus);
            return false;
        }
        if (this.isVerifyOnly()) {
            iStatus = OperationsManager.getValidator().validatePendingUnconfig(this.feature);
            if (iStatus != null && iStatus.getCode() == 2) {
                UpdateCore.log(iStatus);
            }
            return iStatus == null || iStatus.getCode() == 2;
        }
        IUnconfigFeatureOperation iUnconfigFeatureOperation = OperationsManager.getOperationFactory().createUnconfigOperation(this.targetSite, this.feature);
        try {
            iUnconfigFeatureOperation.execute(iProgressMonitor, this);
            return true;
        }
        catch (CoreException coreException) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(coreException);
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(invocationTargetException);
            return false;
        }
    }
}

