/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.configuration;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.update.configuration.ILocalSystemInfoListener;
import org.eclipse.update.configuration.IVolume;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.Volume;

public class LocalSystemInfo {
    public static final long SIZE_UNKNOWN = -1L;
    public static final int VOLUME_UNKNOWN = -1;
    public static final int VOLUME_INVALID_PATH = -2;
    public static final int VOLUME_REMOVABLE = 1;
    public static final int VOLUME_FIXED = 2;
    public static final int VOLUME_REMOTE = 3;
    public static final int VOLUME_CDROM = 4;
    public static final int VOLUME_RAMDISK = 5;
    public static final int VOLUME_FLOPPY_5 = 6;
    public static final int VOLUME_FLOPPY_3 = 7;
    public static final int VOLUME_ADDED = 0;
    public static final int VOLUME_REMOVED = 1;
    public static final int VOLUME_CHANGED = 2;
    private static ArrayList listeners = new ArrayList();
    private static boolean hasNatives = false;

    static {
        try {
            System.loadLibrary("update");
            hasNatives = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            UpdateCore.warn("Unable to load native library 'update'.");
            hasNatives = false;
        }
    }

    public static long getFreeSpace(File file) {
        if (hasNatives) {
            try {
                long l = LocalSystemInfo.nativeGetFreeSpace(file);
                return l != 0L ? l / 1024L : 0L;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        return -1L;
    }

    public static IVolume[] getVolumes() {
        String[] stringArray = LocalSystemInfo.listMountPoints();
        IVolume[] iVolumeArray = new Volume[]{};
        if (stringArray != null) {
            iVolumeArray = new Volume[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                File file = new File(stringArray[n]);
                String string = LocalSystemInfo.getLabel(file);
                int n2 = LocalSystemInfo.getType(file);
                long l = LocalSystemInfo.getFreeSpace(file);
                iVolumeArray[n] = new Volume(file, string, n2, l);
                ((ModelObject)((Object)iVolumeArray[n])).markReadOnly();
                ++n;
            }
        } else {
            UpdateCore.warn("Unable to find mount points");
            File[] fileArray = File.listRoots();
            if (fileArray.length == 1) {
                File file = fileArray[0];
                fileArray = file.listFiles();
            }
            iVolumeArray = new Volume[fileArray.length];
            int n = 0;
            while (n < fileArray.length) {
                iVolumeArray[n] = new Volume(fileArray[n], null, -1, -1L);
                ((ModelObject)((Object)iVolumeArray[n])).markReadOnly();
                ++n;
            }
        }
        return iVolumeArray;
    }

    public static void addInfoListener(ILocalSystemInfoListener iLocalSystemInfoListener) {
        if (!listeners.contains(iLocalSystemInfoListener)) {
            listeners.add(iLocalSystemInfoListener);
        }
    }

    public static void removeInfoListener(ILocalSystemInfoListener iLocalSystemInfoListener) {
        listeners.remove(iLocalSystemInfoListener);
    }

    public static void fireSystemInfoChanged(IVolume iVolume, int n) {
        int n2 = 0;
        while (n2 < listeners.size()) {
            ((ILocalSystemInfoListener)listeners.get(n2)).systemInfoChanged(iVolume, n);
            ++n2;
        }
    }

    private static String getLabel(File file) {
        if (hasNatives) {
            try {
                return LocalSystemInfo.nativeGetLabel(file);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        return null;
    }

    private static int getType(File file) {
        if (hasNatives) {
            try {
                return LocalSystemInfo.nativeGetType(file);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        return -1;
    }

    private static String[] listMountPoints() {
        if (hasNatives) {
            try {
                String[] stringArray = LocalSystemInfo.nativeListMountPoints();
                return stringArray;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        return null;
    }

    private static native long nativeGetFreeSpace(File var0);

    private static native String nativeGetLabel(File var0);

    private static native int nativeGetType(File var0);

    private static native String[] nativeListMountPoints();
}

