/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.internal.core.ReferenceInputStream;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.internal.baseadaptor.BaseStorage;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class BundleUpdate
implements BundleOperation {
    private BaseData data;
    private BaseData newData;
    private URLConnection source;
    private BaseStorage storage;

    public BundleUpdate(BaseData baseData, URLConnection uRLConnection, BaseStorage baseStorage) {
        this.data = baseData;
        this.source = uRLConnection;
        this.storage = baseStorage;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BundleData begin() throws BundleException {
        try {
            URL uRL;
            InputStream inputStream;
            BaseStorageHook baseStorageHook;
            this.newData = this.storage.createBaseData(this.data.getBundleID(), this.data.getLocation());
            this.newData.setLastModified(System.currentTimeMillis());
            this.newData.setStartLevel(this.data.getStartLevel());
            this.newData.setStatus(this.data.getStatus());
            StorageHook[] storageHookArray = this.data.getAdaptor().getHookRegistry().getStorageHooks();
            StorageHook[] storageHookArray2 = new StorageHook[storageHookArray.length];
            int n = 0;
            while (true) {
                if (n >= storageHookArray.length) {
                    this.newData.setStorageHooks(storageHookArray2);
                    baseStorageHook = (BaseStorageHook)this.newData.getStorageHook(BaseStorageHook.KEY);
                    inputStream = this.source.getInputStream();
                    uRL = this.source.getURL();
                }
                storageHookArray2[n] = storageHookArray[n].create(this.newData);
                storageHookArray2[n].copy(this.data.getStorageHook((String)storageHookArray2[n].getKey()));
                ++n;
            }
            String string = uRL == null ? null : uRL.getProtocol();
            try {
                Object object;
                Object object2;
                if (inputStream instanceof ReferenceInputStream) {
                    object2 = ((ReferenceInputStream)inputStream).getReference();
                    if (!"file".equals(((URL)object2).getProtocol())) {
                        throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_URL_CREATE_EXCEPTION, object2));
                    }
                    object = ((URL)object2).getPath();
                    baseStorageHook.setReference(true);
                    baseStorageHook.setFileName((String)object);
                } else {
                    object2 = baseStorageHook.createGenerationDir();
                    if (!((File)object2).exists()) {
                        throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, ((File)object2).getPath()));
                    }
                    baseStorageHook.setReference(false);
                    baseStorageHook.setFileName("bundlefile");
                    object = new File((File)object2, baseStorageHook.getFileName());
                    if ("file".equals(string)) {
                        File file = new File(this.source.getURL().getPath());
                        if (file.isDirectory()) {
                            AdaptorUtil.copyDir(file, (File)object);
                        } else {
                            AdaptorUtil.readFile(inputStream, (File)object);
                        }
                    } else {
                        AdaptorUtil.readFile(inputStream, (File)object);
                    }
                }
                object2 = this.storage.loadManifest(this.newData, true);
                int n2 = 0;
                while (n2 < storageHookArray2.length) {
                    storageHookArray2[n2].initialize((Dictionary)object2);
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var10_15 = null;
                try {}
                catch (IOException iOException) {
                    return this.newData;
                }
                if (inputStream == null) return this.newData;
                inputStream.close();
                return this.newData;
            }
        }
        catch (IOException iOException) {
            throw new BundleException(AdaptorMsg.BUNDLE_READ_EXCEPTION, iOException);
        }
    }

    public void commit(boolean bl) throws BundleException {
        this.storage.processExtension(this.data, (byte)4);
        this.storage.processExtension(this.newData, (byte)8);
        try {
            this.newData.setLastModified(System.currentTimeMillis());
            this.newData.save();
        }
        catch (IOException iOException) {
            throw new BundleException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION, iOException);
        }
        this.storage.updateState(this.newData, 8);
        BaseStorageHook baseStorageHook = (BaseStorageHook)this.data.getStorageHook(BaseStorageHook.KEY);
        try {
            baseStorageHook.delete(bl, 2);
        }
        catch (IOException iOException) {
            this.data.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.data.getBundle(), iOException);
        }
    }

    public void undo() throws BundleException {
        if (this.newData != null) {
            BaseStorageHook baseStorageHook = (BaseStorageHook)this.newData.getStorageHook(BaseStorageHook.KEY);
            try {
                if (baseStorageHook != null) {
                    baseStorageHook.delete(false, 2);
                }
            }
            catch (IOException iOException) {
                this.data.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.data.getBundle(), iOException);
            }
        }
    }
}

