/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.ercp.swt.mobile.MobileDevice;
import org.eclipse.ercp.swt.mobile.VerticalData;
import org.eclipse.ercp.swt.mobile.VerticalLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class SortedList
extends Scrollable {
    public static final int FILTER = 1;
    List list;
    Vector listItems = new Vector(10, 10);
    Text filterText;
    static int hackfilterStyle = 0;
    static Composite hackComposite;
    static int hackStyle;
    Composite internalComposite;
    Composite bottomcomposite;
    boolean isDispose = false;
    int updownStyle = 128;
    int filterHeight = 0;
    int filterWidth = 0;
    public boolean hasFilter = false;
    final MobileDevice md = new MobileDevice();
    int orgVKStatus = 1;
    boolean saveVKStatus = true;
    int numericCount = 0;
    boolean enableTraverse = false;

    public SortedList(Composite parent, int style) {
        this(parent, style, 0);
    }

    public boolean isDisposed() {
        if (this.internal_handle == 0) {
            this.isDispose = true;
        }
        return this.isDispose;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.internalComposite != null && !this.internalComposite.isDisposed()) {
            this.internalComposite.dispose();
        }
        this.internalComposite = null;
        this.isDispose = true;
    }

    private static Composite SaveStyle(Composite parent, int style, int filterStyle) {
        hackStyle = style;
        hackComposite = parent;
        hackfilterStyle = filterStyle;
        return parent;
    }

    public SortedList(Composite parent, int style, int modeStyle) {
        super(SortedList.SaveStyle(parent, style, modeStyle), 0);
        if (parent == null) {
            SWT.error(4);
        }
        final SortedList sortedList = this;
        if (modeStyle == 1) {
            VerticalLayout verticalLayout = new VerticalLayout(512);
            verticalLayout.wrap = false;
            verticalLayout.pack = true;
            this.internalComposite.setLayout(verticalLayout);
            this.list = new List(this.internalComposite, style &= 0xFFFFF7FF);
            InputStream stream = this.getClass().getResourceAsStream("/resources/Magnify1.png");
            this.bottomcomposite = new Composite(this.internalComposite, 8);
            VerticalLayout horizontalLayout = new VerticalLayout(256);
            horizontalLayout.wrap = false;
            horizontalLayout.pack = true;
            this.bottomcomposite.setLayout(horizontalLayout);
            Label magnifyLabel = new Label(this.bottomcomposite, 0);
            magnifyLabel.setImage(new Image((Device)this.getDisplay(), stream));
            this.filterText = new Text(this.bottomcomposite, 4);
            this.filterText.setBackground(new Color(this.getDisplay(), 230, 230, 230));
            this.internalComposite.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    SortedList.this.setVKAlwaysOff();
                    SortedList.this.filterText.forceFocus();
                }

                public void focusLost(FocusEvent e) {
                }
            });
            this.list.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    SortedList.this.setVKAlwaysOff();
                    SortedList.this.filterText.forceFocus();
                }

                public void focusLost(FocusEvent e) {
                }
            });
            magnifyLabel.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    SortedList.this.setVKAlwaysOff();
                    SortedList.this.filterText.forceFocus();
                }
            });
            this.filterText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    SortedList.this.setVKAlwaysOff();
                }

                public void focusLost(FocusEvent e) {
                }
            });
            parent.getDisplay().addFilter(15, new Listener(){

                public void handleEvent(Event e) {
                    if (e.widget != SortedList.this.internalComposite && e.widget != SortedList.this.list && e.widget != SortedList.this.filterText && !SortedList.this.saveVKStatus) {
                        SortedList.this.md.setVKStatus(SortedList.this.orgVKStatus);
                        SortedList.this.saveVKStatus = true;
                    }
                }
            });
            this.filterText.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    SortedList.this.internal_processPressedKeyEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SortedList.this.removeListAll();
                    Iterator listIterator = SortedList.this.listItems.iterator();
                    while (listIterator.hasNext()) {
                        String stringToSearch = (String)listIterator.next();
                        if (stringToSearch.toUpperCase().indexOf(SortedList.this.filterText.getText().toUpperCase()) < 0) continue;
                        sortedList.internalAdd(stringToSearch);
                    }
                }
            });
            this.hasFilter = true;
        } else {
            VerticalLayout verticalLayout = new VerticalLayout(512);
            verticalLayout.wrap = false;
            verticalLayout.pack = true;
            this.internalComposite.setLayout(verticalLayout);
            this.list = new List(this.internalComposite, style &= 0xFFFFF7FF);
            this.list.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    SortedList.this.internal_processPressedKeyEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        }
        if ((0x80 & style) == 128) {
            this.updownStyle = 128;
        } else if ((0x400 & style) == 1024) {
            this.updownStyle = 1024;
        }
        this.list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                sortedList.internal_sendEvent(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                sortedList.internal_sendEvent(14);
            }
        });
        this.list.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SortedList.this.enableTraverse = false;
                sortedList.internal_sendEvent(15);
            }

            public void focusLost(FocusEvent e) {
                sortedList.internal_sendEvent(16);
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                sortedList.dispose();
            }
        });
    }

    public boolean forceFocus() {
        if ((hackfilterStyle & 1) == 1) {
            this.setVKAlwaysOff();
            this.enableTraverse = false;
            return this.filterText.forceFocus();
        }
        return super.forceFocus();
    }

    private void setVKAlwaysOff() {
        if (this.saveVKStatus) {
            this.orgVKStatus = Device.internal_vkstatus;
            this.saveVKStatus = false;
        }
        if (3 != Device.internal_vkstatus) {
            this.md.setVKStatus(3);
        }
    }

    public void add(String item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
            return;
        }
        this.listItems.add(item);
        this.internalAdd(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalAdd(String item) {
        boolean exception = false;
        if (this.updownStyle == 0) {
            this.list.add(item);
            return;
        }
        try {
            Integer.parseInt(item);
        }
        catch (NumberFormatException e) {
            int totalCount = this.list.getItemCount();
            exception = true;
            if (totalCount == 0) {
                this.list.add(item);
                return;
            }
            if (this.numericCount == totalCount) {
                this.list.add(item);
                return;
            }
            for (int i = this.numericCount; i < totalCount; ++i) {
                if (this.updownStyle == 128) {
                    if (item.compareTo(this.list.getItem(i)) >= 0) continue;
                    this.list.add(item, i);
                    return;
                }
                if (this.updownStyle != 1024 || item.compareTo(this.list.getItem(i)) <= 0) continue;
                this.list.add(item, i);
                return;
            }
            this.list.add(item);
            return;
        }
        if (!exception) {
            int totalCount = this.list.getItemCount();
            if (totalCount == 0) {
                this.list.add(item);
                ++this.numericCount;
                return;
            }
            if (this.numericCount == 0) {
                this.list.add(item, 0);
                ++this.numericCount;
                return;
            }
            for (int i = 0; i < this.numericCount; ++i) {
                int list_i = Integer.valueOf(this.list.getItem(i));
                int item_i = Integer.valueOf(item);
                if (this.updownStyle == 128 && list_i >= item_i) {
                    this.list.add(item, i);
                    ++this.numericCount;
                    return;
                }
                if (this.updownStyle != 1024 || list_i > item_i) continue;
                this.list.add(item, i);
                ++this.numericCount;
                return;
            }
            this.list.add(item, this.numericCount);
            ++this.numericCount;
            return;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return this.internalComposite.computeSize(wHint, hHint, changed);
    }

    public String getFocus() {
        this.checkWidget();
        return this.list.getItem(this.list.getFocusIndex());
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.list.getItemHeight();
    }

    public String[] getSelection() {
        this.checkWidget();
        return this.list.getSelection();
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.list.getSelectionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
            return;
        }
        Iterator listIterator = this.listItems.iterator();
        int index = 0;
        boolean exception = false;
        while (listIterator.hasNext()) {
            String stringToSearch = (String)listIterator.next();
            if (item.compareTo(stringToSearch) == 0) {
                this.listItems.remove(index);
                try {
                    Integer.parseInt(item);
                }
                catch (NumberFormatException e) {
                    this.list.remove(item);
                    return;
                }
                this.list.remove(item);
                --this.numericCount;
                return;
            }
            ++index;
        }
        SWT.error(5);
    }

    public void removeAll() {
        this.checkWidget();
        this.numericCount = 0;
        this.listItems.clear();
        this.list.removeAll();
    }

    void removeListAll() {
        this.numericCount = 0;
        this.list.removeAll();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void select(String item) {
        this.checkWidget();
        if (item == null) {
            this.list.deselectAll();
            return;
        }
        if (this.list.indexOf(item) == -1) {
            SWT.error(5);
            return;
        }
        this.list.select(this.list.indexOf(item));
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error(4);
            return;
        }
        this.removeAll();
        for (int i = 0; i < items.length; ++i) {
            this.add(items[i]);
        }
    }

    public void setSelection(String[] items) {
        this.checkWidget();
        this.list.setSelection(items);
    }

    public void showSelection() {
        this.checkWidget();
        this.list.showSelection();
    }

    public void internal_createHandle(int index) {
        this.internalComposite = (hackStyle & 0x800) == 2048 ? new Composite(hackComposite, 2048) : new Composite(hackComposite, 8);
        this.internal_handle = this.internalComposite.internal_handle;
        hackComposite.internal_removeChild(this.internalComposite);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        if (this.hasFilter) {
            VerticalData rd = new VerticalData(width - 8, height - 40);
            this.list.setLayoutData(rd);
            rd = new VerticalData(width - 8, 35);
            this.bottomcomposite.setLayoutData(rd);
            rd = new VerticalData(width - 40, 20);
            this.filterText.setLayoutData(rd);
            this.internalComposite.setBounds(x, y, width, height);
            this.internalComposite.layout();
        } else {
            VerticalData rd = new VerticalData(width, height);
            this.list.setLayoutData(rd);
            this.internalComposite.setBounds(x, y, width, height);
            this.internalComposite.layout();
        }
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            SWT.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.internalComposite.setLocation(x, y);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            SWT.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        if (this.hasFilter) {
            VerticalData rd = new VerticalData(width - 10, height - 32);
            this.list.setLayoutData(rd);
            rd = new VerticalData(width - 10, 20);
            this.bottomcomposite.setLayoutData(rd);
            rd = new VerticalData(width - 20, 20);
            this.filterText.setLayoutData(rd);
            this.internalComposite.setSize(width, height);
        } else {
            VerticalData rd = new VerticalData(width - 10, height - 10);
            this.list.setLayoutData(rd);
            this.internalComposite.setSize(width, height);
        }
    }

    public void pack() {
        super.pack();
        if (this.hasFilter) {
            Point p = this.list.computeSize(-1, -1);
            Point p2 = this.bottomcomposite.computeSize(p.x, -1);
            this.internalComposite.setSize(this.internalComposite.computeSize(p.x, p.y + p2.y));
            this.list.pack();
            this.bottomcomposite.setBounds(0, p.y + 2, p2.x, p2.y);
        } else {
            Point p = this.list.computeSize(-1, -1);
            this.internalComposite.setSize(this.internalComposite.computeSize(p.x, p.y));
            this.list.pack();
        }
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            SWT.error(4);
        }
        this.setSize(size.x, size.y);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.internalComposite.getBounds();
    }

    public Point getLocation() {
        this.checkWidget();
        return this.internalComposite.getLocation();
    }

    public Point getSize() {
        this.checkWidget();
        return this.internalComposite.getSize();
    }

    public boolean setFocus() {
        this.enableTraverse = false;
        return this.list.forceFocus();
    }

    protected Control getchild() {
        return this.list;
    }

    public void setFont(Font font) {
        this.list.setFont(font);
    }

    public Font getFont() {
        return this.list.getFont();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.list.isFocusControl();
    }

    public boolean isEnableTraverse() {
        return this.enableTraverse;
    }

    public boolean allowTraverseByArrowKey(Event event) {
        this.checkWidget();
        if (this.enableTraverse) {
            return true;
        }
        return this.list.allowTraverseByArrowKey(event);
    }

    protected boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return false;
        }
        if (!event.doit) {
            return false;
        }
        if (this.allowTraverseByArrowKey(event)) {
            return this.traverseByArrowKey(event);
        }
        return super.traverse(event);
    }

    void internal_processPressedKeyEvent(KeyEvent e) {
        Event event = new Event();
        event.doit = false;
        event.keyCode = e.keyCode;
        SortedList thisSortedList = this;
        if (0x1000001 == e.keyCode) {
            event.widget = e.widget;
            event.detail = 32;
            if (this.allowTraverseByArrowKey(event)) {
                event.widget = this;
                event.doit = true;
                this.traverse(event);
                e.doit = event.doit;
            } else if (e.widget == this.filterText) {
                int idx = this.list.getSelectionIndex();
                if (idx > 0) {
                    this.list.setSelection(idx - 1);
                    thisSortedList.internal_sendEvent(13);
                } else if (Platform.isSmartPhone()) {
                    this.list.setSelection(this.list.getItemCount() - 1);
                    thisSortedList.internal_sendEvent(13);
                }
            }
        } else if (0x1000002 == e.keyCode) {
            event.widget = e.widget;
            event.detail = 64;
            if (this.allowTraverseByArrowKey(event)) {
                event.widget = this;
                event.doit = true;
                this.traverse(event);
                e.doit = false;
            } else if (e.widget == this.filterText) {
                int count = this.list.getItemCount();
                int idx = this.list.getSelectionIndex();
                if (idx < count - 1) {
                    this.list.setSelection(idx + 1);
                    thisSortedList.internal_sendEvent(13);
                } else if (Platform.isSmartPhone()) {
                    this.list.setSelection(0);
                    thisSortedList.internal_sendEvent(13);
                }
            }
        } else if (0x1000003 == e.keyCode) {
            event.widget = e.widget;
            event.detail = 32;
            if (this.allowTraverseByArrowKey(event)) {
                event.widget = this;
                event.doit = true;
                this.traverse(event);
                e.doit = false;
            }
        } else if (0x1000004 == e.keyCode) {
            event.widget = e.widget;
            event.detail = 64;
            if (this.allowTraverseByArrowKey(event)) {
                event.widget = this;
                event.doit = true;
                this.traverse(event);
                e.doit = false;
            }
        } else if (13 == e.keyCode) {
            thisSortedList.internal_sendEvent(14);
        } else if (9 == e.keyCode) {
            if (e.stateMask == 131072) {
                this.traverse(8);
            } else {
                this.traverse(16);
            }
        }
    }

    static {
        hackStyle = 0;
    }
}

