/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableEditorImpl;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableViewer
extends StructuredViewer {
    private TableEditorImpl tableViewerImpl;
    private Table table;
    private TableColorAndFontNoOp tableColorAndFont = new TableColorAndFontNoOp();

    public TableViewer(Composite composite) {
        this(composite, 2818);
    }

    public TableViewer(Composite composite, int n) {
        this(new Table(composite, n));
    }

    public TableViewer(Table table) {
        this.table = table;
        this.hookControl((Control)table);
        this.initTableViewerImpl();
    }

    public void add(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        Object[] objectArray2 = this.filter(objectArray);
        int n = 0;
        while (n < objectArray2.length) {
            Object object = objectArray2[n];
            int n2 = this.indexForElement(object);
            this.createItem(object, n2);
            ++n;
        }
    }

    private void createItem(Object object, int n) {
        this.updateItem((Widget)new TableItem(this.getTable(), 0, n), object);
    }

    public void add(Object object) {
        this.add(new Object[]{object});
    }

    public void cancelEditing() {
        this.tableViewerImpl.cancelEditing();
    }

    protected Widget doFindInputItem(Object object) {
        if (this.equals(object, this.getRoot())) {
            return this.getTable();
        }
        return null;
    }

    protected Widget doFindItem(Object object) {
        TableItem[] tableItemArray = this.table.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n];
            Object object2 = tableItem.getData();
            if (object2 != null && this.equals(object2, object)) {
                return tableItem;
            }
            ++n;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object object, boolean bl) {
        if (widget instanceof TableItem) {
            TableItem tableItem = (TableItem)widget;
            if (bl) {
                this.associate(object, (Item)tableItem);
            } else {
                tableItem.setData(object);
                this.mapElement(object, (Widget)tableItem);
            }
            IBaseLabelProvider iBaseLabelProvider = this.getLabelProvider();
            ITableLabelProvider iTableLabelProvider = null;
            ILabelProvider iLabelProvider = null;
            IViewerLabelProvider iViewerLabelProvider = null;
            if (iBaseLabelProvider instanceof ILabelProvider) {
                iLabelProvider = (ILabelProvider)iBaseLabelProvider;
            }
            if (iBaseLabelProvider instanceof IViewerLabelProvider) {
                iViewerLabelProvider = (IViewerLabelProvider)iBaseLabelProvider;
            }
            if (iBaseLabelProvider instanceof ITableLabelProvider) {
                iTableLabelProvider = (ITableLabelProvider)iBaseLabelProvider;
            }
            int n = this.table.getColumnCount();
            TableItem tableItem2 = tableItem;
            this.getColorAndFontCollector().setFontsAndColors(object);
            int n2 = 0;
            while (n2 < n || n2 == 0) {
                String string = "";
                Image image = null;
                this.tableColorAndFont.setFontsAndColors(tableItem2, object, n2);
                if (iTableLabelProvider == null) {
                    if (n2 == 0) {
                        ViewerLabel viewerLabel = new ViewerLabel(tableItem.getText(), tableItem.getImage());
                        if (iViewerLabelProvider != null) {
                            this.buildLabel(viewerLabel, object, iViewerLabelProvider);
                        } else if (iLabelProvider != null) {
                            this.buildLabel(viewerLabel, object, iLabelProvider);
                        }
                        if (tableItem.isDisposed()) {
                            this.unmapElement(object);
                            return;
                        }
                        string = viewerLabel.getText();
                        image = viewerLabel.getImage();
                    }
                } else {
                    string = iTableLabelProvider.getColumnText(object, n2);
                    image = iTableLabelProvider.getColumnImage(object, n2);
                }
                if (string == null) {
                    string = "";
                }
                tableItem2.setText(n2, string);
                if (tableItem2.getImage(n2) != image) {
                    tableItem2.setImage(n2, image);
                }
                ++n2;
            }
            this.getColorAndFontCollector().applyFontsAndColors(tableItem2);
        }
    }

    public void editElement(Object object, int n) {
        this.tableViewerImpl.editElement(object, n);
    }

    public CellEditor[] getCellEditors() {
        return this.tableViewerImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.tableViewerImpl.getCellModifier();
    }

    public Object[] getColumnProperties() {
        return this.tableViewerImpl.getColumnProperties();
    }

    public Control getControl() {
        return this.table;
    }

    public Object getElementAt(int n) {
        TableItem tableItem;
        if (n >= 0 && n < this.table.getItemCount() && (tableItem = this.table.getItem(n)) != null) {
            return tableItem.getData();
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected List getSelectionFromWidget() {
        TableItem[] tableItemArray = this.table.getSelection();
        ArrayList<Object> arrayList = new ArrayList<Object>(tableItemArray.length);
        int n = 0;
        while (n < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n];
            Object object = tableItem.getData();
            if (object != null) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    public Table getTable() {
        return this.table;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Table table = (Table)control;
        table.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent mouseEvent) {
                TableViewer.this.tableViewerImpl.handleMouseDown(mouseEvent);
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
    }

    protected int indexForElement(Object object) {
        ViewerSorter viewerSorter = this.getSorter();
        if (viewerSorter == null) {
            return this.table.getItemCount();
        }
        int n = this.table.getItemCount();
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Object object2 = this.table.getItem(n4).getData();
            int n5 = viewerSorter.compare(this, object2, object);
            if (n5 == 0) {
                while (n5 == 0) {
                    if (++n4 >= n) break;
                    object2 = this.table.getItem(n4).getData();
                    n5 = viewerSorter.compare(this, object2, object);
                }
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2;
    }

    private void initTableViewerImpl() {
        this.tableViewerImpl = new TableEditorImpl(this){

            Rectangle getBounds(Item item, int n) {
                return ((TableItem)item).getBounds(n);
            }

            int getColumnCount() {
                return TableViewer.this.getTable().getColumnCount();
            }

            Item[] getSelection() {
                return TableViewer.this.getTable().getSelection();
            }

            void setEditor(Control control, Item item, int n) {
            }

            void setSelection(StructuredSelection structuredSelection, boolean bl) {
                TableViewer.this.setSelection(structuredSelection, bl);
            }

            void showSelection() {
                TableViewer.this.getTable().showSelection();
            }

            void setLayoutData(CellEditor.LayoutData layoutData) {
            }

            void handleDoubleClickEvent() {
                StructuredViewer structuredViewer = this.getViewer();
                TableViewer.this.fireDoubleClick(new DoubleClickEvent(structuredViewer, ((Viewer)structuredViewer).getSelection()));
                TableViewer.this.fireOpen(new OpenEvent(structuredViewer, ((Viewer)structuredViewer).getSelection()));
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void inputChanged(Object object, Object object2) {
        this.getControl().setRedraw(false);
        try {
            this.refresh();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.getControl().setRedraw(true);
    }

    public void insert(Object object, int n) {
        this.tableViewerImpl.applyEditorValue();
        if (this.getSorter() != null || this.hasFilters()) {
            this.add(object);
            return;
        }
        if (n == -1) {
            n = this.table.getItemCount();
        }
        this.createItem(object, n);
    }

    protected void internalRefresh(Object object) {
        this.internalRefresh(object, true);
    }

    protected void internalRefresh(Object object, boolean bl) {
        this.tableViewerImpl.applyEditorValue();
        if (object == null || this.equals(object, this.getRoot())) {
            this.internalRefreshAll(bl);
        } else {
            Widget widget = this.findItem(object);
            if (widget != null) {
                this.updateItem(widget, object);
            }
        }
    }

    private void internalRefreshAll(boolean bl) {
        TableItem tableItem;
        Object[] objectArray = this.getSortedChildren(this.getRoot());
        TableItem[] tableItemArray = this.getTable().getItems();
        int n = Math.min(objectArray.length, tableItemArray.length);
        int n2 = 0;
        while (n2 < n) {
            tableItem = tableItemArray[n2];
            if (this.equals(objectArray[n2], tableItem.getData())) {
                if (bl) {
                    this.updateItem((Widget)tableItem, objectArray[n2]);
                } else {
                    this.associate(objectArray[n2], (Item)tableItem);
                }
            } else {
                tableItem.setText("");
                tableItem.setImage(new Image[Math.max(1, this.table.getColumnCount())]);
                this.disassociate((Item)tableItem);
            }
            ++n2;
        }
        if (n < tableItemArray.length) {
            n2 = tableItemArray.length;
            while (--n2 >= n) {
                this.disassociate((Item)tableItemArray[n2]);
            }
            this.table.remove(n, tableItemArray.length - 1);
        }
        if (this.table.getItemCount() == 0) {
            this.table.removeAll();
        }
        n2 = 0;
        while (n2 < n) {
            tableItem = tableItemArray[n2];
            if (tableItem.getData() == null) {
                this.updateItem((Widget)tableItem, objectArray[n2]);
            }
            ++n2;
        }
        n2 = n;
        while (n2 < objectArray.length) {
            this.createItem(objectArray[n2], n2);
            ++n2;
        }
    }

    private void internalRemove(Object[] objectArray) {
        Object object = this.getInput();
        int n = 0;
        while (n < objectArray.length) {
            if (this.equals(objectArray[n], object)) {
                this.setInput(null);
                return;
            }
            ++n;
        }
        int[] nArray = new int[objectArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            Widget widget = this.findItem(objectArray[n3]);
            if (widget instanceof TableItem) {
                TableItem tableItem = (TableItem)widget;
                this.disassociate((Item)tableItem);
                nArray[n2++] = this.table.indexOf(tableItem);
            }
            ++n3;
        }
        if (n2 < nArray.length) {
            int[] nArray2 = nArray;
            nArray = new int[n2];
            System.arraycopy(nArray2, 0, nArray, 0, n2);
        }
        this.table.remove(nArray);
        if (this.table.getItemCount() == 0) {
            this.table.removeAll();
        }
    }

    public boolean isCellEditorActive() {
        return this.tableViewerImpl.isCellEditorActive();
    }

    public void remove(final Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        this.preservingSelection(new Runnable(){

            public void run() {
                TableViewer.this.internalRemove(objectArray);
            }
        });
    }

    public void remove(Object object) {
        this.remove(new Object[]{object});
    }

    public void reveal(Object object) {
        Assert.isNotNull(object);
        Widget widget = this.findItem(object);
        if (widget instanceof TableItem) {
            this.getTable().showItem((TableItem)widget);
        }
    }

    public void setCellEditors(CellEditor[] cellEditorArray) {
        this.tableViewerImpl.setCellEditors(cellEditorArray);
    }

    public void setCellModifier(ICellModifier iCellModifier) {
        this.tableViewerImpl.setCellModifier(iCellModifier);
    }

    public void setColumnProperties(String[] stringArray) {
        this.tableViewerImpl.setColumnProperties(stringArray);
    }

    public void setLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        Assert.isTrue(iBaseLabelProvider instanceof ITableLabelProvider || iBaseLabelProvider instanceof ILabelProvider);
        super.setLabelProvider(iBaseLabelProvider);
        this.tableColorAndFont = iBaseLabelProvider instanceof ITableFontProvider || iBaseLabelProvider instanceof ITableColorProvider ? new TableColorAndFontCollector(iBaseLabelProvider) : new TableColorAndFontNoOp();
    }

    protected void setSelectionToWidget(List list, boolean bl) {
        if (list == null) {
            this.table.deselectAll();
            return;
        }
        int n = list.size();
        TableItem[] tableItemArray = new TableItem[n];
        TableItem tableItem = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Object e = list.get(n3);
            Widget widget = this.findItem(e);
            if (widget instanceof TableItem) {
                TableItem tableItem2 = (TableItem)widget;
                tableItemArray[n2++] = tableItem2;
                if (tableItem == null) {
                    tableItem = tableItem2;
                }
            }
            ++n3;
        }
        if (n2 < n) {
            TableItem[] tableItemArray2 = tableItemArray;
            tableItemArray = new TableItem[n2];
            System.arraycopy(tableItemArray2, 0, tableItemArray, 0, n2);
        }
        this.table.setSelection(tableItemArray);
        if (bl && tableItem != null) {
            this.table.showItem(tableItem);
        }
    }

    public void replace(Object object, int n) {
        TableItem tableItem = this.getTable().getItem(n);
        this.refreshItem((Widget)tableItem, object);
    }

    public void clear(int n) {
        TableItem tableItem = this.getTable().getItem(n);
        if (tableItem.getData() != null) {
            this.disassociate((Item)tableItem);
        }
        this.table.remove(n);
    }

    protected Object[] getRawChildren(Object object) {
        Assert.isTrue(!(this.getContentProvider() instanceof ILazyContentProvider), "Cannot get raw children with an ILazyContentProvider");
        return super.getRawChildren(object);
    }

    protected void assertContentProviderType(IContentProvider iContentProvider) {
        Assert.isTrue(iContentProvider instanceof IStructuredContentProvider || iContentProvider instanceof ILazyContentProvider);
    }

    private class TableColorAndFontNoOp {
        TableColorAndFontNoOp() {
        }

        public void setFontsAndColors(TableItem tableItem, Object object, int n) {
        }
    }

    private class TableColorAndFontCollector
    extends TableColorAndFontNoOp {
        ITableFontProvider fontProvider = null;
        ITableColorProvider colorProvider = null;

        public TableColorAndFontCollector(IBaseLabelProvider iBaseLabelProvider) {
            if (iBaseLabelProvider instanceof ITableFontProvider) {
                this.fontProvider = (ITableFontProvider)((Object)iBaseLabelProvider);
            }
            if (iBaseLabelProvider instanceof ITableColorProvider) {
                this.colorProvider = (ITableColorProvider)((Object)iBaseLabelProvider);
            }
        }

        public void setFontsAndColors(TableItem tableItem, Object object, int n) {
            if (this.colorProvider != null) {
                tableItem.setBackground(n, this.colorProvider.getBackground(object, n));
                tableItem.setForeground(n, this.colorProvider.getForeground(object, n));
            }
            if (this.fontProvider != null) {
                tableItem.setFont(n, this.fontProvider.getFont(object, n));
            }
        }
    }
}

