/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.IIterable;
import org.eclipse.core.internal.expressions.CompositeExpression;
import org.eclipse.core.internal.expressions.DefaultVariable;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class IterateExpression
extends CompositeExpression {
    private static final String ATT_OPERATOR = "operator";
    private static final String ATT_IF_EMPTY = "ifEmpty";
    private static final int OR = 1;
    private static final int AND = 2;
    private static final int HASH_INITIAL;
    private int fOperator;
    private Boolean fEmptyResult;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.expressions.IterateExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    public IterateExpression(IConfigurationElement iConfigurationElement) throws CoreException {
        String string = iConfigurationElement.getAttribute(ATT_OPERATOR);
        this.initializeOperatorValue(string);
        this.initializeEmptyResultValue(iConfigurationElement.getAttribute(ATT_IF_EMPTY));
    }

    public IterateExpression(Element element) throws CoreException {
        String string = element.getAttribute(ATT_OPERATOR);
        this.initializeOperatorValue(string.length() > 0 ? string : null);
        String string2 = element.getAttribute(ATT_IF_EMPTY);
        this.initializeEmptyResultValue(string2.length() > 0 ? string2 : null);
    }

    public IterateExpression(String string) throws CoreException {
        this.initializeOperatorValue(string);
    }

    public IterateExpression(String string, String string2) throws CoreException {
        this.initializeOperatorValue(string);
        this.initializeEmptyResultValue(string2);
    }

    private void initializeOperatorValue(String string) throws CoreException {
        if (string == null) {
            this.fOperator = 2;
        } else {
            Expressions.checkAttribute(ATT_OPERATOR, string, new String[]{"and", "or"});
            this.fOperator = "and".equals(string) ? 2 : 1;
        }
    }

    private void initializeEmptyResultValue(String string) {
        this.fEmptyResult = string == null ? null : Boolean.valueOf(string);
    }

    public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
        Object object = iEvaluationContext.getDefaultVariable();
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            switch (collection.size()) {
                case 0: {
                    if (this.fEmptyResult == null) {
                        return this.fOperator == 2 ? EvaluationResult.TRUE : EvaluationResult.FALSE;
                    }
                    return this.fEmptyResult != false ? EvaluationResult.TRUE : EvaluationResult.FALSE;
                }
                case 1: {
                    if (!(collection instanceof List)) break;
                    return this.evaluateAnd(new DefaultVariable(iEvaluationContext, ((List)collection).get(0)));
                }
            }
            IteratePool iteratePool = new IteratePool(iEvaluationContext, collection.iterator());
            EvaluationResult evaluationResult = this.fOperator == 2 ? EvaluationResult.TRUE : EvaluationResult.FALSE;
            while (iteratePool.hasNext()) {
                iteratePool.next();
                switch (this.fOperator) {
                    case 1: {
                        evaluationResult = evaluationResult.or(this.evaluateAnd(iteratePool));
                        if (evaluationResult != EvaluationResult.TRUE) break;
                        return evaluationResult;
                    }
                    case 2: {
                        evaluationResult = evaluationResult.and(this.evaluateAnd(iteratePool));
                        if (evaluationResult == EvaluationResult.TRUE) break;
                        return evaluationResult;
                    }
                }
            }
            return evaluationResult;
        }
        IIterable iIterable = Expressions.getAsIIterable(object, this);
        if (iIterable == null) {
            return EvaluationResult.NOT_LOADED;
        }
        int n = 0;
        IteratePool iteratePool = new IteratePool(iEvaluationContext, iIterable.iterator());
        EvaluationResult evaluationResult = this.fOperator == 2 ? EvaluationResult.TRUE : EvaluationResult.FALSE;
        while (iteratePool.hasNext()) {
            iteratePool.next();
            ++n;
            switch (this.fOperator) {
                case 1: {
                    evaluationResult = evaluationResult.or(this.evaluateAnd(iteratePool));
                    if (evaluationResult != EvaluationResult.TRUE) break;
                    return evaluationResult;
                }
                case 2: {
                    evaluationResult = evaluationResult.and(this.evaluateAnd(iteratePool));
                    if (evaluationResult == EvaluationResult.TRUE) break;
                    return evaluationResult;
                }
            }
        }
        if (n > 0) {
            return evaluationResult;
        }
        if (this.fEmptyResult == null) {
            return this.fOperator == 2 ? EvaluationResult.TRUE : EvaluationResult.FALSE;
        }
        return this.fEmptyResult != false ? EvaluationResult.TRUE : EvaluationResult.FALSE;
    }

    public void collectExpressionInfo(ExpressionInfo expressionInfo) {
        expressionInfo.markDefaultVariableAccessed();
        super.collectExpressionInfo(expressionInfo);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IterateExpression)) {
            return false;
        }
        IterateExpression iterateExpression = (IterateExpression)object;
        return this.fOperator == iterateExpression.fOperator && IterateExpression.equals(this.fExpressions, iterateExpression.fExpressions);
    }

    protected int computeHashCode() {
        return HASH_INITIAL * 89 + IterateExpression.hashCode(this.fExpressions) * 89 + this.fOperator;
    }

    private static class IteratePool
    implements IEvaluationContext {
        private Iterator fIterator;
        private Object fDefaultVariable;
        private IEvaluationContext fParent;

        public IteratePool(IEvaluationContext iEvaluationContext, Iterator iterator) {
            Assert.isNotNull((Object)iEvaluationContext);
            Assert.isNotNull((Object)iterator);
            this.fParent = iEvaluationContext;
            this.fIterator = iterator;
        }

        public IEvaluationContext getParent() {
            return this.fParent;
        }

        public IEvaluationContext getRoot() {
            return this.fParent.getRoot();
        }

        public Object getDefaultVariable() {
            return this.fDefaultVariable;
        }

        public boolean getAllowPluginActivation() {
            return this.fParent.getAllowPluginActivation();
        }

        public void setAllowPluginActivation(boolean bl) {
            this.fParent.setAllowPluginActivation(bl);
        }

        public void addVariable(String string, Object object) {
            this.fParent.addVariable(string, object);
        }

        public Object removeVariable(String string) {
            return this.fParent.removeVariable(string);
        }

        public Object getVariable(String string) {
            return this.fParent.getVariable(string);
        }

        public Object resolveVariable(String string, Object[] objectArray) throws CoreException {
            return this.fParent.resolveVariable(string, objectArray);
        }

        public Object next() {
            this.fDefaultVariable = this.fIterator.next();
            return this.fDefaultVariable;
        }

        public boolean hasNext() {
            return this.fIterator.hasNext();
        }
    }
}

