/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IToggleSiteOperation;
import org.eclipse.update.operations.OperationsManager;

public class ToggleSiteOperation
extends Operation
implements IToggleSiteOperation {
    private IConfiguredSite site;

    public ToggleSiteOperation(IConfiguredSite iConfiguredSite) {
        this.site = iConfiguredSite;
    }

    public boolean execute(IProgressMonitor iProgressMonitor, IOperationListener iOperationListener) throws CoreException {
        if (this.site == null) {
            return false;
        }
        boolean bl = this.site.isEnabled();
        this.site.setEnabled(!bl);
        IStatus iStatus = OperationsManager.getValidator().validateCurrentState();
        if (iStatus != null) {
            this.site.setEnabled(bl);
            throw new CoreException(iStatus);
        }
        try {
            boolean bl2 = SiteManager.getLocalSite().save();
            OperationsManager.fireObjectChanged(this.site, "");
            return bl2;
        }
        catch (CoreException coreException) {
            this.site.setEnabled(bl);
            UpdateUtils.logException(coreException);
            throw coreException;
        }
    }
}

