/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FilterImpl
implements Filter {
    protected int operation;
    protected static final int EQUAL = 1;
    protected static final int APPROX = 2;
    protected static final int GREATER = 3;
    protected static final int LESS = 4;
    protected static final int PRESENT = 5;
    protected static final int SUBSTRING = 6;
    protected static final int AND = 7;
    protected static final int OR = 8;
    protected static final int NOT = 9;
    protected String attr;
    protected Object value;
    protected String filter;
    protected boolean topLevel;
    protected static final Class[] constructorType;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        constructorType = classArray;
    }

    public FilterImpl(String string) throws InvalidSyntaxException {
        this.topLevel = true;
        new Parser(string).parse(this);
    }

    public boolean match(ServiceReference serviceReference) {
        return this.match0(((ServiceReferenceImpl)serviceReference).registration.getProperties());
    }

    public boolean match(Dictionary dictionary) {
        if (dictionary != null) {
            dictionary = new Headers(dictionary);
        }
        return this.match0(dictionary);
    }

    public boolean matchCase(Dictionary dictionary) {
        return this.match0(dictionary);
    }

    public String toString() {
        if (this.filter == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            switch (this.operation) {
                case 7: {
                    stringBuffer.append('&');
                    FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                    int n = filterImplArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        stringBuffer.append(filterImplArray[n2].toString());
                        ++n2;
                    }
                    break;
                }
                case 8: {
                    stringBuffer.append('|');
                    FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                    int n = filterImplArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        stringBuffer.append(filterImplArray[n3].toString());
                        ++n3;
                    }
                    break;
                }
                case 9: {
                    stringBuffer.append('!');
                    stringBuffer.append(this.value.toString());
                    break;
                }
                case 6: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append('=');
                    String[] stringArray = (String[])this.value;
                    int n = stringArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String string = stringArray[n4];
                        if (string == null) {
                            stringBuffer.append('*');
                        } else {
                            stringBuffer.append(FilterImpl.encodeValue(string));
                        }
                        ++n4;
                    }
                    break;
                }
                case 1: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append('=');
                    stringBuffer.append(FilterImpl.encodeValue(this.value.toString()));
                    break;
                }
                case 3: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append(">=");
                    stringBuffer.append(FilterImpl.encodeValue(this.value.toString()));
                    break;
                }
                case 4: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append("<=");
                    stringBuffer.append(FilterImpl.encodeValue(this.value.toString()));
                    break;
                }
                case 2: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append("~=");
                    stringBuffer.append(FilterImpl.encodeValue(FilterImpl.approxString(this.value.toString())));
                    break;
                }
                case 5: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append("=*");
                }
            }
            stringBuffer.append(')');
            if (this.topLevel) {
                this.filter = ((Object)stringBuffer).toString();
            } else {
                return ((Object)stringBuffer).toString();
            }
        }
        return this.filter;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilterImpl)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected FilterImpl() {
        this.topLevel = false;
    }

    protected void setFilter(int n, String string, Object object) {
        this.operation = n;
        this.attr = string;
        this.value = object;
    }

    protected boolean match(ServiceReferenceImpl serviceReferenceImpl) {
        return this.match0(serviceReferenceImpl.registration.getProperties());
    }

    protected boolean match0(Dictionary dictionary) {
        switch (this.operation) {
            case 7: {
                FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                int n = filterImplArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (!filterImplArray[n2].match0(dictionary)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            case 8: {
                FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                int n = filterImplArray.length;
                int n3 = 0;
                while (n3 < n) {
                    if (filterImplArray[n3].match0(dictionary)) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            case 9: {
                FilterImpl filterImpl = (FilterImpl)this.value;
                return !filterImpl.match0(dictionary);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                Object var2_5 = dictionary == null ? null : dictionary.get(this.attr);
                return this.compare(this.operation, var2_5, this.value);
            }
            case 5: {
                Object var2_6;
                if (Debug.DEBUG_FILTER) {
                    Debug.println("PRESENT(" + this.attr + ")");
                }
                Object v0 = var2_6 = dictionary == null ? null : dictionary.get(this.attr);
                return var2_6 != null;
            }
        }
        return false;
    }

    protected static String encodeValue(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = n << 1;
        char[] cArray = new char[n2];
        string.getChars(0, n, cArray, n);
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            char c = cArray[n4];
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    cArray[n3] = 92;
                    ++n3;
                    bl = true;
                }
            }
            cArray[n3] = c;
            ++n3;
            ++n4;
        }
        return bl ? new String(cArray, 0, n3) : string;
    }

    protected boolean compare(int n, Object object, Object object2) {
        if (object == null) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("compare(" + object + "," + object2 + ")");
            }
            return false;
        }
        if (object instanceof String) {
            return this.compare_String(n, (String)object, object2);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                return this.compare_PrimitiveArray(n, clazz2, object, object2);
            }
            return this.compare_ObjectArray(n, (Object[])object, object2);
        }
        if (object instanceof Collection) {
            return this.compare_Collection(n, (Collection)object, object2);
        }
        if (object instanceof Integer) {
            return this.compare_Integer(n, (Integer)object, object2);
        }
        if (object instanceof Long) {
            return this.compare_Long(n, (Long)object, object2);
        }
        if (object instanceof Byte) {
            return this.compare_Byte(n, (Byte)object, object2);
        }
        if (object instanceof Short) {
            return this.compare_Short(n, (Short)object, object2);
        }
        if (object instanceof Character) {
            return this.compare_Character(n, ((Character)object).charValue(), object2);
        }
        if (object instanceof Float) {
            return this.compare_Float(n, ((Float)object).floatValue(), object2);
        }
        if (object instanceof Double) {
            return this.compare_Double(n, (Double)object, object2);
        }
        if (object instanceof Boolean) {
            return this.compare_Boolean(n, (Boolean)object, object2);
        }
        if (object instanceof Comparable) {
            return this.compare_Comparable(n, (Comparable)object, object2);
        }
        return this.compare_Unknown(n, object, object2);
    }

    protected boolean compare_Collection(int n, Collection collection, Object object) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.compare(n, iterator.next(), object)) continue;
            return true;
        }
        return false;
    }

    protected boolean compare_ObjectArray(int n, Object[] objectArray, Object object) {
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.compare(n, objectArray[n3], object)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    protected boolean compare_PrimitiveArray(int n, Class clazz, Object object, Object object2) {
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            int[] nArray = (int[])object;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.compare_Integer(n, nArray[n3], object2)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            long[] lArray = (long[])object;
            int n4 = lArray.length;
            int n5 = 0;
            while (n5 < n4) {
                if (this.compare_Long(n, lArray[n5], object2)) {
                    return true;
                }
                ++n5;
            }
            return false;
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            byte[] byArray = (byte[])object;
            int n6 = byArray.length;
            int n7 = 0;
            while (n7 < n6) {
                if (this.compare_Byte(n, byArray[n7], object2)) {
                    return true;
                }
                ++n7;
            }
            return false;
        }
        if (Short.TYPE.isAssignableFrom(clazz)) {
            short[] sArray = (short[])object;
            int n8 = sArray.length;
            int n9 = 0;
            while (n9 < n8) {
                if (this.compare_Short(n, sArray[n9], object2)) {
                    return true;
                }
                ++n9;
            }
            return false;
        }
        if (Character.TYPE.isAssignableFrom(clazz)) {
            char[] cArray = (char[])object;
            int n10 = cArray.length;
            int n11 = 0;
            while (n11 < n10) {
                if (this.compare_Character(n, cArray[n11], object2)) {
                    return true;
                }
                ++n11;
            }
            return false;
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            float[] fArray = (float[])object;
            int n12 = fArray.length;
            int n13 = 0;
            while (n13 < n12) {
                if (this.compare_Float(n, fArray[n13], object2)) {
                    return true;
                }
                ++n13;
            }
            return false;
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            double[] dArray = (double[])object;
            int n14 = dArray.length;
            int n15 = 0;
            while (n15 < n14) {
                if (this.compare_Double(n, dArray[n15], object2)) {
                    return true;
                }
                ++n15;
            }
            return false;
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            boolean[] blArray = (boolean[])object;
            int n16 = blArray.length;
            int n17 = 0;
            while (n17 < n16) {
                if (this.compare_Boolean(n, blArray[n17], object2)) {
                    return true;
                }
                ++n17;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean compare_String(int n, String string, Object object) {
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + string + "," + object + ")");
                }
                String[] stringArray = (String[])object;
                int n2 = 0;
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string2 = stringArray[n4];
                    if (n4 + 1 < n3) {
                        if (string2 == null) {
                            String string3 = stringArray[n4 + 1];
                            if (string3 != null) {
                                int n5;
                                if (Debug.DEBUG_FILTER) {
                                    Debug.println("indexOf(\"" + string3 + "\"," + n2 + ")");
                                }
                                if ((n5 = string.indexOf(string3, n2)) == -1) {
                                    return false;
                                }
                                n2 = n5 + string3.length();
                                if (n4 + 2 < n3) {
                                    ++n4;
                                }
                            }
                        } else {
                            int n6 = string2.length();
                            if (Debug.DEBUG_FILTER) {
                                Debug.println("regionMatches(" + n2 + ",\"" + string2 + "\")");
                            }
                            if (!string.regionMatches(n2, string2, 0, n6)) return false;
                            n2 += n6;
                        }
                    } else {
                        if (string2 == null) {
                            return true;
                        }
                        if (!Debug.DEBUG_FILTER) return string.endsWith(string2);
                        Debug.println("regionMatches(" + n2 + "," + string2 + ")");
                        return string.endsWith(string2);
                    }
                    ++n4;
                }
                return true;
            }
            case 1: {
                if (!Debug.DEBUG_FILTER) return string.equals(object);
                Debug.println("EQUAL(" + string + "," + object + ")");
                return string.equals(object);
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + string + "," + object + ")");
                }
                string = FilterImpl.approxString(string);
                String string4 = FilterImpl.approxString((String)object);
                return string.equalsIgnoreCase(string4);
            }
            case 3: {
                if (!Debug.DEBUG_FILTER) return string.compareTo((String)object) >= 0;
                Debug.println("GREATER(" + string + "," + object + ")");
                return string.compareTo((String)object) >= 0;
            }
            case 4: {
                if (!Debug.DEBUG_FILTER) return string.compareTo((String)object) <= 0;
                Debug.println("LESS(" + string + "," + object + ")");
                return string.compareTo((String)object) <= 0;
            }
        }
        return false;
    }

    protected boolean compare_Integer(int n, int n2, Object object) {
        int n3 = Integer.parseInt(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + n2 + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + n2 + "," + object + ")");
                }
                return n2 == n3;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + n2 + "," + object + ")");
                }
                return n2 == n3;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + n2 + "," + object + ")");
                }
                return n2 >= n3;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + n2 + "," + object + ")");
                }
                return n2 <= n3;
            }
        }
        return false;
    }

    protected boolean compare_Long(int n, long l, Object object) {
        long l2 = Long.parseLong(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + l + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + l + "," + object + ")");
                }
                return l == l2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + l + "," + object + ")");
                }
                return l == l2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + l + "," + object + ")");
                }
                return l >= l2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + l + "," + object + ")");
                }
                return l <= l2;
            }
        }
        return false;
    }

    protected boolean compare_Byte(int n, byte by, Object object) {
        byte by2 = Byte.parseByte(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + by + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + by + "," + object + ")");
                }
                return by == by2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + by + "," + object + ")");
                }
                return by == by2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + by + "," + object + ")");
                }
                return by >= by2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + by + "," + object + ")");
                }
                return by <= by2;
            }
        }
        return false;
    }

    protected boolean compare_Short(int n, short s, Object object) {
        short s2 = Short.parseShort(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + s + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + s + "," + object + ")");
                }
                return s == s2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + s + "," + object + ")");
                }
                return s == s2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + s + "," + object + ")");
                }
                return s >= s2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + s + "," + object + ")");
                }
                return s <= s2;
            }
        }
        return false;
    }

    protected boolean compare_Character(int n, char c, Object object) {
        char c2 = ((String)object).trim().charAt(0);
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + c + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + c + "," + object + ")");
                }
                return c == c2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + c + "," + object + ")");
                }
                return Character.toLowerCase(c) == Character.toLowerCase(c2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + c + "," + object + ")");
                }
                return c >= c2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + c + "," + object + ")");
                }
                return c <= c2;
            }
        }
        return false;
    }

    protected boolean compare_Boolean(int n, boolean bl, Object object) {
        boolean bl2 = new Boolean(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + bl + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + bl + "," + object + ")");
                }
                return bl == bl2;
            }
        }
        return false;
    }

    protected boolean compare_Float(int n, float f, Object object) {
        float f2 = Float.parseFloat(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + f + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + f + "," + object + ")");
                }
                return f == f2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + f + "," + object + ")");
                }
                return f == f2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + f + "," + object + ")");
                }
                return f >= f2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + f + "," + object + ")");
                }
                return f <= f2;
            }
        }
        return false;
    }

    protected boolean compare_Double(int n, double d, Object object) {
        double d2 = Double.parseDouble(((String)object).trim());
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + d + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + d + "," + object + ")");
                }
                return d == d2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + d + "," + object + ")");
                }
                return d == d2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + d + "," + object + ")");
                }
                return d >= d2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + d + "," + object + ")");
                }
                return d <= d2;
            }
        }
        return false;
    }

    protected boolean compare_Comparable(int n, Comparable comparable, Object object) {
        Constructor<?> constructor;
        try {
            constructor = comparable.getClass().getConstructor(constructorType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        try {
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(constructor));
            }
            object = constructor.newInstance(((String)object).trim());
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + comparable + "," + object + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) == 0;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) == 0;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + comparable + "," + object + ")");
                }
                return comparable.compareTo(object) <= 0;
            }
        }
        return false;
    }

    protected boolean compare_Unknown(int n, Object object, Object object2) {
        Constructor<?> constructor;
        try {
            constructor = object.getClass().getConstructor(constructorType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("Type not supported");
            }
            return false;
        }
        try {
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(constructor));
            }
            object2 = constructor.newInstance(((String)object2).trim());
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + object + "," + object2 + ")");
                }
                return false;
            }
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("EQUAL(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("GREATER(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("LESS(" + object + "," + object2 + ")");
                }
                return object.equals(object2);
            }
        }
        return false;
    }

    protected static String approxString(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if (Character.isWhitespace(c)) {
                bl = true;
            } else {
                cArray[n2] = c;
                ++n2;
            }
            ++n3;
        }
        return bl ? new String(cArray, 0, n2) : string;
    }

    public String getRequiredObjectClass() {
        switch (this.operation) {
            case 1: {
                if (!this.attr.equalsIgnoreCase("objectClass") || !(this.value instanceof String)) break;
                return (String)this.value;
            }
            case 7: {
                FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                int n = 0;
                while (n < filterImplArray.length) {
                    String string;
                    if (filterImplArray[n].operation == 1 && (string = filterImplArray[n].getRequiredObjectClass()) != null) {
                        return string;
                    }
                    ++n;
                }
                break;
            }
        }
        return null;
    }

    public static String getObjectClassFilterString(String string) {
        if (string == null) {
            return null;
        }
        return "(objectClass=" + string + ")";
    }

    public String[] getAttributes() {
        ArrayList arrayList = new ArrayList();
        this.getAttributesInternal(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void getAttributesInternal(ArrayList arrayList) {
        if (this.value instanceof FilterImpl[]) {
            FilterImpl[] filterImplArray = (FilterImpl[])this.value;
            int n = 0;
            while (n < filterImplArray.length) {
                filterImplArray[n].getAttributesInternal(arrayList);
                ++n;
            }
            return;
        }
        if (this.value instanceof FilterImpl) {
            ((FilterImpl)this.value).getAttributesInternal(arrayList);
            return;
        }
        if (this.attr != null) {
            arrayList.add(this.attr);
        }
    }

    static class Parser {
        protected String filterstring;
        protected char[] filter;
        protected int pos;

        protected Parser(String string) {
            this.filterstring = string;
            this.filter = string.toCharArray();
            this.pos = 0;
        }

        protected void parse(FilterImpl filterImpl) throws InvalidSyntaxException {
            try {
                this.parse_filter(filterImpl);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new InvalidSyntaxException(Msg.FILTER_TERMINATED_ABRUBTLY, this.filterstring);
            }
            if (this.pos != this.filter.length) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_TRAILING_CHARACTERS, String.valueOf(this.pos)), this.filterstring);
            }
        }

        protected void parse_filter(FilterImpl filterImpl) throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filter[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
            }
            ++this.pos;
            this.parse_filtercomp(filterImpl);
            this.skipWhiteSpace();
            if (this.filter[this.pos] != ')') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_RIGHTPAREN, String.valueOf(this.pos)), this.filterstring);
            }
            ++this.pos;
            this.skipWhiteSpace();
        }

        protected void parse_filtercomp(FilterImpl filterImpl) throws InvalidSyntaxException {
            this.skipWhiteSpace();
            char c = this.filter[this.pos];
            switch (c) {
                case '&': {
                    ++this.pos;
                    this.parse_and(filterImpl);
                    break;
                }
                case '|': {
                    ++this.pos;
                    this.parse_or(filterImpl);
                    break;
                }
                case '!': {
                    ++this.pos;
                    this.parse_not(filterImpl);
                    break;
                }
                default: {
                    this.parse_item(filterImpl);
                }
            }
        }

        protected void parse_and(FilterImpl filterImpl) throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filter[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
            }
            ArrayList<FilterImpl> arrayList = new ArrayList<FilterImpl>(10);
            while (this.filter[this.pos] == '(') {
                FilterImpl filterImpl2 = new FilterImpl();
                this.parse_filter(filterImpl2);
                arrayList.add(filterImpl2);
            }
            int n = arrayList.size();
            FilterImpl[] filterImplArray = new FilterImpl[n];
            arrayList.toArray(filterImplArray);
            filterImpl.setFilter(7, null, filterImplArray);
        }

        protected void parse_or(FilterImpl filterImpl) throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filter[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
            }
            ArrayList<FilterImpl> arrayList = new ArrayList<FilterImpl>(10);
            while (this.filter[this.pos] == '(') {
                FilterImpl filterImpl2 = new FilterImpl();
                this.parse_filter(filterImpl2);
                arrayList.add(filterImpl2);
            }
            int n = arrayList.size();
            FilterImpl[] filterImplArray = new FilterImpl[n];
            arrayList.toArray(filterImplArray);
            filterImpl.setFilter(8, null, filterImplArray);
        }

        protected void parse_not(FilterImpl filterImpl) throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filter[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, String.valueOf(this.pos)), this.filterstring);
            }
            FilterImpl filterImpl2 = new FilterImpl();
            this.parse_filter(filterImpl2);
            filterImpl.setFilter(9, null, filterImpl2);
        }

        protected void parse_item(FilterImpl filterImpl) throws InvalidSyntaxException {
            String string = this.parse_attr();
            this.skipWhiteSpace();
            switch (this.filter[this.pos]) {
                case '~': {
                    if (this.filter[this.pos + 1] != '=') break;
                    this.pos += 2;
                    filterImpl.setFilter(2, string, this.parse_value());
                    return;
                }
                case '>': {
                    if (this.filter[this.pos + 1] != '=') break;
                    this.pos += 2;
                    filterImpl.setFilter(3, string, this.parse_value());
                    return;
                }
                case '<': {
                    if (this.filter[this.pos + 1] != '=') break;
                    this.pos += 2;
                    filterImpl.setFilter(4, string, this.parse_value());
                    return;
                }
                case '=': {
                    if (this.filter[this.pos + 1] == '*') {
                        int n = this.pos;
                        this.pos += 2;
                        this.skipWhiteSpace();
                        if (this.filter[this.pos] == ')') {
                            filterImpl.setFilter(5, string, null);
                            return;
                        }
                        this.pos = n;
                    }
                    ++this.pos;
                    Object object = this.parse_substring();
                    if (object instanceof String) {
                        filterImpl.setFilter(1, string, object);
                    } else {
                        filterImpl.setFilter(6, string, object);
                    }
                    return;
                }
            }
            throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_OPERATOR, String.valueOf(this.pos)), this.filterstring);
        }

        protected String parse_attr() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            int n = this.pos;
            int n2 = this.pos;
            char c = this.filter[this.pos];
            while ("~<>=()".indexOf(c) == -1) {
                ++this.pos;
                if (!Character.isWhitespace(c)) {
                    n2 = this.pos;
                }
                c = this.filter[this.pos];
            }
            int n3 = n2 - n;
            if (n3 == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_ATTR, String.valueOf(this.pos)), this.filterstring);
            }
            return new String(this.filter, n, n3);
        }

        protected String parse_value() throws InvalidSyntaxException {
            StringBuffer stringBuffer = new StringBuffer(this.filter.length - this.pos);
            block5: while (true) {
                char c = this.filter[this.pos];
                switch (c) {
                    case ')': {
                        break block5;
                    }
                    case '(': {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, String.valueOf(this.pos)), this.filterstring);
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.filter[this.pos];
                    }
                    default: {
                        stringBuffer.append(c);
                        ++this.pos;
                        continue block5;
                    }
                }
                break;
            }
            if (stringBuffer.length() == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_VALUE, String.valueOf(this.pos)), this.filterstring);
            }
            return ((Object)stringBuffer).toString();
        }

        protected Object parse_substring() throws InvalidSyntaxException {
            Object object;
            int n;
            StringBuffer stringBuffer = new StringBuffer(this.filter.length - this.pos);
            ArrayList<String> arrayList = new ArrayList<String>(10);
            block6: while (true) {
                n = this.filter[this.pos];
                switch (n) {
                    case 41: {
                        if (stringBuffer.length() <= 0) break block6;
                        arrayList.add(((Object)stringBuffer).toString());
                        break block6;
                    }
                    case 40: {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, String.valueOf(this.pos)), this.filterstring);
                    }
                    case 42: {
                        if (stringBuffer.length() > 0) {
                            arrayList.add(((Object)stringBuffer).toString());
                        }
                        stringBuffer.setLength(0);
                        arrayList.add(null);
                        ++this.pos;
                        continue block6;
                    }
                    case 92: {
                        ++this.pos;
                        n = this.filter[this.pos];
                    }
                    default: {
                        stringBuffer.append((char)n);
                        ++this.pos;
                        continue block6;
                    }
                }
                break;
            }
            if ((n = arrayList.size()) == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_VALUE, String.valueOf(this.pos)), this.filterstring);
            }
            if (n == 1 && (object = arrayList.get(0)) != null) {
                return object;
            }
            object = new String[n];
            arrayList.toArray((T[])object);
            return object;
        }

        protected void skipWhiteSpace() {
            int n = this.filter.length;
            while (this.pos < n && Character.isWhitespace(this.filter[this.pos])) {
                ++this.pos;
            }
        }
    }

    static class SetAccessibleAction
    implements PrivilegedAction {
        private Constructor constructor;

        public SetAccessibleAction(Constructor constructor) {
            this.constructor = constructor;
        }

        public Object run() {
            this.constructor.setAccessible(true);
            return null;
        }
    }
}

