/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.framework.BundlePermission;

final class BundlePermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3258407326846433079L;
    private Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof BundlePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        BundlePermission bundlePermission = (BundlePermission)permission;
        String string = bundlePermission.getName();
        BundlePermission bundlePermission2 = (BundlePermission)this.permissions.get(string);
        if (bundlePermission2 != null) {
            int n;
            int n2 = bundlePermission2.getMask();
            if (n2 != (n = bundlePermission.getMask())) {
                this.permissions.put(string, new BundlePermission(string, n2 | n));
            }
        } else {
            this.permissions.put(string, permission);
        }
        if (!this.all_allowed && string.equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int n;
        BundlePermission bundlePermission;
        if (!(permission instanceof BundlePermission)) {
            return false;
        }
        BundlePermission bundlePermission2 = (BundlePermission)permission;
        int n2 = bundlePermission2.getMask();
        int n3 = 0;
        if (this.all_allowed && (bundlePermission = (BundlePermission)this.permissions.get("*")) != null && ((n3 |= bundlePermission.getMask()) & n2) == n2) {
            return true;
        }
        String string = bundlePermission2.getName();
        bundlePermission = (BundlePermission)this.permissions.get(string);
        if (bundlePermission != null && ((n3 |= bundlePermission.getMask()) & n2) == n2) {
            return true;
        }
        int n4 = string.length() - 1;
        while ((n = string.lastIndexOf(".", n4)) != -1) {
            bundlePermission = (BundlePermission)this.permissions.get(string = String.valueOf(string.substring(0, n + 1)) + "*");
            if (bundlePermission != null && ((n3 |= bundlePermission.getMask()) & n2) == n2) {
                return true;
            }
            n4 = n - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

