/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.expanded.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.RGBUtils;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableItem
extends Item {
    Table parent;
    String[] texts;
    Image[] images;
    int fgRGB = -1;
    int bgRGB = -1;
    int[] cellFgRGBs = null;
    int[] cellBgRGBs = null;
    Font[] cellFonts = null;
    Font font = null;

    public TableItem(Table parent, int style) {
        super(parent, style);
        int index = parent.getItemCount();
        parent.addItem(this, index);
        this.parent = parent;
        this.createWidget(index);
    }

    public TableItem(Table parent, int style, int index) {
        super(parent, style);
        int numItems = parent.getItemCount();
        if (index < 0) {
            TableItem.error(6);
        }
        if (index > numItems) {
            TableItem.error(6);
        }
        parent.addItem(this, index);
        this.parent = parent;
        this.createWidget(index);
    }

    void adjustListWidth() {
        int width;
        int row = this.parent.indexOf(this);
        TableColumn col = this.parent.columns[0];
        int newWidth = OS.TableColumn_GetMinimumWidth(col.internal_handle, row);
        if (newWidth > (width = OS.TableColumn_GetWidth(col.internal_handle))) {
            OS.TableColumn_SetWidth(col.internal_handle, newWidth);
        }
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.bgRGB == -1) {
            return this.getParent().getBackground();
        }
        RGB rgbObject = RGBUtils.fromRGBInt(this.bgRGB);
        return new Color(this.getDisplay(), rgbObject);
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.isValidColumnIndex(index)) {
            return this.getBackground();
        }
        if (this.cellBgRGBs == null) {
            return this.getBackground();
        }
        if (this.cellBgRGBs[index] == -1) {
            return this.getBackground();
        }
        RGB rgbObject = RGBUtils.fromRGBInt(this.cellBgRGBs[index]);
        return new Color(this.getDisplay(), rgbObject);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        if (index == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (!this.isValidColumnIndex(index)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int itemIndex = this.parent.indexOf(this);
        int[] rect = OS.TableItem_GetBounds(this.getParent().internal_handle, itemIndex, index);
        return new Rectangle(rect[0], rect[1], rect[2], rect[3]);
    }

    public boolean getChecked() {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return false;
        }
        int itemIndex = this.parent.indexOf(this);
        return OS.TableItem_IsChecked(this.getParent().internal_handle, itemIndex);
    }

    public Font getFont() {
        this.checkWidget();
        return this.font == null ? this.getParent().getFont() : this.font;
    }

    public Font getFont(int index) {
        Font cellFont;
        this.checkWidget();
        if (!this.isValidColumnIndex(index)) {
            return this.getFont();
        }
        Font font = cellFont = this.cellFonts != null ? this.cellFonts[index] : this.getFont();
        if (cellFont == null) {
            cellFont = this.getFont();
        }
        return cellFont;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.fgRGB == -1) {
            return this.getParent().getForeground();
        }
        RGB rgbObject = RGBUtils.fromRGBInt(this.fgRGB);
        return new Color(this.getDisplay(), rgbObject);
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.isValidColumnIndex(index)) {
            return this.getForeground();
        }
        if (this.cellFgRGBs == null) {
            return this.getForeground();
        }
        if (this.cellFgRGBs[index] == -1) {
            return this.getForeground();
        }
        RGB rgbObject = RGBUtils.fromRGBInt(this.cellFgRGBs[index]);
        return new Color(this.getDisplay(), rgbObject);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return false;
        }
        int itemIndex = this.parent.indexOf(this);
        return OS.TableItem_IsGrayed(this.getParent().internal_handle, itemIndex);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.isValidColumnIndex(index)) {
            return null;
        }
        if (this.images != null) {
            if (0 <= index && index < this.images.length) {
                return this.images[index];
            }
        } else {
            return this.getImage();
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        if (index == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (index < 0 || index >= this.parent.getItemCount()) {
            return new Rectangle(0, 0, 0, 0);
        }
        int itemIndex = this.parent.indexOf(this);
        int[] rect = OS.TableItem_GetImageBounds(this.getParent().internal_handle, itemIndex, index);
        return new Rectangle(rect[0], rect[1], rect[2], rect[3]);
    }

    public Table getParent() {
        return this.parent;
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.isValidColumnIndex(index)) {
            return "";
        }
        if (this.texts != null && 0 <= index && index < this.texts.length) {
            String string = this.texts[index];
            return string != null ? string : "";
        }
        return "";
    }

    boolean hasNativeEvents() {
        return false;
    }

    protected void internal_createHandle(int index) {
        this.internal_handle = OS.TableItem_New(this.parent.internal_handle, index);
    }

    boolean isSelected() {
        int itemIndex = this.parent.indexOf(this);
        return OS.TableItem_IsSelected(this.getParent().internal_handle, itemIndex);
    }

    private boolean isValidColumnIndex(int index) {
        int count = this.getParent().internal_getColumnCount();
        return index >= 0 && index <= count - 1;
    }

    void internalClear() {
        this.parent = null;
        this.texts = null;
        this.images = null;
        this.cellFgRGBs = null;
        this.cellBgRGBs = null;
        this.image = null;
        this.releaseHandle();
    }

    void remove() {
        super.releaseWidget();
        this.internalClear();
    }

    void releaseHandle() {
        this.internal_handle = 0;
        this.display = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent.destroyItem(this);
        this.internalClear();
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int itemIndex = this.parent.indexOf(this);
        this.bgRGB = color == null ? -1 : RGBUtils.toRGBInt(color.getRGB());
        if (color == null) {
            OS.TableItem_SetBackground(this.getParent().internal_handle, itemIndex, 0);
        } else {
            OS.TableItem_SetBackground(this.getParent().internal_handle, itemIndex, color.internal_handle);
        }
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (!this.isValidColumnIndex(index)) {
            return;
        }
        int itemIndex = this.parent.indexOf(this);
        int count = this.getParent().internal_getColumnCount();
        int rgb = color == null ? -1 : RGBUtils.toRGBInt(color.getRGB());
        if (this.cellBgRGBs == null) {
            this.cellBgRGBs = new int[count];
            for (int i = 0; i < count; ++i) {
                this.cellBgRGBs[i] = -1;
            }
        }
        if (this.cellBgRGBs[index] == rgb) {
            return;
        }
        this.cellBgRGBs[index] = rgb;
        if (color == null) {
            OS.TableItem_SetCellBackground(this.getParent().internal_handle, itemIndex, index, 0);
        } else {
            OS.TableItem_SetCellBackground(this.getParent().internal_handle, itemIndex, index, color.internal_handle);
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return;
        }
        int itemIndex = this.parent.indexOf(this);
        OS.TableItem_SetChecked(this.getParent().internal_handle, itemIndex, checked);
    }

    public void setFont(Font font) {
        int fontHandle;
        if (font != null) {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            fontHandle = font.internal_handle;
        } else {
            fontHandle = 0;
        }
        int itemIndex = this.parent.indexOf(this);
        OS.TableItem_SetFont(this.getParent().internal_handle, itemIndex, fontHandle);
        this.font = font;
        if (this.parent.isList()) {
            this.adjustListWidth();
        }
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (!this.isValidColumnIndex(index)) {
            return;
        }
        int itemIndex = this.parent.indexOf(this);
        int count = this.getParent().internal_getColumnCount();
        if (this.cellFonts == null) {
            this.cellFonts = new Font[count];
        }
        if (this.cellFonts[index] == font) {
            return;
        }
        this.cellFonts[index] = font;
        if (font == null) {
            OS.TableItem_SetCellFont(this.getParent().internal_handle, itemIndex, index, 0);
        } else {
            OS.TableItem_SetCellFont(this.getParent().internal_handle, itemIndex, index, font.internal_handle);
        }
        if (this.parent.isList()) {
            this.adjustListWidth();
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int itemIndex = this.parent.indexOf(this);
        this.fgRGB = color == null ? -1 : RGBUtils.toRGBInt(color.getRGB());
        if (color == null) {
            OS.TableItem_SetForeground(this.getParent().internal_handle, itemIndex, 0);
        } else {
            OS.TableItem_SetForeground(this.getParent().internal_handle, itemIndex, color.internal_handle);
        }
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (!this.isValidColumnIndex(index)) {
            return;
        }
        int itemIndex = this.parent.indexOf(this);
        int count = this.getParent().internal_getColumnCount();
        int rgb = color == null ? -1 : RGBUtils.toRGBInt(color.getRGB());
        if (this.cellFgRGBs == null) {
            this.cellFgRGBs = new int[count];
            for (int i = 0; i < count; ++i) {
                this.cellFgRGBs[i] = -1;
            }
        }
        if (this.cellFgRGBs[index] == rgb) {
            return;
        }
        this.cellFgRGBs[index] = rgb;
        if (color == null) {
            OS.TableItem_SetCellForeground(this.getParent().internal_handle, itemIndex, index, 0);
        } else {
            OS.TableItem_SetCellForeground(this.getParent().internal_handle, itemIndex, index, color.internal_handle);
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return;
        }
        int itemIndex = this.parent.indexOf(this);
        OS.TableItem_SetGrayed(this.getParent().internal_handle, itemIndex, grayed);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            TableItem.error(4);
        }
        for (int i = 0; i < images.length; ++i) {
            this.setImage(i, images[i]);
        }
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            TableItem.error(5);
        }
        super.setImage(image);
        int itemIndex = this.parent.indexOf(this);
        if (!this.isValidColumnIndex(index)) {
            return;
        }
        int count = this.getParent().internal_getColumnCount();
        if (this.images == null) {
            this.images = new Image[count];
        }
        if (image != null && image.equals(this.images[index])) {
            return;
        }
        this.images[index] = image;
        int imageHandle = image == null ? 0 : image.internal_handle;
        OS.TableItem_SetImage(this.getParent().internal_handle, this.internal_handle, itemIndex, index, imageHandle);
        if (this.parent.isList()) {
            this.adjustListWidth();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
        if (this.parent.isList()) {
            this.adjustListWidth();
        }
    }

    void setSelected(boolean selected) {
        int itemIndex = this.parent.indexOf(this);
        OS.TableItem_SetSelected(this.getParent().internal_handle, itemIndex, selected);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            TableItem.error(4);
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            if (string == null) continue;
            this.setText(i, string);
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            TableItem.error(4);
        }
        if (!this.isValidColumnIndex(index)) {
            return;
        }
        int itemIndex = this.parent.indexOf(this);
        int count = this.getParent().internal_getColumnCount();
        if (this.texts == null) {
            this.texts = new String[count];
        }
        if (this.texts != null) {
            if (index == 0) {
                super.setText(string);
            }
            if (string.equals(this.texts[index])) {
                return;
            }
            this.texts[index] = string;
        }
        OS.TableItem_SetCellText(this.getParent().internal_handle, this.internal_handle, itemIndex, index, string);
        if (this.parent.isList()) {
            this.adjustListWidth();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
        if (this.parent.isList()) {
            this.adjustListWidth();
        }
    }
}

