/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    private static final int CALLBACK_SELECTION = 0;
    private static final int CALLBACK_DEFAULT_SELECTIO = 1;
    private static final int CALLBACK_MENU_DETECT = 2;
    private Tray tray;
    private String toolTip;
    private boolean visible = true;

    public TrayItem(Tray parent, int style) {
        super(parent, style);
        if (parent == null) {
            SWT.error(4);
        }
        this.tray = parent;
        this.createWidget(0);
        this.checkWidget();
        parent.addItem(this);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTip;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        int imageHandle = 0;
        if (image != null) {
            imageHandle = image.internal_handle;
        }
        OS.TrayItem_setImage(this.internal_handle, imageHandle);
        this.image = image;
    }

    public void setToolTipText(String value) {
        this.checkWidget();
        OS.TrayItem_setToolTipText(this.internal_handle, value);
        this.toolTip = value;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        OS.TrayItem_setVisible(this.internal_handle, visible);
        this.visible = visible;
    }

    public void dispose() {
        this.tray.removeItem(this);
        super.dispose();
    }

    protected void internal_createHandle(int index) {
        int trayHandle = this.tray.internal_handle;
        this.internal_handle = OS.TrayItem_New(trayHandle);
    }

    void TrayItemCallback(int type, int x, int y) {
        Event event = new Event();
        event.x = x;
        event.y = y;
        event.widget = this;
        if (type == 0) {
            event.type = 13;
            this.sendEvent(13, event);
        } else if (type == 1) {
            event.type = 14;
            this.sendEvent(14, event);
        } else if (type == 2) {
            event.type = 35;
            this.sendEvent(35, event);
        }
    }
}

