/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.net.URL;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.internal.util.BundleUtility;

public class ProxyImageDescriptor
extends ImageDescriptor {
    private ImageDescriptor desc;
    private String key = null;
    private String path = null;
    private boolean shared = false;
    private boolean init = false;

    public ProxyImageDescriptor(String key, String path, boolean shared) {
        this.key = key;
        this.path = path;
        this.shared = shared;
    }

    public void init(String key, String path, boolean shared) {
        URL url = BundleUtility.find("org.eclipse.ui", path);
        this.desc = ImageDescriptor.createFromURL((URL)url);
        this.init = true;
    }

    public ImageData getImageData() {
        if (!this.init) {
            this.init(this.key, this.path, this.shared);
        }
        return this.desc.getImageData();
    }

    public Object createResource(Device device) throws DeviceResourceException {
        if (!this.init) {
            this.init(this.key, this.path, this.shared);
        }
        return this.desc.createResource(device);
    }

    public void destroyResource(Object previouslyCreatedObject) {
        if (!this.init) {
            this.init(this.key, this.path, this.shared);
        }
        this.desc.destroyResource(previouslyCreatedObject);
    }

    public Image createImage() {
        if (!this.init) {
            this.init(this.key, this.path, this.shared);
        }
        return this.desc.createImage(true);
    }

    public Image createImage(boolean returnMissingImageOnError) {
        if (!this.init) {
            this.init(this.key, this.path, this.shared);
        }
        return this.desc.createImage(returnMissingImageOnError);
    }

    public Image createImage(Device device) {
        if (!this.init) {
            this.init(this.key, this.path, this.shared);
        }
        return this.desc.createImage(device);
    }

    public Image createImage(boolean returnMissingImageOnError, Device device) {
        if (!this.init) {
            this.init(this.key, this.path, this.shared);
        }
        return this.desc.createImage(returnMissingImageOnError, device);
    }
}

