/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ShellPool {
    private int flags;
    private Shell parentShell;
    private LinkedList availableShells = new LinkedList();
    private static final String CLOSE_LISTENER = "close listener";
    private boolean isDisposed = false;
    private Listener closeListener = new Listener(){

        public void handleEvent(Event e) {
            if (ShellPool.this.isDisposed) {
                return;
            }
            if (e.doit) {
                Shell s = (Shell)e.widget;
                ShellListener l = (ShellListener)s.getData(ShellPool.CLOSE_LISTENER);
                s.removeShellListener(l);
                s.removeListener(21, (Listener)this);
                Control[] children = s.getChildren();
                int i = 0;
                while (i < children.length) {
                    Control control = children[i];
                    control.dispose();
                    ++i;
                }
                ShellPool.this.availableShells.add(s);
                s.setVisible(false);
            }
            e.doit = false;
        }
    };

    public ShellPool(Shell parentShell, int childFlags) {
        this.parentShell = parentShell;
        this.flags = childFlags;
    }

    public Shell allocateShell(ShellListener closeListener) {
        Shell result = !this.availableShells.isEmpty() ? (Shell)this.availableShells.removeFirst() : new Shell(this.parentShell, this.flags);
        result.addShellListener(closeListener);
        result.setData(CLOSE_LISTENER, (Object)closeListener);
        result.addListener(21, this.closeListener);
        return result;
    }

    public void dispose() {
        Iterator iter = this.availableShells.iterator();
        while (iter.hasNext()) {
            Shell next = (Shell)iter.next();
            next.dispose();
        }
        this.availableShells.clear();
        this.isDisposed = true;
    }
}

