/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.io;

import java.io.IOException;
import org.eclipse.ercp.xml.io.SimpleBufferedInputStream;
import org.eclipse.ercp.xml.io.StreamDecoder;
import org.eclipse.ercp.xml.parser.EXmlMsg;

public class StreamDecoder_UTF16LE
extends StreamDecoder {
    public StreamDecoder_UTF16LE(SimpleBufferedInputStream stream) {
        super(stream, "UTF-16LE");
    }

    public int read(char[] buf, int offset, int count) throws IOException {
        if (count <= 0) {
            return count;
        }
        int charOffset = offset;
        byte[] b = new byte[2 * count];
        int available = this.stream.read(b, 0, 2 * count);
        if (available == -1) {
            return -1;
        }
        int pos = 0;
        int end = available - 1;
        while (pos < end) {
            byte b0 = b[pos++];
            byte b1 = b[pos++];
            buf[charOffset++] = (char)((0xFF & b1) << 8 | 0xFF & b0);
        }
        if (pos != available) {
            throw new IOException(EXmlMsg.getDefault().getString(51, Integer.toHexString(b[available - 1])));
        }
        return charOffset - offset;
    }
}

