/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.ercp.xml.io.IanaJavaMap;
import org.eclipse.ercp.xml.io.SimpleBufferedInputStream;
import org.eclipse.ercp.xml.io.StreamDecoder;
import org.eclipse.ercp.xml.io.StreamDecoder_ASCII;
import org.eclipse.ercp.xml.io.StreamDecoder_ISO8859_1;
import org.eclipse.ercp.xml.io.StreamDecoder_UTF16BE;
import org.eclipse.ercp.xml.io.StreamDecoder_UTF16LE;
import org.eclipse.ercp.xml.io.StreamDecoder_UTF8;

public class XmlInputStreamReader
extends Reader {
    SimpleBufferedInputStream in;
    Reader decoder;

    public XmlInputStreamReader(InputStream in) throws IOException {
        this(in, null);
    }

    public XmlInputStreamReader(InputStream in, String ianaEncoding) throws IOException {
        this.in = new SimpleBufferedInputStream(in);
        this.decoder = this.createFirstDecoder(ianaEncoding);
    }

    Reader createFirstDecoder(String ianaEncoding) throws UnsupportedEncodingException {
        int bytesToUnread = 3;
        if (ianaEncoding == null) {
            byte[] b = new byte[bytesToUnread];
            int available = -1;
            try {
                available = this.in.read(b, 0, bytesToUnread);
            }
            catch (IOException iOException) {}
            if (available == -1) {
                ianaEncoding = "UTF-8";
            } else if (available < bytesToUnread) {
                this.in.unread(b, available);
            } else {
                int b0 = b[0] & 0xFF;
                int b1 = b[1] & 0xFF;
                int b2 = b[2] & 0xFF;
                if (b0 == 254 && b1 == 255) {
                    ianaEncoding = "UTF-16BE";
                    bytesToUnread -= 2;
                } else if (b0 == 255 && b1 == 254) {
                    ianaEncoding = "UTF-16LE";
                    bytesToUnread -= 2;
                } else if (b0 == 239 && b1 == 187 && b2 == 191) {
                    ianaEncoding = "UTF-8";
                    bytesToUnread -= 3;
                } else {
                    ianaEncoding = "UTF-8";
                }
                this.in.unread(b, bytesToUnread);
            }
        }
        return this.createDecoder(ianaEncoding);
    }

    Reader createDecoder(String ianaEncoding) throws UnsupportedEncodingException {
        if ((ianaEncoding = ianaEncoding == null ? "UTF-8" : ianaEncoding.toUpperCase()).equals("UTF-8")) {
            return new StreamDecoder_UTF8(this.in);
        }
        if (ianaEncoding.equals("ASCII")) {
            return new StreamDecoder_ASCII(this.in);
        }
        if (ianaEncoding.equals("ISO8859_1")) {
            return new StreamDecoder_ISO8859_1(this.in);
        }
        if (ianaEncoding.equals("UTF-16BE")) {
            return new StreamDecoder_UTF16BE(this.in);
        }
        if (ianaEncoding.equals("UTF-16LE")) {
            return new StreamDecoder_UTF16LE(this.in);
        }
        if (ianaEncoding == null) {
            return new InputStreamReader(this.in);
        }
        String javaEncoding = IanaJavaMap.getIana2Java(ianaEncoding);
        if (javaEncoding == null) {
            throw new UnsupportedEncodingException(ianaEncoding);
        }
        return new InputStreamReader((InputStream)this.in, javaEncoding);
    }

    public void setEncoding(String ianaEncoding) throws UnsupportedEncodingException {
        StreamDecoder sDecoder;
        if (this.decoder != null && this.decoder instanceof StreamDecoder && !(sDecoder = (StreamDecoder)this.decoder).getEncoding().equals(ianaEncoding) && sDecoder.supportNewEncoding()) {
            sDecoder.restore();
            this.decoder = this.createDecoder(ianaEncoding);
        }
    }

    public final int read() throws IOException {
        return this.decoder.read();
    }

    public final int read(char[] buf, int offset, int count) throws IOException {
        return this.decoder.read(buf, offset, count);
    }

    public void close() throws IOException {
        if (this.decoder != null) {
            this.decoder.close();
        } else {
            this.in.close();
        }
    }

    InputStream getInputStream() {
        return this.in;
    }
}

