/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.mobile;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.swt.mobile.OS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class MultiPageDialog
extends Dialog {
    private int DIALOG_STYLE = 0;
    private static int TITLE_HEIGHT = 26;
    private static int MENU_HEIGHT = 26;
    private static final int INTERNAL_SHELL_LENGTH = 2;
    private MultiPageShell[] mpShells = new MultiPageShell[2];
    private int mpsIndex = 0;
    private MultiPageComposite mpc;
    private Display display;
    private FormLayout layout;
    private Rectangle bound;
    private boolean virtual = false;
    private static boolean isInitCallBack = false;

    public MultiPageDialog(Shell parent) {
        this(parent, 0);
    }

    public MultiPageDialog(Shell parent, int style) {
        super(parent, style);
        this.checkDialogStyle(style);
        this.display = parent.getDisplay();
        if ((style & 0x10000000) == 0x10000000) {
            this.virtual = true;
        }
        int current = this.getCurrentInternalShellIndex();
        int next = this.getNextInternalShellIndex();
        this.mpShells[current] = new MultiPageShell(parent, this.DIALOG_STYLE);
        this.mpShells[next] = new MultiPageShell(parent, this.DIALOG_STYLE);
        this.mpc = new MultiPageComposite(parent, this.mpShells[current], 0, this.virtual);
        this.layout = new FormLayout();
        this.mpShells[current].setLayout(this.layout);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.mpc.setLayoutData(fd);
        int[] rect = OS.MultiPageComposite_GetWorkArea();
        this.bound = new Rectangle(rect[0], rect[1], rect[2], rect[3]);
        this.mpShells[current].setBounds(this.bound);
        MultiPageDialog.initCallBack(this.display);
        final MultiPageDialog mpd = this;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (mpd != null) {
                    mpd.dispose();
                }
            }
        });
    }

    private MultiPageShell getCurrentInternalShell() {
        return this.mpShells[this.mpsIndex];
    }

    private int getCurrentInternalShellIndex() {
        return this.mpsIndex;
    }

    private int getNextInternalShellIndex() {
        return (this.mpsIndex + 1) % 2;
    }

    private void checkDialogStyle(int style) {
        this.DIALOG_STYLE = (style & 0x20000) != 0 || (style & 0x10000) != 0 ? 67696 : 133232;
    }

    public void addSelectionListener(SelectionListener listener) {
        MultiPageShell shell = this.getCurrentInternalShell();
        if (shell == null || shell.isDisposed()) {
            SWT.error(24);
        }
        if (shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        this.mpc.addSelectionListener(listener);
    }

    public void close() {
        MultiPageShell shell = this.getCurrentInternalShell();
        if (shell == null || shell.isDisposed()) {
            SWT.error(24);
        }
        if (shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
    }

    public Composite createPage(String title, Image icon) {
        return this.mpc.createPage(title, icon);
    }

    public void deletePage(int index) {
        this.mpc.deletePage(index);
    }

    public void dispose() {
        MultiPageShell shell = this.getCurrentInternalShell();
        if (this.mpc != null && !this.mpc.isDisposed()) {
            this.mpc.dispose();
        }
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
        int current = this.getCurrentInternalShellIndex();
        this.mpShells[current] = null;
        this.layout = null;
        this.bound = null;
    }

    public Composite getPage(int index) {
        return this.mpc.getPage(index);
    }

    public int getPageCount() {
        return this.mpc.getPageCount();
    }

    public String getTitle(int index) {
        return this.mpc.getTitle(index);
    }

    public int getSelectionIndex() {
        return this.mpc.getSelectionIndex();
    }

    public void open() {
        MultiPageShell shell = this.getCurrentInternalShell();
        if (shell == null || shell.isDisposed()) {
            SWT.error(24);
        }
        if (shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        int next = this.getNextInternalShellIndex();
        int current = this.getCurrentInternalShellIndex();
        if (this.mpShells[next] == null) {
            this.mpShells[next] = new MultiPageShell(super.getParent(), this.DIALOG_STYLE);
        }
        shell.setNextShell(this.mpShells[next]);
        shell.setLayout(this.layout);
        shell.setText(this.getText());
        shell.setBounds(this.bound);
        final Rectangle tmpBound = this.bound;
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Rectangle r = ((Shell)e.widget).getBounds();
                tmpBound.x = r.x;
                tmpBound.y = r.y;
                tmpBound.width = r.width;
                tmpBound.height = r.height;
            }
        });
        shell.open();
        if (this.mpc.getPageCount() > 0) {
            this.mpc.setSelection(this.mpc.getSelectionIndex());
        }
        while (!shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.mpShells[current] = null;
        this.mpsIndex = next;
    }

    public void removeSelectionListener(SelectionListener listener) {
        MultiPageShell shell = this.getCurrentInternalShell();
        if (shell == null || shell.isDisposed()) {
            SWT.error(24);
        }
        if (shell.getDisplay().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
        this.mpc.removeSelectionListener(listener);
    }

    public void setSelection(int index) {
        this.mpc.setSelection(index);
    }

    public void setImage(int index, Image icon) {
        this.mpc.setImage(index, icon);
    }

    public void setTitle(int index, String title) {
        this.mpc.setTitle(index, title);
    }

    public void addListener(int eventType, Listener listener) {
        this.mpc.addSetDataListener(eventType, listener);
    }

    public void removeListener(int eventType, Listener listener) {
        this.mpc.removeSetDataListener(eventType, listener);
    }

    private static synchronized void initCallBack(Display display) {
        if (!isInitCallBack) {
            com.ibm.ugl.p3ml.OS.Display_RegisterCallback(display.internal_handle, 32, "org/eclipse/ercp/swt/mobile/MultiPageDialog$MultiPageComposite", "Callback");
            isInitCallBack = true;
        }
    }

    private class MultiPageListener
    implements SelectionListener {
        private Vector selectionListeners = new Vector();
        private Vector setDataListeners = new Vector();
        private Vector pages;
        private boolean virtual = false;

        public MultiPageListener() {
        }

        public MultiPageListener(Vector pages, boolean virtual) {
            this.setCompositePage(pages);
            this.setVirtual(virtual);
        }

        public void setCompositePage(Vector pages) {
            this.pages = pages;
        }

        public void setVirtual(boolean virtual) {
            this.virtual = virtual;
        }

        public void addSelectionListener(SelectionListener listener) {
            if (listener != null) {
                this.selectionListeners.add(listener);
            }
        }

        public void removeSelectionListener(SelectionListener listener) {
            if (listener != null) {
                this.selectionListeners.remove(listener);
            }
        }

        public void addSetDataListener(Listener listener) {
            if (listener != null) {
                this.setDataListeners.add(listener);
            }
        }

        public void removeSetDataListener(Listener listener) {
            if (listener != null) {
                this.setDataListeners.remove(listener);
            }
        }

        public void widgetSelected(SelectionEvent se) {
            if (!(se.widget instanceof MultiPageComposite)) {
                return;
            }
            MultiPageComposite mpc = (MultiPageComposite)se.widget;
            if (mpc == null) {
                return;
            }
            int index = mpc.getSelectionIndex();
            if (this.virtual) {
                this.sendSetDataEvent(index);
            }
            this.sendSelectionEvent(se);
        }

        void sendSelectionEvent(SelectionEvent se) {
            MultiPageComposite mpc = (MultiPageComposite)se.widget;
            if (mpc == null) {
                return;
            }
            Composite composite = mpc.getPage(mpc.getSelectionIndex());
            if (composite == null) {
                return;
            }
            Event e = new Event();
            e.display = composite.getDisplay();
            e.x = composite.getLocation().x;
            e.y = composite.getLocation().y;
            e.width = composite.getSize().x;
            e.height = composite.getSize().y;
            e.type = 13;
            e.widget = composite;
            e.time = se.time;
            SelectionEvent nse = new SelectionEvent(e);
            Enumeration enumeration = this.selectionListeners.elements();
            while (enumeration.hasMoreElements()) {
                SelectionListener listener = (SelectionListener)enumeration.nextElement();
                if (listener == null) continue;
                listener.widgetSelected(nse);
            }
        }

        void sendSetDataEvent(int index) {
            if (!this.virtual) {
                return;
            }
            if (index >= this.pages.size()) {
                return;
            }
            CompositePage page = (CompositePage)this.pages.get(index);
            if (page.composite == null || page.isSetData) {
                return;
            }
            Event e = new Event();
            e.display = page.composite.getDisplay();
            e.x = page.composite.getLocation().x;
            e.y = page.composite.getLocation().y;
            e.width = page.composite.getSize().x;
            e.height = page.composite.getSize().y;
            e.type = 36;
            e.widget = page.composite;
            e.item = page.composite;
            e.index = MultiPageDialog.this.mpc.getSelectionIndex();
            Enumeration enumeration = this.setDataListeners.elements();
            while (enumeration.hasMoreElements()) {
                Listener listener = (Listener)enumeration.nextElement();
                if (listener == null) continue;
                listener.handleEvent(e);
            }
            page.isSetData = true;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class CompositePage {
        public Composite composite;
        public String title;
        public int imageHandle;
        public boolean isSetData = false;

        public CompositePage(Composite composite, String title) {
            this(composite, title, null);
        }

        public CompositePage(Composite composite, String title, Image icon) {
            this.composite = composite;
            this.title = title;
            this.setImage(icon);
        }

        public void setImage(Image icon) {
            this.imageHandle = icon == null ? 0 : icon.internal_handle;
        }
    }

    private class MultiPageComposite
    extends Composite
    implements Listener {
        private Shell parent;
        private Vector pages = new Vector();
        private int selected = 0;
        private MultiPageListener mpl;
        private TypedListener typedListener;
        boolean virtual;

        public MultiPageComposite(Shell realparent, Composite parent, int style, boolean virtual) {
            super(parent, 0);
            this.parent = realparent;
            parent.getDisplay().addFilter(15, this);
            parent.getDisplay().addFilter(31, this);
            this.virtual = virtual;
            this.mpl = new MultiPageListener(this.pages, virtual);
            this.typedListener = new TypedListener(this.mpl);
            this.addListener(13, this.typedListener);
            this.addListener(14, this.typedListener);
        }

        public void addSelectionListener(SelectionListener listener) {
            this.checkWidget();
            this.mpl.addSelectionListener(listener);
        }

        public void removeSelectionListener(SelectionListener listener) {
            this.checkWidget();
            this.mpl.removeSelectionListener(listener);
        }

        public void addSetDataListener(int eventType, Listener listener) {
            this.checkWidget();
            if (listener == null) {
                SWT.error(4);
            }
            if (this.virtual && eventType == 36) {
                this.mpl.addSetDataListener(listener);
            }
        }

        public void removeSetDataListener(int eventType, Listener listener) {
            this.checkWidget();
            if (listener == null) {
                SWT.error(4);
            }
            if (this.virtual && eventType == 36) {
                this.mpl.removeSetDataListener(listener);
            }
        }

        protected boolean traverse(Event event) {
            if (this.isDisposed()) {
                return false;
            }
            switch (event.keyCode) {
                case 0x1000001: {
                    Composite page = this.getPage(this.getSelectionIndex());
                    if (page == null || page.isDisposed()) {
                        return false;
                    }
                    Control control = this.getLastFocusableControl(page);
                    if (control == null) {
                        return false;
                    }
                    return control.setFocus();
                }
                case 0x1000002: {
                    Composite page = this.getPage(this.getSelectionIndex());
                    if (page == null || page.isDisposed()) {
                        return false;
                    }
                    Control control = this.getFirstFocusableControl(page);
                    if (control == null) {
                        return false;
                    }
                    return control.setFocus();
                }
                case 0x1000004: {
                    if (this.getSelectionIndex() + 1 >= this.getPageCount()) {
                        return false;
                    }
                    Composite page = this.getPage(this.getSelectionIndex() + 1);
                    if (page == null || page.isDisposed()) {
                        return false;
                    }
                    return page.setFocus();
                }
                case 0x1000003: {
                    if (this.getSelectionIndex() - 1 < 0) {
                        return false;
                    }
                    Composite page = this.getPage(this.getSelectionIndex() - 1);
                    if (page == null || page.isDisposed()) {
                        return false;
                    }
                    return page.setFocus();
                }
            }
            return super.traverse(event);
        }

        protected void internal_createHandle(int index) {
            this.internal_handle = OS.MultiPageComposite_New(this.internal_parent.internal_handle, 0);
        }

        public synchronized Composite createPage(String title, Image icon) {
            this.checkWidget();
            if (title == null) {
                SWT.error(4);
            }
            int imageHandle = 0;
            if (icon != null) {
                imageHandle = icon.internal_handle;
            }
            Composite composite = null;
            boolean success = OS.MultiPageComposite_AddPage(this.internal_handle, title, imageHandle);
            if (success) {
                this.pages.add(new CompositePage(null, title, icon));
                composite = this.createPageComposite(this.pages.size() - 1);
            }
            return composite;
        }

        Composite createPageComposite(int index) {
            if (index < 0 || index >= this.pages.size()) {
                return null;
            }
            CompositePage page = (CompositePage)this.pages.get(index);
            if (page.composite == null) {
                Composite composite = new Composite(this, 0);
                OS.MultiPageComposite_SetPageComposite(this.internal_handle, index, composite.internal_handle);
                page.composite = composite;
            }
            return page.composite;
        }

        Control getFirstFocusableControl(Composite composite) {
            Control[] childs = composite.getTabList();
            if (childs == null || childs.length == 0) {
                return null;
            }
            for (int i = 0; i < childs.length; ++i) {
                Control child;
                if (childs[i] instanceof Composite && (child = this.getFirstFocusableControl((Composite)childs[i])) != null) {
                    return child;
                }
                if (!childs[i].isVisible() || !this.isFocusableControl(childs[i])) continue;
                return childs[i];
            }
            return null;
        }

        Control getLastFocusableControl(Composite composite) {
            Control[] childs = composite.getTabList();
            if (childs == null || childs.length == 0) {
                return null;
            }
            for (int i = childs.length - 1; i >= 0; --i) {
                Control child;
                if (childs[i] instanceof Composite && (child = this.getLastFocusableControl((Composite)childs[i])) != null) {
                    return child;
                }
                if (!childs[i].isVisible() || !this.isFocusableControl(childs[i])) continue;
                return childs[i];
            }
            return null;
        }

        boolean isFocusableControl(Control control) {
            if (control instanceof Label) {
                return false;
            }
            if (control instanceof ProgressBar) {
                return false;
            }
            if (control instanceof Canvas) {
                return false;
            }
            return !(control instanceof CaptionedControl);
        }

        boolean isChild(Control parent, Control child) {
            if (parent == null || child == null) {
                return false;
            }
            if (parent == child) {
                return true;
            }
            for (Composite tmp = child.getParent(); tmp != null; tmp = tmp.getParent()) {
                if (tmp != parent) continue;
                return true;
            }
            return false;
        }

        public synchronized void deletePage(int index) {
            boolean success;
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if (success = OS.MultiPageComposite_DeletePage(this.internal_handle, index)) {
                CompositePage page = (CompositePage)this.pages.get(index);
                if (page.composite != null && !page.composite.isDisposed()) {
                    page.composite.dispose();
                }
                page.composite = null;
                this.pages.remove(index);
                if (this.selected >= index && this.selected > 0) {
                    --this.selected;
                    this.setSelection(this.selected);
                } else if (index == 0 && this.pages.size() > 0) {
                    this.setSelection(this.selected);
                }
            }
        }

        public void dispose() {
            this.checkWidget();
            this.removeListener(13, this.typedListener);
            this.removeListener(14, this.typedListener);
            int size = this.pages.size();
            for (int i = 0; i < size; ++i) {
                CompositePage page = (CompositePage)this.pages.get(i);
                if (page == null) continue;
                if (page.composite != null && !page.composite.isDisposed()) {
                    page.composite.dispose();
                }
                page.composite = null;
                Object var3_3 = null;
            }
            this.pages.clear();
            this.pages = null;
            this.parent.getDisplay().removeFilter(15, this);
            this.parent.getDisplay().removeFilter(31, this);
            super.dispose();
        }

        public Composite getPage(int index) {
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            return ((CompositePage)this.pages.get((int)index)).composite;
        }

        public int getPageCount() {
            this.checkWidget();
            return this.pages.size();
        }

        public String getTitle(int index) {
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            return ((CompositePage)this.pages.get((int)index)).title;
        }

        public int getSelectionIndex() {
            this.checkWidget();
            return this.selected;
        }

        public void setSelection(int index) {
            boolean success;
            CompositePage page;
            this.checkWidget();
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if ((page = (CompositePage)this.pages.get(index)) == null) {
                return;
            }
            if (this.virtual) {
                this.createPageComposite(index);
                this.mpl.sendSetDataEvent(index);
            }
            if (success = OS.MultiPageComposite_SetSelection(this.internal_handle, index, page.composite.internal_handle)) {
                this.forceFocus();
                this.selected = index;
            }
        }

        public void setImage(int index, Image icon) {
            boolean success;
            this.checkWidget();
            if (icon == null) {
                SWT.error(4);
            }
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if (success = OS.MultiPageComposite_SetImage(this.internal_handle, index, icon.internal_handle)) {
                CompositePage page = (CompositePage)this.pages.get(index);
                page.setImage(icon);
            }
        }

        public void setTitle(int index, String title) {
            boolean success;
            this.checkWidget();
            if (title == null) {
                SWT.error(4);
            }
            if (index < 0 || index >= this.pages.size()) {
                SWT.error(6);
            }
            if (success = OS.MultiPageComposite_SetTitle(this.internal_handle, index, title)) {
                CompositePage page = (CompositePage)this.pages.get(index);
                page.title = title;
            }
        }

        private int Callback(int type, int index) {
            switch (type) {
                case 1: {
                    if (this.virtual) {
                        this.createPageComposite(index);
                    }
                    if (index < 0 || index >= this.pages.size()) {
                        return 0;
                    }
                    CompositePage page = (CompositePage)this.pages.get(index);
                    if (page == null || page.composite == null || page.composite.isDisposed()) {
                        return 0;
                    }
                    this.selected = index;
                    this.internal_sendEvent(13);
                    return page.composite.internal_handle;
                }
                case 2: {
                    if (index < 0 || index >= this.pages.size()) {
                        return 0;
                    }
                    CompositePage page = (CompositePage)this.pages.get(index);
                    if (page == null || page.composite == null || page.composite.isDisposed()) {
                        return 0;
                    }
                    return page.composite.internal_handle;
                }
            }
            return 0;
        }

        public void handleEvent(Event e) {
            if (e.type == 15) {
                if (e.widget == null || e.widget.isDisposed()) {
                    return;
                }
                if (((Control)e.widget).getShell() == null || ((Control)e.widget).getShell().isDisposed()) {
                    return;
                }
                if (this == null || this.isDisposed()) {
                    return;
                }
                if (this.getParent() != null && !this.getParent().isDisposed() && ((Control)e.widget).getShell() == this.parent) {
                    ((Shell)this.getParent()).setActive();
                }
            } else if (e.type == 31) {
                if (this.isDisposed()) {
                    return;
                }
                if (this.getPageCount() == 0) {
                    return;
                }
                Composite page = this.getPage(this.getSelectionIndex());
                if (page == null || page.isDisposed()) {
                    return;
                }
                Control[] childs = page.getChildren();
                if (childs == null || childs.length == 0) {
                    return;
                }
                switch (e.detail) {
                    case 64: {
                        Control control = this.getLastFocusableControl(page);
                        if (!this.isChild((Control)e.widget, control) || !control.allowTraverseByArrowKey(e)) break;
                        e.doit = false;
                        this.forceFocus();
                        break;
                    }
                    case 32: {
                        Control control = this.getFirstFocusableControl(page);
                        if (!this.isChild((Control)e.widget, control) || !control.allowTraverseByArrowKey(e)) break;
                        e.doit = false;
                        this.forceFocus();
                    }
                }
            }
        }
    }

    public class MultiPageShell
    extends Shell {
        MultiPageShell next = null;

        public MultiPageShell(Shell parent, int style) {
            super(parent, style);
        }

        public void setNextShell(MultiPageShell mps) {
            this.next = mps;
        }

        public void dispose() {
            if (this.next != null) {
                Control[] controls = this.getChildren();
                for (int i = 0; i < controls.length; ++i) {
                    controls[i].setParent(this.next);
                }
            }
            super.dispose();
        }

        public String toString() {
            return "MultiPageShell {handle=" + this.internal_handle + "}";
        }
    }
}

