/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.ManageScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.UpdateMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.IUnconfigureAndUninstallFeatureOperation;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;

public class UpdatingScreen
extends AbsScreen {
    private static final int PROGRESS_UNIT = 10;
    private Composite pane;
    private Label updatingItem;
    private ProgressBar updateProgress;
    private Command cancelCommand;
    private UpdateSearchRequest searchRequest;
    private UpdateMonitor updateFeatureMonitor;
    private UpdateFeaturesThread updateFeaturesThread;
    private int totalSearchedFeaturesCount = 0;
    private boolean isSingleThread = true;
    private boolean isExisted = false;

    UpdatingScreen(NormalView view) {
        super(view);
    }

    protected void createScreen() {
        this.init(UIMessages.UpdateAllFeatures);
        this.pane = new Composite(this.screen, 0);
        this.pane.setLayoutData((Object)new GridData(768));
        this.pane.setLayout((Layout)new RowLayout(256));
        new Label(this.pane, 0).setText(UIMessages.Updating);
        this.updatingItem = new Label(this.pane, 0);
        this.updateProgress = new ProgressBar(this.screen, 65536);
        this.fillSpace();
        if (this.view.isSmartPhone) {
            this.cancelCommand = new Command((Control)this.screen, 1, 10);
            this.cancelCommand.setText(UIMessages.Cancel);
            this.cancelCommand.setLongLabel(UIMessages.Cancel);
            this.cancelCommand.addSelectionListener((SelectionListener)this);
        }
        this.setButtons(0, 2, 0);
        this.screen.layout();
    }

    protected void refresh() {
        if (this.view.isSmartPhone) {
            this.cancelCommand.setEnabled(true);
        }
        this.cancelButton.setEnabled(true);
        this.updatingItem.setText("");
        this.updateProgress.setSelection(0);
        this.pane.layout();
    }

    protected void action() {
        if (this.view.availableFeatures.size() == 0) {
            this.isSingleThread = false;
            IFeature[] allInstalledFeatures = new IFeature[this.view.installedFeatures.size()];
            int i = 0;
            while (i < this.view.installedFeatures.size()) {
                try {
                    allInstalledFeatures[i] = ((IFeatureReference)this.view.installedFeatures.get(i)).getFeature(null);
                    if (UpdateCore.DEBUG) {
                        System.out.println("[ eUpdate debug ] Feature being assigned to search: " + allInstalledFeatures[i].getLabel());
                    }
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                }
                ++i;
            }
            this.searchRequest = UpdateUtils.createNewUpdatesRequest((IFeature[])allInstalledFeatures);
        } else {
            this.isSingleThread = true;
            IFeature f = (IFeature)this.view.availableFeatures.elementAt(0);
            if (UpdateCore.DEBUG) {
                System.out.println("[ eUpdate debug ] Feature being assigned to search: " + f.getLabel());
            }
            this.searchRequest = UpdateUtils.createNewUpdatesRequest((IFeature[])new IFeature[]{f});
        }
        this.totalSearchedFeaturesCount = this.searchRequest.getCategory().getQueries().length;
        if (this.totalSearchedFeaturesCount == 0) {
            MessageBox mb2 = new MessageBox(this.screen.getShell(), 34);
            mb2.setText(UIMessages.UpdateStatus);
            mb2.setMessage(UIMessages.NoUpdateAvailable);
            mb2.open();
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(0, true);
            return;
        }
        this.updateFeatureMonitor = new UpdateMonitor();
        IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
        if (status != null) {
            System.out.println(status.getMessage());
            return;
        }
        this.updateProgress.setMaximum((this.totalSearchedFeaturesCount + 1) * 10);
        this.updateFeaturesThread = new UpdateFeaturesThread("", this.searchRequest, this.view.installedFeatures, this.updateFeatureMonitor);
        this.updateFeaturesThread.start();
        this.setDefaultFocus();
        Display.getCurrent().timerExec(1000, new Runnable(){

            public void run() {
                if (UpdatingScreen.this.updateFeaturesThread.getStatus() == 0 && UpdatingScreen.this.updateFeaturesThread.isAlive()) {
                    Display.getCurrent().timerExec(400, (Runnable)this);
                    return;
                }
                if (UpdatingScreen.this.updateFeaturesThread.getStatus() == 1) {
                    UpdatingScreen.this.updatingItem.setText(UpdatingScreen.this.updateFeaturesThread.getUpdatingItem());
                    UpdatingScreen.this.pane.layout();
                    UpdatingScreen.this.updateProgress.setSelection((int)((double)UpdatingScreen.this.updateProgress.getMaximum() * (UpdatingScreen.this.updateFeatureMonitor.getDoneWorksCount() / (double)(UpdatingScreen.this.totalSearchedFeaturesCount + 1))));
                    Display.getCurrent().timerExec(400, (Runnable)this);
                } else {
                    if (UpdatingScreen.this.isExisted) {
                        return;
                    }
                    UpdatingScreen.this.isExisted = true;
                    if (UpdatingScreen.this.updateFeaturesThread.getStatus() == 2) {
                        UpdatingScreen.this.updatingItem.setText(NLS.bind((String)UIMessages.FeatureUpdated, (Object[])new Object[]{new Integer(UpdatingScreen.this.updateFeaturesThread.getTotalUpdatedFeaturesCount()).toString()}));
                        UpdatingScreen.this.pane.layout();
                        UpdatingScreen.this.updateProgress.setSelection(UpdatingScreen.this.updateProgress.getMaximum());
                        UpdatingScreen.this.view.enableRestartCommand = true;
                        MessageBox mb1 = new MessageBox(UpdatingScreen.this.screen.getShell(), 194);
                        if (UpdatingScreen.this.updateFeaturesThread.isJvmInUpdateList()) {
                            mb1.setText(UIMessages.ConfirmRestart);
                            mb1.setMessage(NLS.bind((String)UIMessages.NeedRestartManually, (Object[])UpdatingScreen.this.view.RuntimeName));
                            if (mb1.open() == 64 && !UpdatingScreen.this.view.isSprintNow) {
                                System.getProperties().put("eworkbench.returnCode", new Integer(0));
                                PlatformUI.getWorkbench().close();
                            }
                        } else {
                            mb1.setText(UIMessages.ConfirmRestart);
                            mb1.setMessage(NLS.bind((String)UIMessages.RecommendToRestart, (Object[])UpdatingScreen.this.view.RuntimeName));
                            if (mb1.open() == 64 && !UpdatingScreen.this.view.isSprintNow) {
                                System.getProperties().put("eworkbench.returnCode", new Integer(1));
                                PlatformUI.getWorkbench().close();
                            }
                        }
                    } else if (UpdatingScreen.this.updateFeaturesThread.getStatus() == 3) {
                        MessageBox mb2 = new MessageBox(UpdatingScreen.this.screen.getShell(), 34);
                        mb2.setText(UIMessages.UpdateStatus);
                        mb2.setMessage(UIMessages.NoUpdateAvailable);
                        mb2.open();
                    } else {
                        MessageBox mb3 = new MessageBox(UpdatingScreen.this.screen.getShell(), 33);
                        mb3.setText(UIMessages.UpdateStatus);
                        if (UpdatingScreen.this.isSingleThread) {
                            mb3.setMessage(UIMessages.UpdateNotCompleted);
                        } else {
                            mb3.setMessage(UIMessages.UpdateNotAllCompleted);
                        }
                        mb3.open();
                    }
                    UpdatingScreen.this.isExisted = false;
                    if (UpdatingScreen.this.view.isSmartPhone) {
                        UpdatingScreen.this.cancelCommand.setEnabled(false);
                    }
                    UpdatingScreen.this.cancelButton.setEnabled(false);
                    UpdatingScreen.this.updateFeaturesThread = null;
                    UpdatingScreen.this.setVisible(false);
                    NormalView normalView = UpdatingScreen.this.view;
                    ((Object)((Object)UpdatingScreen.this.view)).getClass();
                    ((Object)((Object)UpdatingScreen.this.view)).getClass();
                    normalView.showScreen(0, true);
                }
            }
        });
    }

    protected void setDefaultFocus() {
        if (this.view.isSmartPhone) {
            // empty if block
        }
        this.cancelButton.setFocus();
    }

    public void widgetSelected(SelectionEvent e) {
        if ((e.widget == this.cancelButton || e.widget == this.cancelCommand) && this.updateFeaturesThread != null && this.updateFeaturesThread.getStatus() == 1) {
            this.updateFeatureMonitor.setCanceled(true);
        }
    }

    public static final IInstallConfiguration getConfiguration() {
        IInstallConfiguration config = null;
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            config = localSite.getCurrentConfiguration();
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return config;
    }

    private class UpdateFeaturesThread
    extends Thread {
        public static final int NONE = 0;
        public static final int RUNNING = 1;
        public static final int SUCCESS = 2;
        public static final int NO_UPDATE = 3;
        public static final int ENDED = 4;
        private UpdateSearchRequest request;
        private UpdateMonitor monitor;
        private UpdateSearchResultCollector collector;
        private Vector allFeatures;
        private int currentStatus;
        private int totalSearchedFeaturesCount = 0;
        private int totalUpdatedFeaturesCount = 0;
        private boolean isJvmInList = false;

        public UpdateFeaturesThread(String name, UpdateSearchRequest searchRequest, Vector allInstalledFeatures, UpdateMonitor updateMonitor) {
            super(name);
            this.request = searchRequest;
            this.monitor = updateMonitor;
            this.currentStatus = 0;
            this.collector = new UpdateSearchResultCollector();
            this.totalSearchedFeaturesCount = searchRequest.getCategory().getQueries().length;
            this.allFeatures = allInstalledFeatures;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            IInstallFeatureOperation[] operations;
            block16: {
                this.currentStatus = 1;
                UpdatingScreen.this.updateFeatureMonitor.beginTask(UIMessages.StartUpdating, this.totalSearchedFeaturesCount + 1);
                UpdatingScreen.this.updateFeatureMonitor.setTaskName(UIMessages.SearchingUpdates);
                this.isJvmInList = false;
                try {
                    this.request.performSearch((IUpdateSearchResultCollector)this.collector, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, 1));
                    if (UpdatingScreen.this.updateFeatureMonitor.isCanceled()) {
                        this.currentStatus = 4;
                        return;
                    }
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                    if (UpdatingScreen.this.searchRequest.getCategory().getQueries().length != ce.getStatus().getChildren().length) break block16;
                    this.currentStatus = 4;
                    return;
                }
            }
            if ((operations = this.collector.getOperations()) == null || operations.length == 0) {
                this.currentStatus = 3;
                this.monitor.done();
                return;
            }
            this.totalUpdatedFeaturesCount = operations.length;
            ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts((IInstallFeatureOperation[])operations, (IInstallConfiguration)UpdatingScreen.getConfiguration());
            if (conflicts != null) {
                this.currentStatus = 4;
                this.monitor.done();
                return;
            }
            int i = 0;
            while (i < operations.length) {
                if (operations[i].getFeature().getVersionedIdentifier().getIdentifier().startsWith(ManageScreen.JVM_LIB_FEATURE_NAME)) {
                    this.isJvmInList = true;
                    break;
                }
                ++i;
            }
            IBatchOperation installOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(operations);
            try {
                try {
                    boolean isSuccessful = false;
                    if (!this.monitor.isCanceled()) {
                        isSuccessful = installOperation.execute((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, this.monitor.getTotalWorksCount() - 1), null);
                    }
                    if (this.monitor.isCanceled() || !isSuccessful) {
                        this.removeOldVersion(operations, true);
                        this.currentStatus = 4;
                        Object var5_9 = null;
                        this.monitor.done();
                        return;
                    }
                    this.removeOldVersion(operations, false);
                    if (UpdateCore.DEBUG) {
                        System.out.println("Updating is finished successfully.");
                    }
                    this.currentStatus = 2;
                }
                catch (InvocationTargetException ite) {
                    this.currentStatus = 4;
                    ite.printStackTrace();
                }
                catch (CoreException ce) {
                    this.currentStatus = 4;
                    ce.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.monitor.done();
                throw throwable;
            }
            {
                Object var5_11 = null;
                this.monitor.done();
                return;
            }
        }

        public String getUpdatingItem() {
            return this.monitor.getTaskName();
        }

        public int getStatus() {
            return this.currentStatus;
        }

        public boolean isJvmInUpdateList() {
            return this.isJvmInList;
        }

        public int getTotalUpdatedFeaturesCount() {
            return this.totalUpdatedFeaturesCount;
        }

        private void removeOldVersion(IInstallFeatureOperation[] operations, boolean needCheck) {
            try {
                boolean isNewVersionInstalled = false;
                OperationFactory operationFactory = (OperationFactory)OperationsManager.getOperationFactory();
                IUnconfigureAndUninstallFeatureOperation unconfigureAndUninstallOperation = null;
                int i = 0;
                while (i < operations.length) {
                    try {
                        if (needCheck) {
                            isNewVersionInstalled = false;
                            int j = 0;
                            while (j < this.allFeatures.size()) {
                                if (operations[i].getFeature().getVersionedIdentifier().getIdentifier().equals(((IFeatureReference)this.allFeatures.get(j)).getVersionedIdentifier().getIdentifier())) {
                                    isNewVersionInstalled = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!isNewVersionInstalled) {
                                return;
                            }
                        }
                        unconfigureAndUninstallOperation = operationFactory.createUnconfigureAndUninstallFeatureOperation(operations[i].getOldFeature().getSite().getCurrentConfiguredSite(), operations[i].getOldFeature());
                        unconfigureAndUninstallOperation.execute(null, null);
                    }
                    catch (CoreException ce) {
                        ce.printStackTrace();
                    }
                    catch (InvocationTargetException ite) {
                        ite.printStackTrace();
                    }
                    ++i;
                }
                SiteManager.getLocalSite().save();
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                return;
            }
        }
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        public void accept(IFeature feature) {
            if (UpdateCore.DEBUG) {
                System.out.println("[ eUpdate debug ] searched and got this feature:");
                System.out.println("[ eUpdate debug ] \tLabel   is " + feature.getLabel());
                System.out.println("[ eUpdate debug ] \tID      is " + feature.getVersionedIdentifier().getIdentifier());
                System.out.println("[ eUpdate debug ] \tVersion is " + feature.getVersionedIdentifier().getVersion());
                System.out.println("[ eUpdate debug ] \tURL     is " + feature.getURL().toString());
            }
            IInstallFeatureOperation op = OperationsManager.getOperationFactory().createInstallOperation(null, feature, null, null, null);
            IConfiguredSite site = UpdateUtils.getDefaultTargetSite((IInstallConfiguration)UpdatingScreen.getConfiguration(), (IInstallFeatureOperation)op);
            if (site == null) {
                site = UpdateUtils.getAffinitySite((IInstallConfiguration)UpdatingScreen.getConfiguration(), (IFeature)feature);
            }
            if (site == null) {
                site = UpdatingScreen.this.view.targetSite;
            }
            op.setTargetSite(site);
            this.operations.add(op);
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] opsArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(opsArray);
            return opsArray;
        }
    }
}

