/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Graphics;

import java.util.Random;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;

public class GraphicsShowCase
extends ShowCase
implements PaintListener,
KeyListener,
SelectionListener {
    Canvas canvas;
    Random random = new Random();
    int drawCase;
    int counter = 0;
    boolean eraseBgd;
    final int MAX_COUNTER = 1000;
    Command commandExit;
    Command commandNext;
    private FocusListener superShellListener = null;
    Color col1;
    Color col2;

    public String getName() {
        return Messages.getString("GraphicsShowCase.0");
    }

    public void show() {
        this.canvas = new Canvas(this.getComposite(), 262144);
        Rectangle area = this.getComposite().getClientArea();
        this.canvas.setBounds(area);
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addKeyListener((KeyListener)this);
        this.drawCase = 0;
        this.eraseBgd = true;
        this.commandNext = new Command((Control)this.canvas, 2, 3);
        this.commandNext.setText(Messages.getString("GraphicsShowCase.1"));
        this.commandNext.addSelectionListener((SelectionListener)this);
        this.commandNext.setDefaultCommand();
        this.commandExit = new Command((Control)this.canvas, 7, 1);
        this.commandExit.setText(Messages.getString("GraphicsShowCase.2"));
        this.commandExit.setLongLabel(Messages.getString("GraphicsShowCase.3"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        this.canvas.setFocus();
        this.superShellListener = new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                if (GraphicsShowCase.this.canvas != null && !GraphicsShowCase.this.canvas.isDisposed()) {
                    ++GraphicsShowCase.this.drawCase;
                    GraphicsShowCase.this.eraseBgd = true;
                    GraphicsShowCase.this.canvas.redraw();
                    GraphicsShowCase.this.canvas.forceFocus();
                }
            }

            public void focusLost(FocusEvent arg0) {
            }
        };
        super.getComposite().getShell().addFocusListener(this.superShellListener);
    }

    public void paintControl(PaintEvent e) {
        if (this.eraseBgd) {
            e.gc.fillRectangle(this.canvas.getClientArea());
            this.eraseBgd = false;
        }
        switch (this.drawCase) {
            case 0: {
                this.counter = 0;
                this.drawImage(e, "/res/gif.gif");
                break;
            }
            case 1: {
                this.drawImage(e, "/res/jpeg.jpg");
                break;
            }
            case 2: {
                this.drawImage(e, "/res/png.png");
                break;
            }
            case 3: {
                if (this.counter >= 1000) break;
                this.randomDraw(e);
                this.canvas.redraw();
                ++this.counter;
                break;
            }
            default: {
                this.quit();
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    private void drawImage(PaintEvent e, String name) {
        Image img = new Image((Device)this.canvas.getDisplay(), this.getClass().getResourceAsStream(name));
        Rectangle imageBnds = img.getBounds();
        Rectangle canvasBnds = this.canvas.getBounds();
        int x = (canvasBnds.width - imageBnds.width) / 2;
        int y = (canvasBnds.height - imageBnds.height) / 2;
        GC gc = new GC((Drawable)this.canvas, 0);
        gc.fillRectangle(this.canvas.getClientArea());
        gc.drawImage(img, x, y);
        img.dispose();
    }

    private void randomDraw(PaintEvent e) {
        Rectangle area = this.canvas.getClientArea();
        int x1 = this.random.nextInt(area.width);
        int x2 = this.random.nextInt(area.width);
        int y1 = this.random.nextInt(area.height);
        int y2 = this.random.nextInt(area.height);
        int w = x2 - x1;
        int h = y2 - y1;
        e.gc.setXORMode(this.random.nextBoolean());
        boolean fill = this.random.nextBoolean();
        if (this.col1 != null) {
            this.col1.dispose();
        }
        this.col1 = this.generateRandomColor();
        if (!fill) {
            e.gc.setForeground(this.col1);
            e.gc.setLineStyle(this.random.nextInt(5) + 1);
            switch (this.random.nextInt(7)) {
                case 0: {
                    e.gc.drawLine(x1, y1, x2, y2);
                    break;
                }
                case 1: {
                    e.gc.drawRectangle(x1, y1, w, h);
                    break;
                }
                case 2: {
                    e.gc.drawOval(x1, y1, w, h);
                    break;
                }
                case 3: {
                    int start = this.random.nextInt();
                    int angle = this.random.nextInt(361);
                    e.gc.drawArc(x1, y1, w, h, start, angle);
                    break;
                }
                case 4: {
                    e.gc.drawPolygon(this.generateRandomPoints());
                    break;
                }
                case 5: {
                    e.gc.drawPolyline(this.generateRandomPoints());
                    break;
                }
                case 6: {
                    int w2 = Math.abs(w) / 2;
                    int h2 = Math.abs(h) / 2;
                    int aw = w2 != 0 ? this.random.nextInt(w2) : 0;
                    int ah = h2 != 0 ? this.random.nextInt(h2) : 0;
                    e.gc.drawRoundRectangle(x1, y1, w, h, aw, ah);
                }
            }
        } else {
            e.gc.setBackground(this.col1);
            switch (this.random.nextInt(6)) {
                case 0: {
                    e.gc.fillRectangle(x1, y1, w, h);
                    break;
                }
                case 1: {
                    e.gc.fillOval(x1, y1, w, h);
                    break;
                }
                case 2: {
                    int start = this.random.nextInt();
                    int angle = this.random.nextInt(361);
                    e.gc.fillArc(x1, y1, w, h, start, angle);
                    break;
                }
                case 3: {
                    e.gc.fillPolygon(this.generateRandomPoints());
                    break;
                }
                case 4: {
                    int w2 = Math.abs(w) / 2;
                    int h2 = Math.abs(h) / 2;
                    int aw = w2 != 0 ? this.random.nextInt(w2) : 0;
                    int ah = h2 != 0 ? this.random.nextInt(h2) : 0;
                    e.gc.fillRoundRectangle(x1, y1, w, h, aw, ah);
                }
                case 5: {
                    if (this.col2 != null) {
                        this.col2.dispose();
                    }
                    this.col2 = this.generateRandomColor();
                    e.gc.setForeground(this.col2);
                    e.gc.fillGradientRectangle(x1, y1, w, h, this.random.nextBoolean());
                }
            }
        }
    }

    private int[] generateRandomPoints() {
        Rectangle area = this.canvas.getClientArea();
        int count = this.random.nextInt(100) + 2;
        int[] points = new int[count * 2];
        int i = 0;
        while (i < count * 2) {
            points[i] = this.random.nextInt(area.width);
            points[i + 1] = this.random.nextInt(area.height);
            i += 2;
        }
        return points;
    }

    private Color generateRandomColor() {
        int r2 = this.random.nextInt(256);
        int g2 = this.random.nextInt(256);
        int b2 = this.random.nextInt(256);
        return new Color((Device)this.canvas.getDisplay(), r2, g2, b2);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.commandExit) {
            this.counter = 0;
            this.quit();
        } else if (e.widget == this.commandNext) {
            ++this.drawCase;
            this.eraseBgd = true;
            this.canvas.redraw();
        }
    }

    public void quit() {
        if (this.col1 != null) {
            this.col1.dispose();
        }
        if (this.col2 != null) {
            this.col2.dispose();
        }
        if (super.getComposite() != null && !super.getComposite().isDisposed()) {
            super.getComposite().getShell().removeFocusListener(this.superShellListener);
        }
        this.canvas.dispose();
        this.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

