/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.FeatureReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IInstallHandlerEntry;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.IncludedFeatureReference;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.InstallHandlerProxy;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.TargetFeature;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.core.UpdateSiteIncludedFeatureReference;

public class Feature
extends FeatureModel
implements IFeature {
    public static final String FEATURE_FILE = "feature";
    public static final String FEATURE_XML = "feature.xml";
    private ISite site;
    private IFeatureContentProvider featureContentProvider;
    private List includedFeatureReferences;
    private VersionedIdentifier versionId;
    private InstallAbortedException abortedException = null;

    public boolean equals(Object object) {
        if (!(object instanceof IFeature)) {
            return false;
        }
        IFeature iFeature = (IFeature)object;
        return this.getVersionedIdentifier().equals(iFeature.getVersionedIdentifier());
    }

    public VersionedIdentifier getVersionedIdentifier() {
        if (this.versionId != null) {
            return this.versionId;
        }
        String string = this.getFeatureIdentifier();
        String string2 = this.getFeatureVersion();
        if (string != null && string2 != null) {
            try {
                this.versionId = new VersionedIdentifier(string, string2);
                return this.versionId;
            }
            catch (Exception exception) {
                UpdateCore.warn("Unable to create versioned identifier:" + string + ":" + string2);
            }
        }
        this.versionId = new VersionedIdentifier(this.getURL().toExternalForm(), null);
        return this.versionId;
    }

    public ISite getSite() {
        return this.site;
    }

    public URL getURL() {
        IFeatureContentProvider iFeatureContentProvider = null;
        try {
            iFeatureContentProvider = this.getFeatureContentProvider();
        }
        catch (CoreException coreException) {
            UpdateCore.warn("No content Provider", coreException);
        }
        return iFeatureContentProvider != null ? iFeatureContentProvider.getURL() : null;
    }

    public IURLEntry getUpdateSiteEntry() {
        return (IURLEntry)((Object)this.getUpdateSiteEntryModel());
    }

    public IURLEntry[] getDiscoverySiteEntries() {
        URLEntryModel[] uRLEntryModelArray = this.getDiscoverySiteEntryModels();
        if (uRLEntryModelArray.length == 0) {
            return new IURLEntry[0];
        }
        return (IURLEntry[])uRLEntryModelArray;
    }

    public IInstallHandlerEntry getInstallHandlerEntry() {
        return (IInstallHandlerEntry)((Object)this.getInstallHandlerModel());
    }

    public IURLEntry getDescription() {
        return (IURLEntry)((Object)this.getDescriptionModel());
    }

    public IURLEntry getCopyright() {
        return (IURLEntry)((Object)this.getCopyrightModel());
    }

    public IURLEntry getLicense() {
        return (IURLEntry)((Object)this.getLicenseModel());
    }

    public URL getImage() {
        return this.getImageURL();
    }

    public IImport[] getRawImports() {
        ImportModel[] importModelArray = this.getImportModels();
        if (importModelArray.length == 0) {
            return new IImport[0];
        }
        return (IImport[])importModelArray;
    }

    public IFeatureReference install(IFeature iFeature, IVerificationListener iVerificationListener, IProgressMonitor iProgressMonitor) throws InstallAbortedException, CoreException {
        return this.install(iFeature, null, iVerificationListener, iProgressMonitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFeatureReference install(IFeature var1_1, IFeatureReference[] var2_2, IVerificationListener var3_3, IProgressMonitor var4_4) throws InstallAbortedException, CoreException {
        block51: {
            this.debug("Installing...:" + this.getURL().toExternalForm());
            var5_5 = ErrorRecoveryLog.getLog();
            var6_6 = var4_4 == null ? new InstallMonitor((IProgressMonitor)new NullProgressMonitor()) : (var4_4 instanceof InstallMonitor != false ? (InstallMonitor)var4_4 : new InstallMonitor(var4_4));
            var7_7 = new InstallHandlerProxy(1, this, this.getInstallHandlerEntry(), var6_6);
            var8_8 = false;
            var9_9 = null;
            this.abortedException = null;
            var10_10 = this.getFeatureContentProvider();
            var11_11 = var10_10.getVerifier();
            var12_12 = null;
            var13_13 = null;
            var14_14 = null;
            var15_15 = null;
            var16_16 = new ArrayList<IPluginEntry>();
            try {
                try {
                    block50: {
                        block48: {
                            var17_17 = this.getPluginEntries();
                            var18_20 = var1_1.getSite();
                            if (var18_20 == null) {
                                this.debug("The site to install in is null");
                                var15_15 = new IPluginEntry[]{};
                            } else {
                                var15_15 = var18_20.getPluginEntries();
                            }
                            var19_21 = UpdateManagerUtils.diff(var17_17, var15_15);
                            var20_22 = this.getNonPluginEntries();
                            var21_23 = this.getIncludedFeatureReferences();
                            if (var2_2 != null) {
                                var21_23 = UpdateManagerUtils.optionalChildrenToInstall(var21_23, var2_2);
                            }
                            var22_24 = 2 + 2 * var19_21.length + var20_22.length + 1 + 5 * var21_23.length;
                            var6_6.beginTask("", var22_24);
                            var23_25 = null;
                            var5_5.open("START_INSTALL_LOG");
                            var7_7.installInitiated();
                            var24_26 = var10_10.getFeatureEntryArchiveReferences(var6_6);
                            this.verifyReferences(var11_11, var24_26, var6_6, var3_3, true);
                            this.monitorWork(var6_6, 1);
                            var25_27 = 0;
                            while (true) {
                                if (var25_27 >= var19_21.length) break;
                                var24_26 = var10_10.getPluginEntryArchiveReferences(var19_21[var25_27], var6_6);
                                this.verifyReferences(var11_11, var24_26, var6_6, var3_3, false);
                                this.monitorWork(var6_6, 1);
                                ++var25_27;
                            }
                            var7_7.pluginsDownloaded(var19_21);
                            var25_28 = new Vector<INonPluginEntry>();
                            var26_29 = 0;
                            while (true) {
                                if (var26_29 >= var20_22.length) break;
                                if (var7_7.acceptNonPluginData(var20_22[var26_29])) {
                                    var24_26 = var10_10.getNonPluginEntryArchiveReferences(var20_22[var26_29], var6_6);
                                    this.monitorWork(var6_6, 1);
                                    var25_28.add(var20_22[var26_29]);
                                }
                                ++var26_29;
                            }
                            var20_22 = var25_28.toArray(new INonPluginEntry[0]);
                            var7_7.nonPluginDataDownloaded(var20_22, var3_3);
                            var14_14 = var1_1.getFeatureContentConsumer();
                            var26_29 = 0;
                            while (true) {
                                if (var26_29 >= var21_23.length) break;
                                var27_30 = null;
                                try {
                                    var27_30 = var21_23[var26_29].getFeature(null);
                                }
                                catch (CoreException var28_31) {
                                    UpdateCore.warn(null, var28_31);
                                }
                                if (var27_30 != null) {
                                    var23_25 = new SubProgressMonitor((IProgressMonitor)var6_6, 5);
                                    ((Site)var18_20).install((IFeature)var27_30, var2_2, var14_14, var11_11, var3_3, (IProgressMonitor)var23_25);
                                }
                                ++var26_29;
                            }
                            var26_29 = 0;
                            while (true) {
                                block49: {
                                    if (var26_29 >= var19_21.length) {
                                        var13_13 = this.featureAlreadyInstalled(var18_20);
                                        if (var13_13 == null) {
                                            break;
                                        }
                                        break block48;
                                    }
                                    if (InstallRegistry.getInstance().isPluginJustInstalled(var19_21[var26_29])) {
                                        var6_6.worked(1);
                                    } else {
                                        var27_30 = var14_14.open(var19_21[var26_29]);
                                        var24_26 = var19_21[var26_29] instanceof PluginEntryModel != false && ((PluginEntryModel)var19_21[var26_29]).isUnpack() == false ? var10_10.getPluginEntryArchiveReferences(var19_21[var26_29], var6_6) : var10_10.getPluginEntryContentReferences(var19_21[var26_29], var6_6);
                                        var23_25 = new SubProgressMonitor((IProgressMonitor)var6_6, 1);
                                        var28_32 = var19_21[var26_29].getVersionedIdentifier();
                                        var29_33 = var28_32 == null ? "" : var28_32.getIdentifier();
                                        var30_34 = 0;
                                        while (true) {
                                            if (var30_34 >= var24_26.length) {
                                                if (!var6_6.isCanceled()) break;
                                                this.abort();
                                                break block49;
                                            }
                                            this.setMonitorTaskName((IProgressMonitor)var23_25, NLS.bind((String)Messages.Feature_TaskInstallPluginFiles, (Object[])new String[]{var29_33, var24_26[var30_34].getIdentifier()}));
                                            var27_30.store(var24_26[var30_34], (IProgressMonitor)var23_25);
                                            ++var30_34;
                                        }
                                        var16_16.add(var19_21[var26_29]);
                                        InstallRegistry.registerPlugin(var19_21[var26_29]);
                                    }
                                }
                                ++var26_29;
                            }
                            var24_26 = var10_10.getFeatureEntryContentReferences(var6_6);
                            var23_25 = new SubProgressMonitor((IProgressMonitor)var6_6, 1);
                            var26_29 = 0;
                            while (true) {
                                if (var26_29 >= var24_26.length) {
                                    if (!var6_6.isCanceled()) break;
                                    this.abort();
                                    break block50;
                                }
                                this.setMonitorTaskName((IProgressMonitor)var23_25, NLS.bind((String)Messages.Feature_TaskInstallFeatureFiles, (Object[])new String[]{var24_26[var26_29].getIdentifier()}));
                                var14_14.store(var24_26[var26_29], (IProgressMonitor)var23_25);
                                ++var26_29;
                            }
                            InstallRegistry.registerFeature(this);
                            break block50;
                        }
                        if (var6_6.isCanceled()) {
                            this.abort();
                        } else {
                            var6_6.worked(1);
                        }
                    }
                    var7_7.completeInstall(var14_14);
                    this.monitorWork(var6_6, 1);
                    var8_8 = true;
                }
                catch (InstallAbortedException var17_18) {
                    this.abortedException = var17_18;
                }
                catch (CoreException var17_19) {
                    var9_9 = var17_19;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var32_35) {
                var31_36 = null;
                var33_38 = null;
                try {
                    if (var14_14 != null) {
                        if (var8_8) {
                            var12_12 = var14_14.close();
                            if (var12_12 == null && (var12_12 = var13_13) != null && var2_2 != null && var2_2.length > 0) {
                                this.reinitializeFeature(var12_12);
                            }
                            var5_5.close("END_INSTALL_LOG");
                        } else {
                            var34_40 = 0;
                            while (true) {
                                if (var34_40 >= var16_16.size()) {
                                    var14_14.abort();
                                    break;
                                }
                                InstallRegistry.unregisterPlugin((IPluginEntry)var16_16.get(var34_40));
                                ++var34_40;
                            }
                        }
                    }
                    var7_7.installCompleted(var8_8);
                    var5_5.delete();
                }
                catch (CoreException var34_41) {
                    var33_38 = var34_41;
                }
            }
            var6_6.done();
            if (var9_9 != null) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{this.getLabel()}), var9_9);
            }
            if (var33_38 != null) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{this.getLabel()}), var33_38);
            }
            if (this.abortedException != null) {
                throw this.abortedException;
            }
            throw var32_35;
lbl-1000:
            // 3 sources

            {
                var31_37 = null;
                var33_39 = null;
            }
            ** try [egrp 3[TRYBLOCK] [5 : 986->1099)] { 
lbl172:
            // 1 sources

            if (var14_14 != null) {
                if (var8_8) {
                    var12_12 = var14_14.close();
                    if (var12_12 == null && (var12_12 = var13_13) != null && var2_2 != null && var2_2.length > 0) {
                        this.reinitializeFeature(var12_12);
                    }
                    var5_5.close("END_INSTALL_LOG");
                } else {
                    var34_42 = 0;
                    while (true) {
                        if (var34_42 >= var16_16.size()) {
                            var14_14.abort();
                            break;
                        }
                        InstallRegistry.unregisterPlugin((IPluginEntry)var16_16.get(var34_42));
                        ++var34_42;
                    }
                }
            }
            var7_7.installCompleted(var8_8);
            var5_5.delete();
            break block51;
lbl190:
            // 1 sources

            catch (CoreException var34_43) {
                var33_39 = var34_43;
            }
        }
        var6_6.done();
        if (var9_9 != null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{this.getLabel()}), var9_9);
        }
        if (var33_39 != null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_error, (Object[])new String[]{this.getLabel()}), var33_39);
        }
        if (this.abortedException != null) {
            throw this.abortedException;
        }
        return var12_12;
    }

    public IPluginEntry[] getRawPluginEntries() {
        PluginEntryModel[] pluginEntryModelArray = this.getPluginEntryModels();
        if (pluginEntryModelArray.length == 0) {
            return new IPluginEntry[0];
        }
        return (IPluginEntry[])pluginEntryModelArray;
    }

    private IPluginEntry[] filterPluginEntry(IPluginEntry[] iPluginEntryArray) {
        ArrayList<IPluginEntry> arrayList = new ArrayList<IPluginEntry>();
        if (iPluginEntryArray != null) {
            int n = 0;
            while (n < iPluginEntryArray.length) {
                if (UpdateManagerUtils.isValidEnvironment(iPluginEntryArray[n])) {
                    arrayList.add(iPluginEntryArray[n]);
                }
                ++n;
            }
        }
        IPluginEntry[] iPluginEntryArray2 = new IPluginEntry[arrayList.size()];
        if (!arrayList.isEmpty()) {
            arrayList.toArray(iPluginEntryArray2);
        }
        return iPluginEntryArray2;
    }

    public int getPluginEntryCount() {
        return this.getPluginEntries().length;
    }

    public INonPluginEntry[] getRawNonPluginEntries() {
        NonPluginEntryModel[] nonPluginEntryModelArray = this.getNonPluginEntryModels();
        if (nonPluginEntryModelArray.length == 0) {
            return new INonPluginEntry[0];
        }
        return (INonPluginEntry[])nonPluginEntryModelArray;
    }

    public int getNonPluginEntryCount() {
        return this.getNonPluginEntryModels().length;
    }

    public IIncludedFeatureReference[] getRawIncludedFeatureReferences() throws CoreException {
        if (this.includedFeatureReferences == null) {
            this.initializeIncludedReferences();
        }
        if (this.includedFeatureReferences.size() == 0) {
            return new IncludedFeatureReference[0];
        }
        return this.includedFeatureReferences.toArray(new IIncludedFeatureReference[this.includedFeatureReferences.size()]);
    }

    public long getDownloadSize() {
        try {
            HashSet<IPluginEntry> hashSet = new HashSet<IPluginEntry>();
            HashSet<INonPluginEntry> hashSet2 = new HashSet<INonPluginEntry>();
            IPluginEntry[] iPluginEntryArray = this.getPluginEntries();
            hashSet.addAll(Arrays.asList(iPluginEntryArray));
            INonPluginEntry[] iNonPluginEntryArray = this.getNonPluginEntries();
            hashSet2.addAll(Arrays.asList(iNonPluginEntryArray));
            IIncludedFeatureReference[] iIncludedFeatureReferenceArray = this.getIncludedFeatureReferences();
            int n = 0;
            while (n < iIncludedFeatureReferenceArray.length) {
                iPluginEntryArray = iIncludedFeatureReferenceArray[n].getFeature(null).getPluginEntries();
                hashSet.addAll(Arrays.asList(iPluginEntryArray));
                iNonPluginEntryArray = iIncludedFeatureReferenceArray[n].getFeature(null).getNonPluginEntries();
                hashSet2.addAll(Arrays.asList(iNonPluginEntryArray));
                ++n;
            }
            IPluginEntry[] iPluginEntryArray2 = new IPluginEntry[hashSet.size()];
            INonPluginEntry[] iNonPluginEntryArray2 = new INonPluginEntry[hashSet2.size()];
            if (hashSet.size() != 0) {
                hashSet.toArray(iPluginEntryArray2);
            }
            if (hashSet2.size() != 0) {
                hashSet2.toArray(iNonPluginEntryArray2);
            }
            return this.getFeatureContentProvider().getDownloadSizeFor(iPluginEntryArray2, iNonPluginEntryArray2);
        }
        catch (CoreException coreException) {
            UpdateCore.warn(null, coreException);
            return -1L;
        }
    }

    public long getInstallSize() {
        try {
            HashSet<IPluginEntry> hashSet = new HashSet<IPluginEntry>();
            HashSet<INonPluginEntry> hashSet2 = new HashSet<INonPluginEntry>();
            IPluginEntry[] iPluginEntryArray = this.getPluginEntries();
            hashSet.addAll(Arrays.asList(iPluginEntryArray));
            INonPluginEntry[] iNonPluginEntryArray = this.getNonPluginEntries();
            hashSet2.addAll(Arrays.asList(iNonPluginEntryArray));
            IIncludedFeatureReference[] iIncludedFeatureReferenceArray = this.getIncludedFeatureReferences();
            int n = 0;
            while (n < iIncludedFeatureReferenceArray.length) {
                iPluginEntryArray = iIncludedFeatureReferenceArray[n].getFeature(null).getPluginEntries();
                hashSet.addAll(Arrays.asList(iPluginEntryArray));
                iNonPluginEntryArray = iIncludedFeatureReferenceArray[n].getFeature(null).getNonPluginEntries();
                hashSet2.addAll(Arrays.asList(iNonPluginEntryArray));
                ++n;
            }
            IPluginEntry[] iPluginEntryArray2 = new IPluginEntry[hashSet.size()];
            INonPluginEntry[] iNonPluginEntryArray2 = new INonPluginEntry[hashSet2.size()];
            if (hashSet.size() != 0) {
                hashSet.toArray(iPluginEntryArray2);
            }
            if (hashSet2.size() != 0) {
                hashSet2.toArray(iNonPluginEntryArray2);
            }
            return this.getFeatureContentProvider().getInstallSizeFor(iPluginEntryArray2, iNonPluginEntryArray2);
        }
        catch (CoreException coreException) {
            UpdateCore.warn(null, coreException);
            return -1L;
        }
    }

    public IFeatureContentProvider getFeatureContentProvider() throws CoreException {
        if (this.featureContentProvider == null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.Feature_NoContentProvider, (Object[])new String[]{this.getVersionedIdentifier().toString()}), null);
        }
        return this.featureContentProvider;
    }

    public IFeatureContentConsumer getFeatureContentConsumer() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setSite(ISite iSite) throws CoreException {
        if (this.site != null) {
            String string = this.getURL() != null ? this.getURL().toExternalForm() : "";
            throw Utilities.newCoreException(NLS.bind((String)Messages.Feature_SiteAlreadySet, (Object[])new String[]{string}), null);
        }
        this.site = iSite;
    }

    public void setFeatureContentProvider(IFeatureContentProvider iFeatureContentProvider) {
        this.featureContentProvider = iFeatureContentProvider;
        iFeatureContentProvider.setFeature(this);
    }

    public String toString() {
        String string = this.getURL() == null ? Messages.Feature_NoURL : this.getURL().toExternalForm();
        String string2 = NLS.bind((String)Messages.Feature_FeatureVersionToString, (Object[])new String[]{string, this.getVersionedIdentifier().toString()});
        String string3 = this.getLabel() == null ? "" : this.getLabel();
        return String.valueOf(string2) + " [" + string3 + "]";
    }

    private void abort() throws CoreException {
        String string = Messages.Feature_InstallationCancelled;
        throw new InstallAbortedException(string, null);
    }

    private void initializeIncludedReferences() throws CoreException {
        this.includedFeatureReferences = new ArrayList();
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = this.getFeatureIncluded();
        if (iIncludedFeatureReferenceArray.length == 0) {
            return;
        }
        ISite iSite = this.getSite();
        if (iSite == null) {
            return;
        }
        int n = 0;
        while (n < iIncludedFeatureReferenceArray.length) {
            IIncludedFeatureReference iIncludedFeatureReference = iIncludedFeatureReferenceArray[n];
            IIncludedFeatureReference iIncludedFeatureReference2 = this.getPerfectIncludeFeature(iSite, iIncludedFeatureReference);
            this.includedFeatureReferences.add(iIncludedFeatureReference2);
            ++n;
        }
    }

    private IIncludedFeatureReference getPerfectIncludeFeature(ISite iSite, IIncludedFeatureReference iIncludedFeatureReference) throws CoreException {
        Object object;
        ISiteFeatureReference[] iSiteFeatureReferenceArray = iSite.getFeatureReferences();
        VersionedIdentifier versionedIdentifier = iIncludedFeatureReference.getVersionedIdentifier();
        if ("file".equals(iSite.getURL().getProtocol()) && iSiteFeatureReferenceArray != null) {
            int n = 0;
            while (n < iSiteFeatureReferenceArray.length) {
                if (iSiteFeatureReferenceArray[n] != null && versionedIdentifier.equals(object = iSiteFeatureReferenceArray[n].getVersionedIdentifier())) {
                    IncludedFeatureReference includedFeatureReference = new IncludedFeatureReference(iSiteFeatureReferenceArray[n]);
                    includedFeatureReference.isOptional(iIncludedFeatureReference.isOptional());
                    if (iIncludedFeatureReference instanceof FeatureReferenceModel) {
                        includedFeatureReference.setLabel(((FeatureReferenceModel)((Object)iIncludedFeatureReference)).getLabel());
                    }
                    includedFeatureReference.setSearchLocation(iIncludedFeatureReference.getSearchLocation());
                    return includedFeatureReference;
                }
                ++n;
            }
        }
        UpdateSiteIncludedFeatureReference updateSiteIncludedFeatureReference = new UpdateSiteIncludedFeatureReference(iIncludedFeatureReference);
        updateSiteIncludedFeatureReference.setSite(this.getSite());
        object = this.getSite().getFeatureReference(this);
        if (object instanceof FeatureReference) {
            updateSiteIncludedFeatureReference.setType(((FeatureReference)object).getType());
        }
        String string = "features/" + versionedIdentifier.toString();
        string = this instanceof TargetFeature ? String.valueOf(string) + "/" : String.valueOf(string) + ".jar";
        URL uRL = this.getSite().getSiteContentProvider().getArchiveReference(string);
        updateSiteIncludedFeatureReference.setURL(uRL);
        updateSiteIncludedFeatureReference.setFeatureIdentifier(versionedIdentifier.getIdentifier());
        updateSiteIncludedFeatureReference.setFeatureVersion(versionedIdentifier.getVersion().toString());
        try {
            updateSiteIncludedFeatureReference.resolve(this.getSite().getURL(), null);
            return updateSiteIncludedFeatureReference;
        }
        catch (Exception exception) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.Feature_UnableToInitializeFeatureReference, (Object[])new String[]{versionedIdentifier.toString()}), exception);
        }
    }

    private void debug(String string) {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
            UpdateCore.debug(string);
        }
    }

    private void setMonitorTaskName(IProgressMonitor iProgressMonitor, String string) {
        if (iProgressMonitor != null) {
            iProgressMonitor.setTaskName(string);
        }
    }

    private void monitorWork(IProgressMonitor iProgressMonitor, int n) throws CoreException {
        if (iProgressMonitor != null) {
            iProgressMonitor.worked(n);
            if (iProgressMonitor.isCanceled()) {
                this.abort();
            }
        }
    }

    private void verifyReferences(IVerifier iVerifier, ContentReference[] contentReferenceArray, InstallMonitor installMonitor, IVerificationListener iVerificationListener, boolean bl) throws CoreException {
        IVerificationResult iVerificationResult = null;
        if (iVerifier != null) {
            int n = 0;
            while (n < contentReferenceArray.length) {
                iVerificationResult = iVerifier.verify(this, contentReferenceArray[n], bl, installMonitor);
                if (iVerificationResult != null) {
                    if (iVerificationListener == null) {
                        return;
                    }
                    int n2 = iVerificationListener.prompt(iVerificationResult);
                    if (n2 == 0) {
                        String string = Messages.JarVerificationService_CancelInstall;
                        Exception exception = iVerificationResult.getVerificationException();
                        throw new InstallAbortedException(string, exception);
                    }
                    if (n2 == 1) {
                        throw Utilities.newCoreException(Messages.JarVerificationService_UnsucessfulVerification, iVerificationResult.getVerificationException());
                    }
                }
                ++n;
            }
        }
    }

    private IFeatureReference featureAlreadyInstalled(ISite iSite) {
        ISiteFeatureReference[] iSiteFeatureReferenceArray = iSite.getFeatureReferences();
        ISiteFeatureReference iSiteFeatureReference = null;
        int n = 0;
        while (n < iSiteFeatureReferenceArray.length) {
            iSiteFeatureReference = iSiteFeatureReferenceArray[n];
            try {
                if (this.equals(iSiteFeatureReference.getFeature(null))) {
                    return iSiteFeatureReference;
                }
            }
            catch (CoreException coreException) {
                UpdateCore.warn(null, coreException);
            }
            ++n;
        }
        UpdateCore.warn("ValidateAlreadyInstalled:Feature " + this + " not found on site:" + this.getURL());
        return null;
    }

    private void reinitializeFeature(IFeatureReference iFeatureReference) {
        if (iFeatureReference == null) {
            return;
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
            UpdateCore.debug("Re initialize feature reference:" + iFeatureReference);
        }
        IFeature iFeature = null;
        try {
            ISite iSite;
            iFeature = iFeatureReference.getFeature(null);
            if (iFeature != null && iFeature instanceof Feature) {
                ((Feature)iFeature).initializeIncludedReferences();
            }
            if ((iSite = iFeatureReference.getSite()) == null) {
                return;
            }
            URL uRL = iSite.getURL();
            if (uRL == null) {
                return;
            }
            if ("file".equals(uRL.getProtocol())) {
                IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
                int n = 0;
                while (n < iIncludedFeatureReferenceArray.length) {
                    this.reinitializeFeature(iIncludedFeatureReferenceArray[n]);
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            UpdateCore.warn("", coreException);
        }
    }

    public IIncludedFeatureReference[] getIncludedFeatureReferences() throws CoreException {
        return this.filterFeatures(this.getRawIncludedFeatureReferences());
    }

    private IIncludedFeatureReference[] filterFeatures(IIncludedFeatureReference[] iIncludedFeatureReferenceArray) {
        ArrayList<IIncludedFeatureReference> arrayList = new ArrayList<IIncludedFeatureReference>();
        if (iIncludedFeatureReferenceArray != null) {
            int n = 0;
            while (n < iIncludedFeatureReferenceArray.length) {
                IIncludedFeatureReference iIncludedFeatureReference = iIncludedFeatureReferenceArray[n];
                if (UpdateManagerUtils.isValidEnvironment(iIncludedFeatureReference)) {
                    arrayList.add(iIncludedFeatureReference);
                } else if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_WARNINGS) {
                    UpdateCore.warn("Filtered out feature reference:" + iIncludedFeatureReference);
                }
                ++n;
            }
        }
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray2 = new IIncludedFeatureReference[arrayList.size()];
        if (!arrayList.isEmpty()) {
            arrayList.toArray(iIncludedFeatureReferenceArray2);
        }
        return iIncludedFeatureReferenceArray2;
    }

    public INonPluginEntry[] getNonPluginEntries() {
        return this.filterNonPluginEntry(this.getRawNonPluginEntries());
    }

    private INonPluginEntry[] filterNonPluginEntry(INonPluginEntry[] iNonPluginEntryArray) {
        ArrayList<INonPluginEntry> arrayList = new ArrayList<INonPluginEntry>();
        if (iNonPluginEntryArray != null) {
            int n = 0;
            while (n < iNonPluginEntryArray.length) {
                if (UpdateManagerUtils.isValidEnvironment(iNonPluginEntryArray[n])) {
                    arrayList.add(iNonPluginEntryArray[n]);
                }
                ++n;
            }
        }
        INonPluginEntry[] iNonPluginEntryArray2 = new INonPluginEntry[arrayList.size()];
        if (!arrayList.isEmpty()) {
            arrayList.toArray(iNonPluginEntryArray2);
        }
        return iNonPluginEntryArray2;
    }

    public IPluginEntry[] getPluginEntries() {
        return this.filterPluginEntry(this.getRawPluginEntries());
    }

    public IImport[] getImports() {
        return this.filterImports(this.getRawImports());
    }

    private IImport[] filterImports(IImport[] iImportArray) {
        ArrayList<IImport> arrayList = new ArrayList<IImport>();
        if (iImportArray != null) {
            int n = 0;
            while (n < iImportArray.length) {
                if (UpdateManagerUtils.isValidEnvironment(iImportArray[n])) {
                    arrayList.add(iImportArray[n]);
                }
                ++n;
            }
        }
        IImport[] iImportArray2 = new IImport[arrayList.size()];
        if (!arrayList.isEmpty()) {
            arrayList.toArray(iImportArray2);
        }
        return iImportArray2;
    }
}

