/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractListViewer
extends StructuredViewer {
    private List listMap = new ArrayList();

    protected abstract void listAdd(String var1, int var2);

    protected abstract void listSetItem(int var1, String var2);

    protected abstract int[] listGetSelectionIndices();

    protected abstract int listGetItemCount();

    protected abstract void listSetItems(String[] var1);

    protected abstract void listRemoveAll();

    protected abstract void listRemove(int var1);

    protected abstract void listSetSelection(int[] var1);

    protected abstract void listShowSelection();

    protected abstract void listDeselectAll();

    public void add(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        Object[] objectArray2 = this.filter(objectArray);
        ILabelProvider iLabelProvider = (ILabelProvider)this.getLabelProvider();
        int n = 0;
        while (n < objectArray2.length) {
            Object object = objectArray2[n];
            int n2 = this.indexForElement(object);
            this.listAdd(this.getLabelProviderText(iLabelProvider, object), n2);
            this.listMap.add(n2, object);
            this.mapElement(object, (Widget)this.getControl());
            ++n;
        }
    }

    private String getLabelProviderText(ILabelProvider iLabelProvider, Object object) {
        String string = iLabelProvider.getText(object);
        if (string == null) {
            return "";
        }
        return string;
    }

    public void add(Object object) {
        this.add(new Object[]{object});
    }

    protected Widget doFindInputItem(Object object) {
        if (object != null && this.equals(object, this.getRoot())) {
            return this.getControl();
        }
        return null;
    }

    protected Widget doFindItem(Object object) {
        if (object != null && this.listMap.contains(object)) {
            return this.getControl();
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object object, boolean bl) {
        int n;
        if (object != null && (n = this.listMap.indexOf(object)) >= 0) {
            ILabelProvider iLabelProvider = (ILabelProvider)this.getLabelProvider();
            this.listSetItem(n, this.getLabelProviderText(iLabelProvider, object));
        }
    }

    public abstract Control getControl();

    public Object getElementAt(int n) {
        if (n >= 0 && n < this.listMap.size()) {
            return this.listMap.get(n);
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected List getSelectionFromWidget() {
        int[] nArray = this.listGetSelectionIndices();
        ArrayList<Object> arrayList = new ArrayList<Object>(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            Object object = this.getElementAt(nArray[n]);
            if (object != null) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    protected int indexForElement(Object object) {
        ViewerSorter viewerSorter = this.getSorter();
        if (viewerSorter == null) {
            return this.listGetItemCount();
        }
        int n = this.listGetItemCount();
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Object e = this.listMap.get(n4);
            int n5 = viewerSorter.compare(this, e, object);
            if (n5 == 0) {
                while (n5 == 0) {
                    if (++n4 >= n) break;
                    e = this.listMap.get(n4);
                    n5 = viewerSorter.compare(this, e, object);
                }
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2;
    }

    protected void inputChanged(Object object, Object object2) {
        this.listMap.clear();
        Object[] objectArray = this.getSortedChildren(this.getRoot());
        int n = objectArray.length;
        this.listRemoveAll();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Object object3 = objectArray[n2];
            stringArray[n2] = this.getLabelProviderText((ILabelProvider)this.getLabelProvider(), object3);
            this.listMap.add(object3);
            this.mapElement(object3, (Widget)this.getControl());
            ++n2;
        }
        this.listSetItems(stringArray);
    }

    protected void internalRefresh(Object object) {
        Control control = this.getControl();
        if (object == null || this.equals(object, this.getRoot())) {
            if (this.listMap != null) {
                this.listMap.clear();
            }
            this.unmapAllElements();
            List list = this.getSelectionFromWidget();
            control.setRedraw(false);
            this.listRemoveAll();
            Object[] objectArray = this.getSortedChildren(this.getRoot());
            String[] stringArray = new String[objectArray.length];
            ILabelProvider iLabelProvider = (ILabelProvider)this.getLabelProvider();
            int n = 0;
            while (n < stringArray.length) {
                Object object2 = objectArray[n];
                stringArray[n] = this.getLabelProviderText(iLabelProvider, object2);
                this.listMap.add(object2);
                this.mapElement(object2, (Widget)control);
                ++n;
            }
            this.listSetItems(stringArray);
            control.setRedraw(true);
            this.setSelectionToWidget(list, false);
        } else {
            this.doUpdateItem((Widget)control, object, true);
        }
    }

    private void internalRemove(Object[] objectArray) {
        Object object = this.getInput();
        int n = 0;
        while (n < objectArray.length) {
            if (this.equals(objectArray[n], object)) {
                this.setInput(null);
                return;
            }
            int n2 = this.listMap.indexOf(objectArray[n]);
            if (n2 >= 0) {
                this.listRemove(n2);
                this.listMap.remove(n2);
                this.unmapElement(objectArray[n], (Widget)this.getControl());
            }
            ++n;
        }
    }

    public void remove(final Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        this.preservingSelection(new Runnable(){

            public void run() {
                AbstractListViewer.this.internalRemove(objectArray);
            }
        });
    }

    public void remove(Object object) {
        this.remove(new Object[]{object});
    }

    public void setLabelProvider(IBaseLabelProvider iBaseLabelProvider) {
        Assert.isTrue(iBaseLabelProvider instanceof ILabelProvider);
        super.setLabelProvider(iBaseLabelProvider);
    }

    protected void setSelectionToWidget(List list, boolean bl) {
        if (list == null || list.size() == 0) {
            this.listDeselectAll();
        } else {
            int n = list.size();
            int[] nArray = new int[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Object e = list.get(n3);
                int n4 = this.listMap.indexOf(e);
                if (n4 >= 0) {
                    nArray[n2++] = n4;
                }
                ++n3;
            }
            if (n2 < n) {
                int[] nArray2 = nArray;
                nArray = new int[n2];
                System.arraycopy(nArray2, 0, nArray, 0, n2);
            }
            this.listSetSelection(nArray);
            if (bl) {
                this.listShowSelection();
            }
        }
    }

    int getElementIndex(Object object) {
        return this.listMap.indexOf(object);
    }
}

