/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;

public final class FontData {
    int height;
    int style;
    String name;
    String locale;

    public FontData() {
        this("", 12, 0);
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int start = 0;
        int end = string.indexOf(124);
        if (end == -1) {
            SWT.error(5);
        }
        String version1 = string.substring(start, end);
        try {
            if (Integer.parseInt(version1) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException e) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        if (end == -1) {
            SWT.error(5);
        }
        String name = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            SWT.error(5);
        }
        int height = 0;
        try {
            height = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException e) {
            SWT.error(5);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        if (end == -1) {
            SWT.error(5);
        }
        int style = 0;
        try {
            style = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException e) {
            SWT.error(5);
        }
        this.setName(name);
        this.setHeight(height);
        this.setStyle(FontData.internal_convertToSWTStyle(style));
    }

    public static int internal_convertToSWTStyle(int style) {
        int swtStyle = 0;
        if ((style & 2) == 2) {
            swtStyle |= 1;
        }
        if ((style & 4) == 4) {
            swtStyle |= 2;
        }
        return swtStyle;
    }

    public static int internal_convertToNativeStyle(int style) {
        int nativeStyle = 0;
        if ((style & 1) == 1) {
            nativeStyle |= 2;
        }
        if ((style & 2) == 2) {
            nativeStyle |= 4;
        }
        return nativeStyle;
    }

    public FontData(String name, int height, int style) {
        if (name == null) {
            SWT.error(4);
        }
        if (height < 0) {
            SWT.error(5);
        }
        this.name = name;
        this.height = height;
        this.style = style;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontData)) {
            return false;
        }
        FontData data = (FontData)object;
        return this.name.equals(data.name) && this.height == data.height && this.style == data.style;
    }

    public int getHeight() {
        return this.height;
    }

    public String getLocale() {
        return this.locale != null ? this.locale : "";
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.height ^ this.style;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setLocale(String localeString) {
        this.locale = localeString;
    }

    public void setName(String name) {
        if (name == null) {
            SWT.error(4);
        }
        this.name = name;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("1|");
        buffer.append(this.getName());
        buffer.append("|");
        buffer.append(this.getHeight());
        buffer.append("|");
        buffer.append(FontData.internal_convertToNativeStyle(this.getStyle()));
        buffer.append("|");
        return buffer.toString();
    }
}

