/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.core.runtime.preferences.PreferenceModifyListener;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class PreferenceServiceRegistryHelper
implements IRegistryChangeListener {
    private static final String ELEMENT_INITIALIZER = "initializer";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ELEMENT_SCOPE = "scope";
    private static final String ELEMENT_MODIFIER = "modifier";
    private static final IExtension[] EMPTY_EXTENSION_ARRAY = new IExtension[0];
    private static final Map scopeRegistry = Collections.synchronizedMap(new HashMap());
    private ListenerList modifyListeners;
    private PreferencesService service;
    private IExtensionRegistry registry;

    private static IStatus createStatusError(String string, Exception exception) {
        return new Status(4, "org.eclipse.equinox.preferences", 4, string, (Throwable)exception);
    }

    private static IStatus createStatusWarning(String string, Exception exception) {
        return new Status(2, "org.eclipse.equinox.preferences", 2, string, (Throwable)exception);
    }

    private static void log(IStatus iStatus) {
        RuntimeLog.log((IStatus)iStatus);
    }

    public PreferenceServiceRegistryHelper(PreferencesService preferencesService, Object object) {
        this.service = preferencesService;
        this.registry = (IExtensionRegistry)object;
        this.initializeScopes();
        this.registry.addRegistryChangeListener((IRegistryChangeListener)this);
    }

    void stop() {
        this.registry.removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    private void addModifyListener(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute(ATTRIBUTE_CLASS);
        if (string == null) {
            String string2 = NLS.bind((String)PrefsMessages.preferences_missingClassAttribute, (Object)iConfigurationElement.getDeclaringExtension().getUniqueIdentifier());
            PreferenceServiceRegistryHelper.log((IStatus)new Status(4, "org.eclipse.equinox.preferences", 4, string2, null));
            return;
        }
        try {
            Object object = iConfigurationElement.createExecutableExtension(ATTRIBUTE_CLASS);
            if (!(object instanceof PreferenceModifyListener)) {
                PreferenceServiceRegistryHelper.log((IStatus)new Status(4, "org.eclipse.equinox.preferences", 4, PrefsMessages.preferences_classCastListener, null));
                return;
            }
            this.modifyListeners.add(object);
        }
        catch (CoreException coreException) {
            PreferenceServiceRegistryHelper.log(coreException.getStatus());
        }
    }

    public WeakReference applyRuntimeDefaults(String string, WeakReference weakReference) {
        Object object;
        IExtension[] iExtensionArray = this.getPrefExtensions();
        if (iExtensionArray.length == 0) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Skipping runtime default preference customization.");
            }
            return null;
        }
        boolean bl = false;
        int n = 0;
        while (n < iExtensionArray.length) {
            object = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < ((IConfigurationElement[])object).length) {
                if (ELEMENT_INITIALIZER.equals(object[n2].getName()) && string.equals(object[n2].getContributor().getName())) {
                    if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                        IExtension iExtension = object[n2].getDeclaringExtension();
                        String string2 = iExtension.getContributor().getName();
                        Bundle bundle = PreferencesOSGiUtils.getDefault().getBundle(string2);
                        String string3 = bundle != null ? bundle.getSymbolicName() : string2;
                        PrefsMessages.message("Running default preference customization as defined by: " + string3);
                    }
                    this.runInitializer((IConfigurationElement)object[n2]);
                    bl = true;
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            return null;
        }
        Object object2 = weakReference.get();
        object = PreferencesOSGiUtils.getDefault().getLegacyPreferences();
        if (object != null) {
            object2 = object.init(object2, string);
        }
        return new WeakReference(object2);
    }

    public IEclipsePreferences createNode(RootPreferences rootPreferences, String string) {
        IScope iScope = null;
        Object v = scopeRegistry.get(string);
        if (v instanceof IConfigurationElement) {
            try {
                iScope = (IScope)((IConfigurationElement)v).createExecutableExtension(ATTRIBUTE_CLASS);
                scopeRegistry.put(string, iScope);
            }
            catch (ClassCastException classCastException) {
                PreferenceServiceRegistryHelper.log(PreferenceServiceRegistryHelper.createStatusError(PrefsMessages.preferences_classCastScope, classCastException));
                return new EclipsePreferences(rootPreferences, string);
            }
            catch (CoreException coreException) {
                PreferenceServiceRegistryHelper.log(coreException.getStatus());
                return new EclipsePreferences(rootPreferences, string);
            }
        } else {
            iScope = (IScope)v;
        }
        return iScope.create(rootPreferences, string);
    }

    public PreferenceModifyListener[] getModifyListeners() {
        Object[] objectArray;
        if (this.modifyListeners == null) {
            this.modifyListeners = new ListenerList();
            objectArray = this.getPrefExtensions();
            int n = 0;
            while (n < objectArray.length) {
                IConfigurationElement[] iConfigurationElementArray = objectArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    if (ELEMENT_MODIFIER.equalsIgnoreCase(iConfigurationElementArray[n2].getName())) {
                        this.addModifyListener(iConfigurationElementArray[n2]);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        objectArray = this.modifyListeners.getListeners();
        PreferenceModifyListener[] preferenceModifyListenerArray = new PreferenceModifyListener[objectArray.length];
        System.arraycopy(objectArray, 0, preferenceModifyListenerArray, 0, objectArray.length);
        return preferenceModifyListenerArray;
    }

    private IExtension[] getPrefExtensions() {
        IExtensionPoint iExtensionPoint;
        IExtension[] iExtensionArray = EMPTY_EXTENSION_ARRAY;
        IExtension[] iExtensionArray2 = EMPTY_EXTENSION_ARRAY;
        IExtensionPoint iExtensionPoint2 = this.registry.getExtensionPoint("org.eclipse.core.runtime", "preferences");
        if (iExtensionPoint2 != null) {
            iExtensionArray = iExtensionPoint2.getExtensions();
        }
        if ((iExtensionPoint = this.registry.getExtensionPoint("org.eclipse.equinox.preferences", "preferences")) != null) {
            iExtensionArray2 = iExtensionPoint.getExtensions();
        }
        IExtension[] iExtensionArray3 = new IExtension[iExtensionArray.length + iExtensionArray2.length];
        System.arraycopy(iExtensionArray, 0, iExtensionArray3, 0, iExtensionArray.length);
        System.arraycopy(iExtensionArray2, 0, iExtensionArray3, iExtensionArray.length, iExtensionArray2.length);
        if (iExtensionArray3.length == 0 && EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("No extensions for org.eclipse.core.contenttype.");
        }
        return iExtensionArray3;
    }

    private void initializeScopes() {
        IExtension[] iExtensionArray = this.getPrefExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if (ELEMENT_SCOPE.equalsIgnoreCase(iConfigurationElementArray[n2].getName())) {
                    this.scopeAdded(iConfigurationElementArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.core.runtime", "preferences");
        IExtensionDelta[] iExtensionDeltaArray2 = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.equinox.preferences", "preferences");
        IExtensionDelta[] iExtensionDeltaArray3 = new IExtensionDelta[iExtensionDeltaArray.length + iExtensionDeltaArray2.length];
        System.arraycopy(iExtensionDeltaArray, 0, iExtensionDeltaArray3, 0, iExtensionDeltaArray.length);
        System.arraycopy(iExtensionDeltaArray2, 0, iExtensionDeltaArray3, iExtensionDeltaArray.length, iExtensionDeltaArray2.length);
        if (iExtensionDeltaArray3.length == 0) {
            return;
        }
        int n = 0;
        while (n < iExtensionDeltaArray3.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionDeltaArray3[n].getExtension().getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                switch (iExtensionDeltaArray3[n].getKind()) {
                    case 1: {
                        if (!ELEMENT_SCOPE.equalsIgnoreCase(iConfigurationElementArray[n2].getName())) break;
                        this.scopeAdded(iConfigurationElementArray[n2]);
                        break;
                    }
                    case 2: {
                        String string = iConfigurationElementArray[n2].getAttribute(ATTRIBUTE_NAME);
                        if (string == null) break;
                        this.scopeRemoved(string);
                    }
                }
                ++n2;
            }
            ++n;
        }
        this.modifyListeners = null;
    }

    private void runInitializer(IConfigurationElement iConfigurationElement) {
        AbstractPreferenceInitializer abstractPreferenceInitializer = null;
        try {
            abstractPreferenceInitializer = (AbstractPreferenceInitializer)iConfigurationElement.createExecutableExtension(ATTRIBUTE_CLASS);
            abstractPreferenceInitializer.initializeDefaultPreferences();
        }
        catch (ClassCastException classCastException) {
            Status status = new Status(4, "org.eclipse.equinox.preferences", 4, PrefsMessages.preferences_invalidExtensionSuperclass, (Throwable)classCastException);
            PreferenceServiceRegistryHelper.log((IStatus)status);
        }
        catch (CoreException coreException) {
            PreferenceServiceRegistryHelper.log(coreException.getStatus());
        }
    }

    private void scopeAdded(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute(ATTRIBUTE_NAME);
        if (string == null) {
            String string2 = NLS.bind((String)PrefsMessages.preferences_missingScopeAttribute, (Object)iConfigurationElement.getDeclaringExtension().getUniqueIdentifier());
            PreferenceServiceRegistryHelper.log(PreferenceServiceRegistryHelper.createStatusWarning(string2, null));
            return;
        }
        scopeRegistry.put(string, iConfigurationElement);
        ((RootPreferences)this.service.getRootNode()).addChild(string, null);
    }

    private void scopeRemoved(String string) {
        IEclipsePreferences iEclipsePreferences = (IEclipsePreferences)((RootPreferences)this.service.getRootNode()).getNode(string, false);
        if (iEclipsePreferences != null) {
            ((RootPreferences)this.service.getRootNode()).removeNode(iEclipsePreferences);
        } else {
            ((RootPreferences)this.service.getRootNode()).removeNode(string);
        }
        scopeRegistry.remove(string);
    }
}

