/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.framework.util.KeyedElement;

public abstract class PackageSource
implements KeyedElement {
    protected String id;

    public PackageSource(String string) {
        this.id = string.intern();
    }

    public String getId() {
        return this.id;
    }

    public abstract SingleSourcePackage[] getSuppliers();

    public boolean compare(KeyedElement keyedElement) {
        return this.id.equals(((PackageSource)keyedElement).getId());
    }

    public int getKeyHashCode() {
        return this.id.hashCode();
    }

    public Object getKey() {
        return this.id;
    }

    public boolean isNullSource() {
        return false;
    }

    public boolean isFriend(String string) {
        return true;
    }

    public abstract Class loadClass(String var1) throws ClassNotFoundException;

    public abstract URL getResource(String var1);

    public abstract Enumeration getResources(String var1) throws IOException;

    public boolean hasCommonSource(PackageSource packageSource) {
        if (packageSource == null) {
            return false;
        }
        if (this == packageSource) {
            return true;
        }
        SingleSourcePackage[] singleSourcePackageArray = this.getSuppliers();
        SingleSourcePackage[] singleSourcePackageArray2 = packageSource.getSuppliers();
        if (singleSourcePackageArray == null || singleSourcePackageArray2 == null) {
            return false;
        }
        int n = 0;
        while (n < singleSourcePackageArray.length) {
            int n2 = 0;
            while (n2 < singleSourcePackageArray2.length) {
                if (singleSourcePackageArray2[n2].equals(singleSourcePackageArray[n])) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }
}

