/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeDescriptionImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateReader;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;

public class BundleDescriptionImpl
extends BaseDescriptionImpl
implements BundleDescription,
KeyedElement {
    static final String[] EMPTY_STRING = new String[0];
    static final ImportPackageSpecification[] EMPTY_IMPORTS = new ImportPackageSpecification[0];
    static final BundleSpecification[] EMPTY_BUNDLESPECS = new BundleSpecification[0];
    static final ExportPackageDescription[] EMPTY_EXPORTS = new ExportPackageDescription[0];
    static final BundleDescription[] EMPTY_BUNDLEDESCS = new BundleDescription[0];
    static final GenericSpecification[] EMPTY_GENERICSPECS = new GenericSpecification[0];
    static final GenericDescription[] EMPTY_GENERICDESCS = new GenericDescription[0];
    static final int RESOLVED = 1;
    static final int SINGLETON = 2;
    static final int REMOVAL_PENDING = 4;
    static final int FULLY_LOADED = 8;
    static final int LAZY_LOADED = 16;
    static final int HAS_DYNAMICIMPORT = 32;
    static final int ATTACH_FRAGMENTS = 64;
    static final int DYNAMIC_FRAGMENTS = 128;
    private int stateBits = 200;
    private long bundleId = -1L;
    private HostSpecification host;
    private StateImpl containingState;
    private Object userObject;
    private int lazyDataOffset = -1;
    private int lazyDataSize = -1;
    private ArrayList dependencies;
    private ArrayList dependents;
    private LazyData lazyData;
    private int equinox_ee = -1;

    public long getBundleId() {
        return this.bundleId;
    }

    public String getSymbolicName() {
        return this.getName();
    }

    public BundleDescription getSupplier() {
        return this;
    }

    public String getLocation() {
        this.fullyLoad();
        return this.lazyData.location;
    }

    public String getPlatformFilter() {
        this.fullyLoad();
        return this.lazyData.platformFilter;
    }

    public String[] getExecutionEnvironments() {
        this.fullyLoad();
        if (this.lazyData.executionEnvironments == null) {
            return EMPTY_STRING;
        }
        return this.lazyData.executionEnvironments;
    }

    public ImportPackageSpecification[] getImportPackages() {
        this.fullyLoad();
        if (this.lazyData.importPackages == null) {
            return EMPTY_IMPORTS;
        }
        return this.lazyData.importPackages;
    }

    public BundleSpecification[] getRequiredBundles() {
        this.fullyLoad();
        if (this.lazyData.requiredBundles == null) {
            return EMPTY_BUNDLESPECS;
        }
        return this.lazyData.requiredBundles;
    }

    public GenericSpecification[] getGenericRequires() {
        this.fullyLoad();
        if (this.lazyData.genericRequires == null) {
            return EMPTY_GENERICSPECS;
        }
        return this.lazyData.genericRequires;
    }

    public GenericDescription[] getGenericCapabilities() {
        this.fullyLoad();
        if (this.lazyData.genericCapabilities == null) {
            return EMPTY_GENERICDESCS;
        }
        return this.lazyData.genericCapabilities;
    }

    public NativeCodeSpecification getNativeCodeSpecification() {
        this.fullyLoad();
        return this.lazyData.nativeCode;
    }

    public ExportPackageDescription[] getExportPackages() {
        this.fullyLoad();
        return this.lazyData.exportPackages == null ? EMPTY_EXPORTS : this.lazyData.exportPackages;
    }

    public boolean isResolved() {
        return (this.stateBits & 1) != 0;
    }

    public State getContainingState() {
        return this.containingState;
    }

    public BundleDescription[] getFragments() {
        if (this.host != null) {
            return EMPTY_BUNDLEDESCS;
        }
        StateImpl stateImpl = (StateImpl)this.getContainingState();
        if (stateImpl == null) {
            throw new IllegalStateException("BundleDescription does not belong to a state.");
        }
        return stateImpl.getFragments(this);
    }

    public HostSpecification getHost() {
        return this.host;
    }

    public boolean isSingleton() {
        return (this.stateBits & 2) != 0;
    }

    public boolean isRemovalPending() {
        return (this.stateBits & 4) != 0;
    }

    public boolean hasDynamicImports() {
        return (this.stateBits & 0x20) != 0;
    }

    public boolean attachFragments() {
        return (this.stateBits & 0x40) != 0;
    }

    public boolean dynamicFragments() {
        return (this.stateBits & 0x80) != 0;
    }

    public ExportPackageDescription[] getSelectedExports() {
        this.fullyLoad();
        if (this.lazyData.selectedExports == null) {
            return EMPTY_EXPORTS;
        }
        return this.lazyData.selectedExports;
    }

    public ExportPackageDescription[] getSubstitutedExports() {
        this.fullyLoad();
        if (this.lazyData.substitutedExports == null) {
            return EMPTY_EXPORTS;
        }
        return this.lazyData.substitutedExports;
    }

    public BundleDescription[] getResolvedRequires() {
        this.fullyLoad();
        if (this.lazyData.resolvedRequires == null) {
            return EMPTY_BUNDLEDESCS;
        }
        return this.lazyData.resolvedRequires;
    }

    public ExportPackageDescription[] getResolvedImports() {
        this.fullyLoad();
        if (this.lazyData.resolvedImports == null) {
            return EMPTY_EXPORTS;
        }
        return this.lazyData.resolvedImports;
    }

    protected void setBundleId(long l) {
        this.bundleId = l;
    }

    protected void setSymbolicName(String string) {
        this.setName(string);
    }

    protected void setLocation(String string) {
        this.checkLazyData();
        this.lazyData.location = string;
    }

    protected void setPlatformFilter(String string) {
        this.checkLazyData();
        this.lazyData.platformFilter = string;
    }

    protected void setExecutionEnvironments(String[] stringArray) {
        this.checkLazyData();
        this.lazyData.executionEnvironments = stringArray;
    }

    protected void setExportPackages(ExportPackageDescription[] exportPackageDescriptionArray) {
        this.checkLazyData();
        this.lazyData.exportPackages = exportPackageDescriptionArray;
        if (exportPackageDescriptionArray != null) {
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                ((ExportPackageDescriptionImpl)exportPackageDescriptionArray[n]).setExporter(this);
                ++n;
            }
        }
    }

    protected void setImportPackages(ImportPackageSpecification[] importPackageSpecificationArray) {
        this.checkLazyData();
        this.lazyData.importPackages = importPackageSpecificationArray;
        if (importPackageSpecificationArray != null) {
            int n = 0;
            while (n < importPackageSpecificationArray.length) {
                ((ImportPackageSpecificationImpl)importPackageSpecificationArray[n]).setBundle(this);
                if ("dynamic".equals(importPackageSpecificationArray[n].getDirective("resolution"))) {
                    this.stateBits |= 0x20;
                }
                ++n;
            }
        }
    }

    protected void setRequiredBundles(BundleSpecification[] bundleSpecificationArray) {
        this.checkLazyData();
        this.lazyData.requiredBundles = bundleSpecificationArray;
        if (bundleSpecificationArray != null) {
            int n = 0;
            while (n < bundleSpecificationArray.length) {
                ((VersionConstraintImpl)((Object)bundleSpecificationArray[n])).setBundle(this);
                ++n;
            }
        }
    }

    protected void setGenericCapabilities(GenericDescription[] genericDescriptionArray) {
        this.checkLazyData();
        this.lazyData.genericCapabilities = genericDescriptionArray;
        if (genericDescriptionArray != null) {
            int n = 0;
            while (n < genericDescriptionArray.length) {
                ((GenericDescriptionImpl)genericDescriptionArray[n]).setSupplier(this);
                ++n;
            }
        }
    }

    protected void setGenericRequires(GenericSpecification[] genericSpecificationArray) {
        this.checkLazyData();
        this.lazyData.genericRequires = genericSpecificationArray;
        if (genericSpecificationArray != null) {
            int n = 0;
            while (n < genericSpecificationArray.length) {
                ((VersionConstraintImpl)((Object)genericSpecificationArray[n])).setBundle(this);
                ++n;
            }
        }
    }

    protected void setNativeCodeSpecification(NativeCodeSpecification nativeCodeSpecification) {
        this.checkLazyData();
        this.lazyData.nativeCode = nativeCodeSpecification;
        if (nativeCodeSpecification != null) {
            ((NativeCodeSpecificationImpl)nativeCodeSpecification).setBundle(this);
            NativeCodeDescription[] nativeCodeDescriptionArray = nativeCodeSpecification.getPossibleSuppliers();
            if (nativeCodeDescriptionArray != null) {
                int n = 0;
                while (n < nativeCodeDescriptionArray.length) {
                    ((NativeCodeDescriptionImpl)nativeCodeDescriptionArray[n]).setSupplier(this);
                    ++n;
                }
            }
        }
    }

    protected int getStateBits() {
        return this.stateBits;
    }

    protected void setStateBit(int n, boolean bl) {
        this.stateBits = bl ? (this.stateBits |= n) : (this.stateBits &= ~n);
    }

    protected void setContainingState(State state) {
        this.containingState = (StateImpl)state;
        this.stateBits = this.containingState != null && this.containingState.getReader() != null ? (this.containingState.getReader().isLazyLoaded() ? (this.stateBits |= 0x10) : (this.stateBits &= 0xFFFFFFEF)) : (this.stateBits &= 0xFFFFFFEF);
    }

    protected void setHost(HostSpecification hostSpecification) {
        this.host = hostSpecification;
        if (hostSpecification != null) {
            ((VersionConstraintImpl)((Object)hostSpecification)).setBundle(this);
        }
    }

    protected void setLazyLoaded(boolean bl) {
        this.fullyLoad();
        this.stateBits = bl ? (this.stateBits |= 0x10) : (this.stateBits &= 0xFFFFFFEF);
    }

    protected void setSelectedExports(ExportPackageDescription[] exportPackageDescriptionArray) {
        this.checkLazyData();
        this.lazyData.selectedExports = exportPackageDescriptionArray;
        if (exportPackageDescriptionArray != null) {
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                ((ExportPackageDescriptionImpl)exportPackageDescriptionArray[n]).setExporter(this);
                ++n;
            }
        }
    }

    protected void setSubstitutedExports(ExportPackageDescription[] exportPackageDescriptionArray) {
        this.checkLazyData();
        this.lazyData.substitutedExports = exportPackageDescriptionArray;
    }

    protected void setResolvedImports(ExportPackageDescription[] exportPackageDescriptionArray) {
        this.checkLazyData();
        this.lazyData.resolvedImports = exportPackageDescriptionArray;
    }

    protected void setResolvedRequires(BundleDescription[] bundleDescriptionArray) {
        this.checkLazyData();
        this.lazyData.resolvedRequires = bundleDescriptionArray;
    }

    public String toString() {
        if (this.getSymbolicName() == null) {
            return "[" + this.getBundleId() + "]";
        }
        return String.valueOf(this.getSymbolicName()) + "_" + this.getVersion();
    }

    public Object getKey() {
        return new Long(this.bundleId);
    }

    public boolean compare(KeyedElement keyedElement) {
        if (!(keyedElement instanceof BundleDescriptionImpl)) {
            return false;
        }
        BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)keyedElement;
        return this.bundleId == bundleDescriptionImpl.bundleId;
    }

    public int getKeyHashCode() {
        return (int)(this.bundleId ^ this.bundleId >>> 32);
    }

    protected synchronized void removeDependencies() {
        if (this.dependencies == null) {
            return;
        }
        Iterator iterator = this.dependencies.iterator();
        while (iterator.hasNext()) {
            ((BundleDescriptionImpl)iterator.next()).removeDependent(this);
        }
        this.dependencies = null;
    }

    protected void addDependencies(BaseDescription[] baseDescriptionArray, boolean bl) {
        if (baseDescriptionArray == null) {
            return;
        }
        if (!bl && this.dependencies == null) {
            this.dependencies = new ArrayList(baseDescriptionArray.length);
        }
        int n = 0;
        while (n < baseDescriptionArray.length) {
            this.addDependency((BaseDescriptionImpl)baseDescriptionArray[n], bl);
            ++n;
        }
    }

    protected synchronized void addDependency(BaseDescriptionImpl baseDescriptionImpl, boolean bl) {
        BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)baseDescriptionImpl.getSupplier();
        if (bundleDescriptionImpl == this) {
            return;
        }
        if (this.dependencies == null) {
            this.dependencies = new ArrayList(10);
        }
        if (!bl || !this.dependencies.contains(bundleDescriptionImpl)) {
            bundleDescriptionImpl.addDependent(this);
            this.dependencies.add(bundleDescriptionImpl);
        }
    }

    synchronized List getBundleDependencies() {
        if (this.dependencies == null) {
            return new ArrayList(0);
        }
        ArrayList arrayList = new ArrayList(this.dependencies.size());
        Iterator iterator = this.dependencies.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == this || !(e instanceof BundleDescription) || ((BundleDescription)e).getHost() != null) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    protected synchronized void addDependent(BundleDescription bundleDescription) {
        if (this.dependents == null) {
            this.dependents = new ArrayList(10);
        }
        this.dependents.add(bundleDescription);
    }

    protected synchronized void removeDependent(BundleDescription bundleDescription) {
        if (this.dependents == null) {
            return;
        }
        this.dependents.remove(bundleDescription);
    }

    public synchronized BundleDescription[] getDependents() {
        if (this.dependents == null) {
            return EMPTY_BUNDLEDESCS;
        }
        return this.dependents.toArray(new BundleDescription[this.dependents.size()]);
    }

    void setFullyLoaded(boolean bl) {
        this.stateBits = bl ? (this.stateBits |= 8) : (this.stateBits &= 0xFFFFFFF7);
    }

    boolean isFullyLoaded() {
        return (this.stateBits & 8) != 0;
    }

    void setLazyDataOffset(int n) {
        this.lazyDataOffset = n;
    }

    int getLazyDataOffset() {
        return this.lazyDataOffset;
    }

    void setLazyDataSize(int n) {
        this.lazyDataSize = n;
    }

    int getLazyDataSize() {
        return this.lazyDataSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullyLoad() {
        StateReader stateReader;
        if ((this.stateBits & 0x10) == 0) {
            return;
        }
        StateImpl stateImpl = (StateImpl)this.getContainingState();
        StateReader stateReader2 = stateReader = stateImpl == null ? null : stateImpl.getReader();
        if (stateReader == null) {
            throw new IllegalStateException("No valid reader for the bundle description");
        }
        StateReader stateReader3 = stateReader;
        synchronized (stateReader3) {
            if (this.isFullyLoaded()) {
                stateReader.setAccessedFlag(true);
                return;
            }
            try {
                stateReader.fullyLoad(this);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }
    }

    synchronized void addDynamicResolvedImport(ExportPackageDescriptionImpl exportPackageDescriptionImpl) {
        this.addDependency(exportPackageDescriptionImpl, true);
        this.checkLazyData();
        if (this.lazyData.resolvedImports == null) {
            this.lazyData.resolvedImports = new ExportPackageDescription[]{exportPackageDescriptionImpl};
            return;
        }
        ExportPackageDescription[] exportPackageDescriptionArray = new ExportPackageDescription[this.lazyData.resolvedImports.length + 1];
        System.arraycopy(this.lazyData.resolvedImports, 0, exportPackageDescriptionArray, 0, this.lazyData.resolvedImports.length);
        exportPackageDescriptionArray[exportPackageDescriptionArray.length - 1] = exportPackageDescriptionImpl;
        this.lazyData.resolvedImports = exportPackageDescriptionArray;
        this.setLazyLoaded(false);
    }

    void unload() {
        if ((this.stateBits & 0x10) == 0) {
            return;
        }
        StateImpl stateImpl = (StateImpl)this.getContainingState();
        if (stateImpl == null) {
            throw new IllegalStateException("BundleDescription does not belong to a State.");
        }
        if (!this.isFullyLoaded()) {
            return;
        }
        this.setFullyLoaded(false);
        LazyData lazyData = this.lazyData;
        this.lazyData = null;
        if (lazyData == null || lazyData.selectedExports == null) {
            return;
        }
        int n = 0;
        while (n < lazyData.selectedExports.length) {
            stateImpl.getReader().objectTable.remove(new Integer(((ExportPackageDescriptionImpl)lazyData.selectedExports[n]).getTableIndex()));
            ++n;
        }
    }

    void setDynamicStamps(HashMap hashMap) {
        this.lazyData.dynamicStamps = hashMap;
    }

    void setDynamicStamp(String string, Long l) {
        this.checkLazyData();
        if (this.lazyData.dynamicStamps == null) {
            if (l == null) {
                return;
            }
            this.lazyData.dynamicStamps = new HashMap();
        }
        if (l == null) {
            this.lazyData.dynamicStamps.remove(string);
        } else {
            this.lazyData.dynamicStamps.put(string, l);
        }
    }

    long getDynamicStamp(String string) {
        this.fullyLoad();
        Long l = this.lazyData.dynamicStamps == null ? null : (Long)this.lazyData.dynamicStamps.get(string);
        return l == null ? 0L : l;
    }

    HashMap getDynamicStamps() {
        this.fullyLoad();
        return this.lazyData.dynamicStamps;
    }

    public void setEquinoxEE(int n) {
        this.equinox_ee = n;
    }

    public int getEquinoxEE() {
        return this.equinox_ee;
    }

    private void checkLazyData() {
        if (this.lazyData == null) {
            this.lazyData = new LazyData();
        }
    }

    private final class LazyData {
        String location;
        String platformFilter;
        BundleSpecification[] requiredBundles;
        ExportPackageDescription[] exportPackages;
        ImportPackageSpecification[] importPackages;
        GenericDescription[] genericCapabilities;
        GenericSpecification[] genericRequires;
        NativeCodeSpecification nativeCode;
        ExportPackageDescription[] selectedExports;
        BundleDescription[] resolvedRequires;
        ExportPackageDescription[] resolvedImports;
        ExportPackageDescription[] substitutedExports;
        String[] executionEnvironments;
        HashMap dynamicStamps;

        private LazyData() {
        }
    }
}

