/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.internal.signedcontent.Base64;
import org.eclipse.osgi.internal.signedcontent.PKCS7Processor;
import org.eclipse.osgi.internal.signedcontent.SignedBundleFile;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.internal.signedcontent.SignedContentConstants;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignedContentMessages;
import org.eclipse.osgi.internal.signedcontent.SignerInfoImpl;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;

public class SignatureBlockProcessor
implements SignedContentConstants {
    private final SignedBundleFile signedBundle;
    private ArrayList signerInfos = new ArrayList();
    private HashMap contentMDResults = new HashMap();
    private HashMap tsaSignerInfos;
    private final int supportFlags;

    public SignatureBlockProcessor(SignedBundleFile signedBundleFile, int n) {
        this.signedBundle = signedBundleFile;
        this.supportFlags = n;
    }

    public SignedContentImpl process() throws IOException, InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        Object object;
        BundleFile bundleFile = this.signedBundle.getWrappedBundleFile();
        BundleEntry bundleEntry = bundleFile.getEntry("META-INF/MANIFEST.MF");
        if (bundleEntry == null) {
            return this.createUnsignedContent();
        }
        Enumeration enumeration = bundleFile.getEntryPaths("META-INF/");
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).endsWith(".DSA") && !((String)object).endsWith(".RSA") || ((String)object).indexOf(47) != ((String)object).lastIndexOf(47)) continue;
            arrayList.add(object);
        }
        if (arrayList.size() == 0) {
            return this.createUnsignedContent();
        }
        object = SignatureBlockProcessor.readIntoArray(bundleEntry);
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.processSigner(bundleFile, (byte[])object, (String)iterator.next());
            ++n;
        }
        SignerInfo[] signerInfoArray = this.signerInfos.toArray(new SignerInfo[this.signerInfos.size()]);
        Object object2 = this.contentMDResults.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry entry = object2.next();
            ArrayList[] arrayListArray = (ArrayList[])entry.getValue();
            SignerInfo[] signerInfoArray2 = arrayListArray[0].toArray(new SignerInfo[arrayListArray[0].size()]);
            byte[][] byArray = (byte[][])arrayListArray[1].toArray((T[])new byte[arrayListArray[1].size()][]);
            entry.setValue(new Object[]{signerInfoArray2, byArray});
        }
        object2 = new SignedContentImpl(signerInfoArray, (this.supportFlags & 4) != 0 ? this.contentMDResults : null);
        ((SignedContentImpl)object2).setContent(this.signedBundle);
        ((SignedContentImpl)object2).setTSASignerInfos(this.tsaSignerInfos);
        return object2;
    }

    private SignedContentImpl createUnsignedContent() {
        SignedContentImpl signedContentImpl = new SignedContentImpl(new SignerInfo[0], this.contentMDResults);
        signedContentImpl.setContent(this.signedBundle);
        return signedContentImpl;
    }

    private void processSigner(BundleFile bundleFile, byte[] byArray, String string) throws IOException, SignatureException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        BundleEntry bundleEntry = bundleFile.getEntry(string);
        byte[] byArray2 = SignatureBlockProcessor.readIntoArray(bundleEntry);
        int n = string.lastIndexOf(46);
        bundleEntry = bundleFile.getEntry(String.valueOf(string.substring(0, n)) + ".SF");
        byte[] byArray3 = SignatureBlockProcessor.readIntoArray(bundleEntry);
        String string2 = bundleFile.getBaseFile() != null ? ((Object)bundleFile.getBaseFile()).toString() : null;
        PKCS7Processor pKCS7Processor = new PKCS7Processor(byArray2, 0, byArray2.length, string, string2);
        pKCS7Processor.verifySFSignature(byArray3, 0, byArray3.length);
        String string3 = SignatureBlockProcessor.getDigAlgFromSF(byArray3);
        if (string3 == null) {
            throw new SignatureException(NLS.bind(SignedContentMessages.SF_File_Parsing_Error, new String[]{bundleFile.toString()}));
        }
        this.verifyManifestAndSingatureFile(byArray, byArray3);
        SignerInfoImpl signerInfoImpl = new SignerInfoImpl(pKCS7Processor.getCertificates(), null, string3);
        if ((this.supportFlags & 4) != 0) {
            this.populateMDResults(byArray, signerInfoImpl);
        }
        this.signerInfos.add(signerInfoImpl);
        Certificate[] certificateArray = pKCS7Processor.getTSACertificates();
        Date date = pKCS7Processor.getSigningTime();
        if (certificateArray != null && date != null) {
            SignerInfoImpl signerInfoImpl2 = new SignerInfoImpl(certificateArray, null, string3);
            if (this.tsaSignerInfos == null) {
                this.tsaSignerInfos = new HashMap(2);
            }
            this.tsaSignerInfos.put(signerInfoImpl, new Object[]{signerInfoImpl2, date});
        }
    }

    private void verifyManifestAndSingatureFile(byte[] byArray, byte[] byArray2) {
        String string = new String(byArray2);
        int n = (string = SignatureBlockProcessor.stripContinuations(string)).indexOf("-Digest-Manifest: ");
        if (n != -1) {
            int n2 = string.lastIndexOf(10, n);
            String string2 = null;
            if (n2 != -1) {
                String string3 = string.substring(n2 + 1, n);
                if (string3.equalsIgnoreCase("MD5")) {
                    string2 = SignatureBlockProcessor.calculateDigest(SignatureBlockProcessor.getMessageDigest("MD5"), byArray);
                } else if (string3.equalsIgnoreCase("SHA1")) {
                    string2 = SignatureBlockProcessor.calculateDigest(SignatureBlockProcessor.getMessageDigest("SHA1"), byArray);
                }
                int n3 = string.indexOf(10, n += digestManifestSearchLen);
                String string4 = string.substring(n, n3 - 1);
                if (!string4.equals(string2)) {
                    SecurityException securityException = new SecurityException(NLS.bind(SignedContentMessages.Security_File_Is_Tampered, new String[]{((Object)this.signedBundle.getBaseFile()).toString()}));
                    SignedBundleHook.log(securityException.getMessage(), 4, securityException);
                    throw securityException;
                }
            }
        }
    }

    private void populateMDResults(byte[] byArray, SignerInfo signerInfo) throws NoSuchAlgorithmException {
        String string = new String(byArray);
        int n = string.indexOf("\nName: ");
        int n2 = string.length();
        while (n != -1 && n < n2) {
            String string2;
            int n3 = string.indexOf("\nName: ", n + 1);
            if (n3 == -1) {
                n3 = string.length();
            }
            String string3 = string.substring(n + 1, n3);
            String string4 = SignatureBlockProcessor.getEntryFileName(string3 = SignatureBlockProcessor.stripContinuations(string3));
            if (string4 != null && (string2 = SignatureBlockProcessor.getDigestLine(string3, signerInfo.getMessageDigestAlgorithm())) != null) {
                String string5 = SignatureBlockProcessor.getDigestAlgorithmFromString(string2);
                if (!string5.equalsIgnoreCase(signerInfo.getMessageDigestAlgorithm())) continue;
                byte[] byArray2 = SignatureBlockProcessor.getDigestResultsList(string2);
                ArrayList[] arrayListArray = (ArrayList[])this.contentMDResults.get(string4);
                if (arrayListArray == null) {
                    arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
                    this.contentMDResults.put(string4, arrayListArray);
                }
                arrayListArray[0].add(signerInfo);
                arrayListArray[1].add(byArray2);
            }
            n = n3;
        }
    }

    private static byte[] getDigestResultsList(String string) {
        byte[] byArray = null;
        if (string != null) {
            String string2 = string;
            int n = string2.indexOf("-Digest: ");
            if ((n += "-Digest: ".length()) >= string2.length()) {
                byArray = null;
            }
            String string3 = string2.substring(n);
            try {
                byArray = Base64.decode(string3.getBytes());
            }
            catch (Throwable throwable) {
                byArray = null;
            }
        }
        return byArray;
    }

    private static String getDigestAlgorithmFromString(String string) throws NoSuchAlgorithmException {
        if (string != null) {
            int n = string.indexOf("-Digest: ");
            String string2 = string.substring(0, n);
            if (string2.equalsIgnoreCase("MD5")) {
                return "MD5";
            }
            if (string2.equalsIgnoreCase("SHA1")) {
                return "SHA1";
            }
            throw new NoSuchAlgorithmException(NLS.bind(SignedContentMessages.Algorithm_Not_Supported, string2));
        }
        return null;
    }

    private static String getEntryFileName(String string) {
        int n = string.indexOf("Name: ");
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(10, n);
        if (n2 == -1) {
            return null;
        }
        if (string.charAt(n2 - 1) == '\r') {
            --n2;
        }
        if ((n += "Name: ".length()) >= n2) {
            return null;
        }
        return string.substring(n, n2);
    }

    private static String calculateDigest(MessageDigest messageDigest, byte[] byArray) {
        return new String(Base64.encode(messageDigest.digest(byArray)));
    }

    static synchronized MessageDigest getMessageDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SignedBundleHook.log(noSuchAlgorithmException.getMessage(), 4, noSuchAlgorithmException);
            return null;
        }
    }

    private static String getDigAlgFromSF(byte[] byArray) {
        String string = new String(byArray);
        String string2 = null;
        int n = string.indexOf("\nName: ");
        int n2 = string.length();
        if (n != -1 && n < n2) {
            int n3 = string.indexOf("\nName: ", n + 1);
            if (n3 == -1) {
                n3 = string.length();
            }
            string2 = string.substring(n + 1, n3);
            string2 = SignatureBlockProcessor.stripContinuations(string2);
        }
        if (string2 != null) {
            String string3 = SignatureBlockProcessor.getDigestLine(string2, null);
            return SignatureBlockProcessor.getMessageDigestName(string3);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static String getDigestLine(String var0, String var1_1) {
        var2_2 = null;
        var3_3 = var0.indexOf("-Digest: ");
        if (var3_3 != -1) ** GOTO lbl22
        return null;
lbl-1000:
        // 1 sources

        {
            var4_4 = var0.lastIndexOf(10, var3_3);
            if (var4_4 == -1) {
                return null;
            }
            var5_5 = var0.indexOf(10, var3_3);
            if (var5_5 == -1) {
                return null;
            }
            var6_6 = var5_5;
            if (var0.charAt(var6_6 - 1) == '\r') {
                --var6_6;
            }
            if ((var7_7 = var4_4 + 1) >= var6_6) {
                return null;
            }
            var8_8 = var0.substring(var7_7, var6_6);
            var9_9 = SignatureBlockProcessor.getMessageDigestName(var8_8);
            if (var1_1 != null && var1_1.equalsIgnoreCase(var9_9)) {
                return var8_8;
            }
            var2_2 = var8_8;
            var3_3 = var0.indexOf("-Digest: ", var5_5);
lbl22:
            // 2 sources

            ** while (var3_3 != -1)
        }
lbl23:
        // 1 sources

        return var2_2;
    }

    private static String getMessageDigestName(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.indexOf("-Digest: ")) != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private static String stripContinuations(String string) {
        if (string.indexOf("\n ") < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.indexOf("\n ");
        int n2 = 0;
        while (n >= 0) {
            stringBuffer.append(string.substring(n2, n - 1));
            n2 = n + 2;
            int n3 = n = n + 2 < string.length() ? string.indexOf("\n ", n + 2) : -1;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return ((Object)stringBuffer).toString();
    }

    private static byte[] readIntoArray(BundleEntry bundleEntry) throws IOException {
        byte[] byArray;
        int n = (int)bundleEntry.getSize();
        InputStream inputStream = bundleEntry.getInputStream();
        int n2 = SignatureBlockProcessor.readFully(inputStream, byArray = new byte[n]);
        if (n2 != n) {
            throw new IOException("Couldn't read all of " + bundleEntry.getName() + ": " + n2 + " != " + n);
        }
        return byArray;
    }

    private static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        int n3 = 0;
        while ((n = inputStream.read(byArray, n3, n2)) > 0) {
            n2 -= n;
            n3 += n;
        }
        return n3;
    }
}

