/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.content.ContentTypeMatcher;
import org.eclipse.core.internal.content.ContentTypeVisitor;
import org.eclipse.core.internal.content.FileSpec;
import org.eclipse.core.internal.content.ILazySource;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.core.runtime.preferences.IScopeContext;

public final class ContentTypeCatalog {
    private static final IContentType[] NO_CONTENT_TYPES = new IContentType[0];
    private Map allChildren = new HashMap();
    private Map contentTypes = new HashMap();
    private Map fileExtensions = new HashMap();
    private Map fileNames = new HashMap();
    private int generation;
    private ContentTypeManager manager;
    private Comparator policyConstantGeneralIsBetter = new Comparator(){

        public int compare(Object object, Object object2) {
            ContentType contentType = (ContentType)object;
            ContentType contentType2 = (ContentType)object2;
            int n = contentType.getDepth() - contentType2.getDepth();
            if (n != 0) {
                return n;
            }
            int n2 = contentType.getPriority() - contentType2.getPriority();
            if (n2 != 0) {
                return -n2;
            }
            return contentType.getId().compareTo(contentType2.getId());
        }
    };
    private Comparator policyConstantSpecificIsBetter = new Comparator(){

        public int compare(Object object, Object object2) {
            ContentType contentType = (ContentType)object;
            ContentType contentType2 = (ContentType)object2;
            int n = contentType.getDepth() - contentType2.getDepth();
            if (n != 0) {
                return -n;
            }
            int n2 = contentType.getPriority() - contentType2.getPriority();
            if (n2 != 0) {
                return -n2;
            }
            return contentType.getId().compareTo(contentType2.getId());
        }
    };
    private Comparator policyGeneralIsBetter = new Comparator(){

        public int compare(Object object, Object object2) {
            ContentType contentType = (ContentType)object;
            ContentType contentType2 = (ContentType)object2;
            int n = contentType.getDepth() - contentType2.getDepth();
            if (n != 0) {
                return n;
            }
            int n2 = contentType.getPriority() - contentType2.getPriority();
            if (n2 != 0) {
                return -n2;
            }
            return 0;
        }
    };
    private Comparator policyLexicographical = new Comparator(){

        public int compare(Object object, Object object2) {
            ContentType contentType = (ContentType)object;
            ContentType contentType2 = (ContentType)object2;
            return contentType.getId().compareTo(contentType2.getId());
        }
    };
    private Comparator policySpecificIsBetter = new Comparator(){

        public int compare(Object object, Object object2) {
            ContentType contentType = (ContentType)object;
            ContentType contentType2 = (ContentType)object2;
            int n = contentType.getDepth() - contentType2.getDepth();
            if (n != 0) {
                return -n;
            }
            int n2 = contentType.getPriority() - contentType2.getPriority();
            if (n2 != 0) {
                return -n2;
            }
            return 0;
        }
    };

    private static IContentType[] concat(IContentType[][] iContentTypeArray) {
        if (iContentTypeArray[0].length == 0) {
            return iContentTypeArray[1];
        }
        if (iContentTypeArray[1].length == 0) {
            return iContentTypeArray[0];
        }
        IContentType[] iContentTypeArray2 = new IContentType[iContentTypeArray[0].length + iContentTypeArray[1].length];
        System.arraycopy(iContentTypeArray[0], 0, iContentTypeArray2, 0, iContentTypeArray[0].length);
        System.arraycopy(iContentTypeArray[1], 0, iContentTypeArray2, iContentTypeArray[0].length, iContentTypeArray[1].length);
        return iContentTypeArray2;
    }

    public ContentTypeCatalog(ContentTypeManager contentTypeManager, int n) {
        this.manager = contentTypeManager;
        this.generation = n;
    }

    void addContentType(IContentType iContentType) {
        this.contentTypes.put(iContentType.getId(), iContentType);
    }

    private IContentType[] applyPolicy(final IContentTypeManager.ISelectionPolicy iSelectionPolicy, final IContentType[] iContentTypeArray, final boolean bl, final boolean bl2) {
        final IContentType[][] iContentTypeArray2 = new IContentType[][]{iContentTypeArray};
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable throwable) {
            }

            public void run() throws Exception {
                iContentTypeArray2[0] = iSelectionPolicy.select(iContentTypeArray, bl, bl2);
            }
        });
        return iContentTypeArray2[0];
    }

    void associate(ContentType contentType) {
        String[] stringArray = contentType.getFileSpecs(6);
        int n = 0;
        while (n < stringArray.length) {
            this.associate(contentType, stringArray[n], 4);
            ++n;
        }
        String[] stringArray2 = contentType.getFileSpecs(10);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.associate(contentType, stringArray2[n2], 8);
            ++n2;
        }
    }

    void associate(ContentType contentType, String string, int n) {
        String string2;
        Map map = (n & 4) != 0 ? this.fileNames : this.fileExtensions;
        HashSet<ContentType> hashSet = (HashSet<ContentType>)map.get(string2 = FileSpec.getMappingKeyFor(string));
        if (hashSet == null) {
            hashSet = new HashSet<ContentType>();
            map.put(string2, hashSet);
        }
        hashSet.add(contentType);
    }

    private int collectMatchingByContents(int n, IContentType[] iContentTypeArray, List list, ILazySource iLazySource) throws IOException {
        int n2 = 0;
        while (n2 < iContentTypeArray.length) {
            ContentType contentType = (ContentType)iContentTypeArray[n2];
            IContentDescriber iContentDescriber = contentType.getDescriber();
            int n3 = 1;
            if (iContentDescriber == null || (!iLazySource.isText() || iContentDescriber instanceof ITextContentDescriber) && (n3 = contentType.describe(iContentDescriber, iLazySource, null)) != 0) {
                if (n3 == 2) {
                    list.add(n++, contentType);
                } else {
                    list.add(contentType);
                }
            }
            ++n2;
        }
        return n;
    }

    void dissociate(ContentType contentType, String string, int n) {
        String string2;
        Map map = (n & 4) != 0 ? this.fileNames : this.fileExtensions;
        Set set = (Set)map.get(string2 = FileSpec.getMappingKeyFor(string));
        if (set == null) {
            return;
        }
        set.remove(contentType);
    }

    private boolean ensureValid(ContentType contentType) {
        if (contentType.getValidation() != 0) {
            return contentType.isValid();
        }
        contentType.setValidation((byte)2);
        if (contentType.isAlias()) {
            return false;
        }
        ContentType contentType2 = null;
        if (contentType.getBaseTypeId() != null) {
            contentType2 = (ContentType)this.contentTypes.get(contentType.getBaseTypeId());
            if (contentType2 == null) {
                return false;
            }
            contentType2 = contentType2.getAliasTarget(true);
            this.ensureValid(contentType2);
            if (contentType2.getValidation() != 1) {
                return false;
            }
        }
        contentType.setValidation((byte)1);
        contentType.setBaseType(contentType2);
        return true;
    }

    IContentType[] findContentTypesFor(ContentTypeMatcher contentTypeMatcher, InputStream inputStream, String string) throws IOException {
        ILazySource iLazySource = ContentTypeManager.readBuffer(inputStream);
        IContentType[] iContentTypeArray = this.internalFindContentTypesFor(contentTypeMatcher, iLazySource, string, true);
        IContentTypeManager.ISelectionPolicy iSelectionPolicy = contentTypeMatcher.getPolicy();
        if (iSelectionPolicy != null) {
            iContentTypeArray = this.applyPolicy(iSelectionPolicy, iContentTypeArray, string != null, true);
        }
        return iContentTypeArray;
    }

    IContentType[] findContentTypesFor(ContentTypeMatcher contentTypeMatcher, String string) {
        IContentType[] iContentTypeArray = ContentTypeCatalog.concat(this.internalFindContentTypesFor(contentTypeMatcher, string, this.policyConstantGeneralIsBetter));
        IContentTypeManager.ISelectionPolicy iSelectionPolicy = contentTypeMatcher.getPolicy();
        if (iSelectionPolicy != null) {
            iContentTypeArray = this.applyPolicy(iSelectionPolicy, iContentTypeArray, true, false);
        }
        return iContentTypeArray;
    }

    public IContentType[] getAllContentTypes() {
        ArrayList<ContentType> arrayList = new ArrayList<ContentType>(this.contentTypes.size());
        Iterator iterator = this.contentTypes.values().iterator();
        while (iterator.hasNext()) {
            ContentType contentType = (ContentType)iterator.next();
            if (!contentType.isValid() || contentType.isAlias()) continue;
            arrayList.add(contentType);
        }
        return arrayList.toArray(new IContentType[arrayList.size()]);
    }

    public ContentType[] getChildren(ContentType contentType) {
        ContentType[] contentTypeArray = (ContentType[])this.allChildren.get(contentType);
        if (contentTypeArray != null) {
            return contentTypeArray;
        }
        ArrayList<ContentType> arrayList = new ArrayList<ContentType>(5);
        Iterator iterator = this.contentTypes.values().iterator();
        while (iterator.hasNext()) {
            ContentType contentType2 = (ContentType)iterator.next();
            if (contentType2.getBaseType() != contentType) continue;
            arrayList.add(contentType2);
        }
        contentTypeArray = arrayList.toArray(new ContentType[arrayList.size()]);
        this.allChildren.put(contentType, contentTypeArray);
        return contentTypeArray;
    }

    public ContentType getContentType(String string) {
        ContentType contentType = this.internalGetContentType(string);
        return contentType != null && contentType.isValid() && !contentType.isAlias() ? contentType : null;
    }

    private IContentDescription getDescriptionFor(ContentTypeMatcher contentTypeMatcher, ILazySource iLazySource, String string, QualifiedName[] qualifiedNameArray) throws IOException {
        IContentType[] iContentTypeArray = this.internalFindContentTypesFor(contentTypeMatcher, iLazySource, string, false);
        if (iContentTypeArray.length == 0) {
            return null;
        }
        IContentTypeManager.ISelectionPolicy iSelectionPolicy = contentTypeMatcher.getPolicy();
        if (iSelectionPolicy != null && (iContentTypeArray = this.applyPolicy(iSelectionPolicy, iContentTypeArray, string != null, true)).length == 0) {
            return null;
        }
        return contentTypeMatcher.getSpecificDescription(((ContentType)iContentTypeArray[0]).internalGetDescriptionFor(iLazySource, qualifiedNameArray));
    }

    public IContentDescription getDescriptionFor(ContentTypeMatcher contentTypeMatcher, InputStream inputStream, String string, QualifiedName[] qualifiedNameArray) throws IOException {
        return this.getDescriptionFor(contentTypeMatcher, ContentTypeManager.readBuffer(inputStream), string, qualifiedNameArray);
    }

    public IContentDescription getDescriptionFor(ContentTypeMatcher contentTypeMatcher, Reader reader, String string, QualifiedName[] qualifiedNameArray) throws IOException {
        return this.getDescriptionFor(contentTypeMatcher, ContentTypeManager.readBuffer(reader), string, qualifiedNameArray);
    }

    public int getGeneration() {
        return this.generation;
    }

    public ContentTypeManager getManager() {
        return this.manager;
    }

    public boolean internalAccept(ContentTypeVisitor contentTypeVisitor, ContentType contentType) {
        if (!contentType.isValid() || contentType.isAlias()) {
            return true;
        }
        int n = contentTypeVisitor.visit(contentType);
        switch (n) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        ContentType[] contentTypeArray = this.getChildren(contentType);
        if (contentTypeArray == null) {
            return true;
        }
        int n2 = 0;
        while (n2 < contentTypeArray.length) {
            if (!this.internalAccept(contentTypeVisitor, contentTypeArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IContentType[] internalFindContentTypesFor(ILazySource iLazySource, IContentType[][] iContentTypeArray, Comparator comparator, Comparator comparator2) throws IOException {
        ArrayList arrayList = new ArrayList(5);
        int n = this.collectMatchingByContents(0, iContentTypeArray[0], arrayList, iLazySource);
        int n2 = arrayList.size();
        int n3 = this.collectMatchingByContents(n, iContentTypeArray[1], arrayList, iLazySource) - n;
        int n4 = arrayList.size() - n2;
        IContentType[] iContentTypeArray2 = arrayList.toArray(new IContentType[arrayList.size()]);
        if (n > 1) {
            Arrays.sort(iContentTypeArray2, 0, n, comparator);
        }
        if (n3 > 1) {
            Arrays.sort(iContentTypeArray2, n, n + n3, comparator);
        }
        if (n2 - n > 1) {
            Arrays.sort(iContentTypeArray2, n + n3, n2 + n3, comparator2);
        }
        if (n4 - n3 > 1) {
            Arrays.sort(iContentTypeArray2, n2 + n3, arrayList.size(), comparator2);
        }
        return iContentTypeArray2;
    }

    private IContentType[] internalFindContentTypesFor(ContentTypeMatcher contentTypeMatcher, ILazySource iLazySource, String string, boolean bl) throws IOException {
        Comparator comparator;
        Comparator comparator2;
        IContentType[][] iContentTypeArray;
        if (string == null) {
            iContentTypeArray = new IContentType[][]{this.getAllContentTypes(), NO_CONTENT_TYPES};
            comparator2 = this.policyConstantGeneralIsBetter;
            comparator = this.policyConstantSpecificIsBetter;
        } else {
            iContentTypeArray = this.internalFindContentTypesFor(contentTypeMatcher, string, this.policyLexicographical);
            comparator2 = this.policyGeneralIsBetter;
            comparator = this.policySpecificIsBetter;
        }
        int n = iContentTypeArray[0].length + iContentTypeArray[1].length;
        if (n == 0) {
            return NO_CONTENT_TYPES;
        }
        if (!bl && n == 1) {
            IContentType[] iContentTypeArray2;
            IContentType[] iContentTypeArray3 = iContentTypeArray2 = iContentTypeArray[0].length == 1 ? iContentTypeArray[0] : iContentTypeArray[1];
            if (!iLazySource.isText()) {
                return iContentTypeArray2;
            }
            IContentDescriber iContentDescriber = ((ContentType)iContentTypeArray2[0]).getDescriber();
            if (iContentDescriber == null || iContentDescriber instanceof ITextContentDescriber) {
                return iContentTypeArray2;
            }
            return NO_CONTENT_TYPES;
        }
        return this.internalFindContentTypesFor(iLazySource, iContentTypeArray, comparator, comparator2);
    }

    public IContentType[][] internalFindContentTypesFor(ContentTypeMatcher contentTypeMatcher, String string, Comparator comparator) {
        HashSet hashSet;
        IScopeContext iScopeContext = contentTypeMatcher.getContext();
        IContentType[][] iContentTypeArray = new IContentType[][]{NO_CONTENT_TYPES, NO_CONTENT_TYPES};
        if (iScopeContext.equals(this.manager.getContext())) {
            hashSet = this.getDirectlyAssociated(string, 4);
        } else {
            hashSet = new HashSet(this.getDirectlyAssociated(string, 6));
            hashSet.addAll(contentTypeMatcher.getDirectlyAssociated(this, string, 4));
        }
        Set set = this.selectMatchingByName(iScopeContext, hashSet, Collections.EMPTY_SET, string, 4);
        iContentTypeArray[0] = set.toArray(new IContentType[set.size()]);
        String string2 = ContentTypeManager.getFileExtension(string);
        if (string2 != null) {
            HashSet hashSet2;
            if (iScopeContext.equals(this.manager.getContext())) {
                hashSet2 = this.getDirectlyAssociated(string2, 8);
            } else {
                hashSet2 = new HashSet(this.getDirectlyAssociated(string2, 10));
                hashSet2.addAll(contentTypeMatcher.getDirectlyAssociated(this, string2, 8));
            }
            Set set2 = this.selectMatchingByName(iScopeContext, hashSet2, set, string2, 8);
            if (!set2.isEmpty()) {
                iContentTypeArray[1] = set2.toArray(new IContentType[set2.size()]);
            }
        }
        if (iContentTypeArray[0].length > 1) {
            Arrays.sort(iContentTypeArray[0], comparator);
        }
        if (iContentTypeArray[1].length > 1) {
            Arrays.sort(iContentTypeArray[1], comparator);
        }
        return iContentTypeArray;
    }

    public Set getDirectlyAssociated(String string, int n) {
        Map map = (n & 4) != 0 ? this.fileNames : this.fileExtensions;
        HashSet hashSet = null;
        if ((n & 3) == 0) {
            hashSet = (HashSet)map.get(FileSpec.getMappingKeyFor(string));
        } else {
            Set set = (Set)map.get(FileSpec.getMappingKeyFor(string));
            if (set != null && !set.isEmpty()) {
                hashSet = new HashSet(set);
                n ^= 3;
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ContentType contentType = (ContentType)iterator.next();
                    if (contentType.hasFileSpec(string, n, true)) continue;
                    iterator.remove();
                }
            }
        }
        return hashSet == null ? Collections.EMPTY_SET : hashSet;
    }

    ContentType internalGetContentType(String string) {
        return (ContentType)this.contentTypes.get(string);
    }

    void makeAliases() {
        Iterator iterator = this.contentTypes.values().iterator();
        while (iterator.hasNext()) {
            ContentType contentType;
            ContentType contentType2 = (ContentType)iterator.next();
            String string = contentType2.getAliasTargetId();
            if (string == null || (contentType = this.internalGetContentType(string)) == null) continue;
            contentType2.setAliasTarget(contentType);
        }
    }

    protected void organize() {
        ContentType contentType;
        this.makeAliases();
        Iterator iterator = this.contentTypes.values().iterator();
        while (iterator.hasNext()) {
            contentType = (ContentType)iterator.next();
            if (!this.ensureValid(contentType)) continue;
            this.associate(contentType);
        }
        if (ContentTypeManager.DEBUGGING) {
            iterator = this.contentTypes.values().iterator();
            while (iterator.hasNext()) {
                contentType = (ContentType)iterator.next();
                if (contentType.isValid()) continue;
                ContentMessages.message("Invalid: " + contentType);
            }
        }
    }

    private Set selectMatchingByName(final IScopeContext iScopeContext, Collection collection, final Collection collection2, final String string, final int n) {
        if (collection == null || collection.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        final HashSet hashSet = new HashSet(5);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            final ContentType contentType = (ContentType)iterator.next();
            this.internalAccept(new ContentTypeVisitor(){

                public int visit(ContentType contentType2) {
                    if (contentType2 != contentType && contentType2.hasBuiltInAssociations()) {
                        return 1;
                    }
                    if (contentType2 == contentType && !contentType2.hasFileSpec(iScopeContext, string, n)) {
                        return 1;
                    }
                    if (!collection2.contains(contentType2)) {
                        hashSet.add(contentType2);
                    }
                    return 0;
                }
            }, contentType);
        }
        return hashSet;
    }
}

