/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class ScrolledComposite
extends Composite {
    private Control content;
    private Listener contentListener;
    private int minHeight = 0;
    private int minWidth = 0;
    private boolean expandHorizontal = false;
    private boolean expandVertical = false;
    private boolean alwaysShowScroll = false;
    private boolean inResize = false;
    private boolean autoScrollIsActive = false;
    FocusListener focusListenerToScroll = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            if (!ScrolledComposite.this.autoScrollIsActive) {
                return;
            }
            Control control = (Control)focusEvent.widget;
            while (control.getParent() != ScrolledComposite.this.content) {
                if ((control = control.getParent()) != null) continue;
                return;
            }
            Point point = ScrolledComposite.this.getContent().toDisplay(control.getLocation());
            point = ScrolledComposite.this.getContent().toControl(point);
            Rectangle rectangle = new Rectangle(-((ScrolledComposite)ScrolledComposite.this).content.getLocation().x, -((ScrolledComposite)ScrolledComposite.this).content.getLocation().y, ScrolledComposite.this.getClientArea().width, ScrolledComposite.this.getClientArea().height);
            Rectangle rectangle2 = new Rectangle(point.x, point.y, control.getBounds().width, control.getBounds().height);
            if (!rectangle.intersection(rectangle2).equals((Object)rectangle2)) {
                ScrollBar scrollBar;
                Point point2 = ScrolledComposite.this.getNeedMoving(rectangle, rectangle2);
                Point point3 = new Point(((ScrolledComposite)ScrolledComposite.this).content.getLocation().x + point2.x, ((ScrolledComposite)ScrolledComposite.this).content.getLocation().y + point2.y);
                ScrollBar scrollBar2 = ScrolledComposite.this.getVerticalBar();
                if (scrollBar2 != null) {
                    scrollBar2.setSelection(-point3.y);
                }
                if ((scrollBar = ScrolledComposite.this.getHorizontalBar()) != null) {
                    scrollBar.setSelection(-point3.x);
                }
                ScrolledComposite.this.content.setLocation(point3.x, point3.y);
                ScrolledComposite.this.redraw();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    };
    static /* synthetic */ Class class$0;

    public ScrolledComposite(Composite composite, int n) {
        super(composite, ScrolledComposite.checkStyle(n));
        ScrollBar scrollBar;
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.setIncrement(50);
            scrollBar2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ScrolledComposite.this.hScroll();
                }
            });
        }
        if ((scrollBar = this.getVerticalBar()) != null) {
            scrollBar.setIncrement(50);
            scrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ScrolledComposite.this.vScroll();
                }
            });
        }
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ScrolledComposite.this.resize();
            }
        });
        this.contentListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type != 11) {
                    return;
                }
                ScrolledComposite.this.resize();
            }
        };
    }

    private static int checkStyle(int n) {
        int n2 = 0x6000B00;
        return n & n2;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (this.content == null) {
            return super.computeSize(n, n2, bl);
        }
        Point point = this.content.computeSize(n, n2, bl);
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    public boolean getAlwaysShowScrollBars() {
        return this.alwaysShowScroll;
    }

    public Control getContent() {
        return this.content;
    }

    void hScroll() {
        if (this.content == null) {
            return;
        }
        Point point = this.content.getLocation();
        ScrollBar scrollBar = this.getHorizontalBar();
        int n = scrollBar.getSelection();
        this.content.setLocation(-n, point.y);
    }

    public void layout(boolean bl) {
        int n;
        int n2;
        this.checkWidget();
        if (this.content == null) {
            return;
        }
        Rectangle rectangle = this.content.getBounds();
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!this.alwaysShowScroll) {
            bl2 = this.needHScroll(rectangle, false);
            bl3 = this.needVScroll(rectangle, bl2);
            if (!bl2 && bl3) {
                bl2 = this.needHScroll(rectangle, bl3);
            }
            if (scrollBar != null) {
                scrollBar.setVisible(bl2);
            }
            if (scrollBar2 != null) {
                scrollBar2.setVisible(bl3);
            }
        } else {
            bl2 = true;
            bl3 = true;
        }
        Rectangle rectangle2 = this.getHostRectangle(bl2, bl3);
        if (this.expandHorizontal) {
            rectangle.width = Math.max(this.minWidth, rectangle2.width);
        }
        if (this.expandVertical) {
            rectangle.height = Math.max(this.minHeight, rectangle2.height);
        }
        if (scrollBar != null) {
            scrollBar.setMaximum(rectangle.width);
            scrollBar.setThumb(Math.min(rectangle.width, rectangle2.width));
            n2 = rectangle.width - rectangle2.width;
            n = scrollBar.getSelection();
            if (n >= n2) {
                if (n2 <= 0) {
                    n = 0;
                    scrollBar.setSelection(0);
                }
                rectangle.x = -n;
            }
        }
        if (scrollBar2 != null) {
            scrollBar2.setMaximum(rectangle.height);
            scrollBar2.setThumb(Math.min(rectangle.height, rectangle2.height));
            n2 = rectangle.height - rectangle2.height;
            n = scrollBar2.getSelection();
            if (n >= n2) {
                if (n2 <= 0) {
                    n = 0;
                    scrollBar2.setSelection(0);
                }
                rectangle.y = -n;
            }
        }
        this.content.setBounds(rectangle);
    }

    private boolean needHScroll(Rectangle rectangle, boolean bl) {
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar == null) {
            return false;
        }
        Rectangle rectangle2 = this.getHostRectangle(false, bl);
        if (!this.expandHorizontal && rectangle.width > rectangle2.width) {
            return true;
        }
        return this.expandHorizontal && this.minWidth > rectangle2.width;
    }

    private boolean needVScroll(Rectangle rectangle, boolean bl) {
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar == null) {
            return false;
        }
        Rectangle rectangle2 = this.getHostRectangle(bl, false);
        if (!this.expandHorizontal && rectangle.height > rectangle2.height) {
            return true;
        }
        return this.expandHorizontal && this.minHeight > rectangle2.height;
    }

    private Rectangle getHostRectangle(boolean bl, boolean bl2) {
        Rectangle rectangle = this.getBounds();
        int n = this.getBorderWidth();
        rectangle.height -= 2 * n;
        rectangle.width -= 2 * n;
        ScrollBar scrollBar = this.getHorizontalBar();
        if (bl && scrollBar != null) {
            rectangle.height -= scrollBar.getSize().y;
        }
        ScrollBar scrollBar2 = this.getVerticalBar();
        if (bl2 && scrollBar2 != null) {
            rectangle.width -= scrollBar2.getSize().x;
        }
        return rectangle;
    }

    void resize() {
        if (this.inResize) {
            return;
        }
        this.inResize = true;
        this.layout();
        this.inResize = false;
    }

    public Point getOrigin() {
        this.checkWidget();
        if (this.content == null) {
            return new Point(0, 0);
        }
        Point point = this.content.getLocation();
        return new Point(-point.x, -point.y);
    }

    public void setOrigin(Point point) {
        this.setOrigin(point.x, point.y);
    }

    public void setOrigin(int n, int n2) {
        this.checkWidget();
        if (this.content == null) {
            return;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setSelection(n);
            n = -scrollBar.getSelection();
        } else {
            n = 0;
        }
        ScrollBar scrollBar2 = this.getVerticalBar();
        if (scrollBar2 != null) {
            scrollBar2.setSelection(n2);
            n2 = -scrollBar2.getSelection();
        } else {
            n2 = 0;
        }
        this.content.setLocation(n, n2);
    }

    public void setAlwaysShowScrollBars(boolean bl) {
        ScrollBar scrollBar;
        this.checkWidget();
        if (bl == this.alwaysShowScroll) {
            return;
        }
        this.alwaysShowScroll = bl;
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (scrollBar2 != null && this.alwaysShowScroll) {
            scrollBar2.setVisible(true);
        }
        if ((scrollBar = this.getVerticalBar()) != null && this.alwaysShowScroll) {
            scrollBar.setVisible(true);
        }
        this.layout();
    }

    public void setContent(Control control) {
        this.checkWidget();
        if (this.content != null && !this.content.isDisposed()) {
            this.content.removeListener(11, this.contentListener);
            this.content.setBounds(new Rectangle(-200, -200, 0, 0));
        }
        this.content = control;
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (this.content != null) {
            if (scrollBar != null) {
                scrollBar.setMaximum(0);
                scrollBar.setThumb(0);
                scrollBar.setSelection(0);
            }
            if (scrollBar2 != null) {
                scrollBar2.setMaximum(0);
                scrollBar2.setThumb(0);
                scrollBar2.setSelection(0);
            }
            control.setLocation(0, 0);
            this.layout();
            this.content.addListener(11, this.contentListener);
        } else {
            if (scrollBar2 != null) {
                scrollBar2.setVisible(this.alwaysShowScroll);
            }
            if (scrollBar != null) {
                scrollBar.setVisible(this.alwaysShowScroll);
            }
        }
    }

    public void setAutoScroll(boolean bl) {
        this.autoScrollIsActive = bl;
        if (this.autoScrollIsActive) {
            ScrolledComposite.addFocusListenerToAllChildren(this, this.focusListenerToScroll);
        }
    }

    boolean isAutoScrollActivate() {
        return this.autoScrollIsActive;
    }

    public void setExpandHorizontal(boolean bl) {
        this.checkWidget();
        if (bl == this.expandHorizontal) {
            return;
        }
        this.expandHorizontal = bl;
        this.layout();
    }

    public void setExpandVertical(boolean bl) {
        this.checkWidget();
        if (bl == this.expandVertical) {
            return;
        }
        this.expandVertical = bl;
        this.layout();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMinHeight(int n) {
        this.setMinSize(this.minWidth, n);
    }

    public void setMinSize(Point point) {
        if (point == null) {
            this.setMinSize(0, 0);
        } else {
            this.setMinSize(point.x, point.y);
        }
    }

    public void setMinSize(int n, int n2) {
        this.checkWidget();
        if (n == this.minWidth && n2 == this.minHeight) {
            return;
        }
        this.minWidth = Math.max(0, n);
        this.minHeight = Math.max(0, n2);
        this.layout();
    }

    public void setMinWidth(int n) {
        this.setMinSize(n, this.minHeight);
    }

    void vScroll() {
        if (this.content == null) {
            return;
        }
        Point point = this.content.getLocation();
        ScrollBar scrollBar = this.getVerticalBar();
        int n = scrollBar.getSelection();
        this.content.setLocation(point.x, -n);
    }

    static void addFocusListenerToAllChildren(Composite composite, FocusListener focusListener) {
        if (composite != null) {
            composite.addFocusListener(focusListener);
            Control[] controlArray = composite.getChildren();
            if (controlArray == null) {
                return;
            }
            int n = 0;
            while (n < controlArray.length) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.swt.widgets.Composite");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(controlArray[n].getClass())) {
                    ScrolledComposite.addFocusListenerToAllChildren((Composite)controlArray[n], focusListener);
                } else {
                    controlArray[n].addFocusListener(focusListener);
                }
                ++n;
            }
        }
    }

    private Point getNeedMoving(Rectangle rectangle, Rectangle rectangle2) {
        Point point = new Point(0, 0);
        if (rectangle2.x < rectangle.x) {
            point.x = rectangle.x - rectangle2.x;
        }
        if (rectangle.x + rectangle.width < rectangle2.x + rectangle2.width) {
            point.x += rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width);
        }
        if (rectangle2.y < rectangle.y) {
            point.y = rectangle.y - rectangle2.y;
        }
        if (rectangle.y + rectangle.height < rectangle2.y + rectangle2.height) {
            point.y += rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
        }
        return point;
    }
}

