/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.dom;

import org.eclipse.ercp.xml.dom.DocumentImpl;
import org.eclipse.ercp.xml.dom.TreeNode;
import org.w3c.dom.DOMException;

public abstract class CharacterDataImpl
extends TreeNode {
    protected String data;

    public CharacterDataImpl(DocumentImpl ownerDocument, String data) {
        super(ownerDocument);
        this.data = data;
    }

    public String getData() throws DOMException {
        return this.data;
    }

    public void setData(String data) throws DOMException {
        this.data = data;
    }

    public String substringData(int offset, int count) throws DOMException {
        if (count < 0 || offset < 0 || offset > this.data.length() - 1) {
            throw new DOMException(1, null);
        }
        int tailIndex = offset + count < this.data.length() ? offset + count : this.data.length();
        return this.data.substring(offset, tailIndex);
    }

    public void appendData(String arg) throws DOMException {
        this.data = String.valueOf(this.data) + arg;
    }

    public void insertData(int offset, String arg) throws DOMException {
        try {
            StringBuffer buffer = new StringBuffer(this.data.length() + arg.length());
            buffer.append(this.data.substring(0, offset));
            buffer.append(arg);
            buffer.append(this.data.substring(offset));
            this.data = buffer.toString();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMException(1, null);
        }
    }

    public void deleteData(int offset, int count) throws DOMException {
        if (count < 0) {
            throw new DOMException(1, null);
        }
        int tailLength = this.data.length() - count - offset;
        tailLength = tailLength > 0 ? tailLength : 0;
        try {
            this.data = String.valueOf(this.data.substring(0, offset)) + (tailLength > 0 ? this.data.substring(offset + count, offset + count + tailLength) : "");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMException(1, null);
        }
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        this.deleteData(offset, count);
        this.insertData(offset, arg);
    }

    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.setData(nodeValue);
    }
}

