/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutPartSash;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.LayoutTreeNode;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.dnd.SwtUtil;

public abstract class PartSashContainer
extends LayoutPart
implements ILayoutContainer {
    protected Composite parent;
    protected ControlListener resizeListener;
    protected LayoutTree root;
    private LayoutPart zoomedPart;
    protected WorkbenchPage page;
    boolean active = false;
    boolean layoutDirty = false;
    protected ArrayList children = new ArrayList();

    public PartSashContainer(String id, WorkbenchPage page) {
        super(id);
        this.page = page;
        this.resizeListener = new ControlListener(){

            public void controlResized(ControlEvent e) {
                PartSashContainer.this.resizeSashes();
            }

            public void controlMoved(ControlEvent e) {
            }
        };
    }

    public boolean childObscuredByZoom(LayoutPart toTest) {
        LayoutPart zoomPart = this.getZoomedPart();
        if (zoomPart != null && toTest != zoomPart) {
            return true;
        }
        return this.isObscuredByZoom();
    }

    private PartPane[] getVisibleParts(LayoutPart pane) {
        if (pane instanceof PartPane) {
            return new PartPane[]{(PartPane)pane};
        }
        if (pane instanceof PartStack) {
            PartStack stack = (PartStack)pane;
            LayoutPart[] children = stack.getChildren();
            ArrayList<LayoutPart> result = new ArrayList<LayoutPart>(children.length);
            int idx = 0;
            while (idx < children.length) {
                LayoutPart next = children[idx];
                if (next instanceof PartPane) {
                    result.add(next);
                }
                ++idx;
            }
            return result.toArray(new PartPane[result.size()]);
        }
        return new PartPane[0];
    }

    public void add(LayoutPart child) {
        if (child == null) {
            return;
        }
        this.addEnhanced(child, 131072, 0.5f, this.findBottomRight());
    }

    void addEnhanced(LayoutPart child, int swtDirectionConstant, float ratioForNewPart, LayoutPart relative) {
        this.add(child, swtDirectionConstant, ratioForNewPart, relative);
    }

    public void add(LayoutPart child, int relationship, float ratio, LayoutPart relative) {
        Rectangle bounds;
        boolean isHorizontal = relationship == 1 || relationship == 2;
        LayoutTree node = null;
        if (this.root != null && relative != null) {
            node = this.root.find(relative);
        }
        if (this.getParent() == null) {
            Composite control = this.getPage().getClientComposite();
            bounds = control != null && !control.isDisposed() ? control.getBounds() : new Rectangle(0, 0, 800, 600);
            bounds.x = 0;
            bounds.y = 0;
        } else {
            bounds = this.getBounds();
        }
        int totalSize = PartSashContainer.measureTree(bounds, node, isHorizontal);
        int left = (int)((float)totalSize * ratio);
        int right = totalSize - left;
        this.add(child, relationship, left, right, relative);
    }

    static int measureTree(Rectangle outerBounds, LayoutTree toMeasure, boolean horizontal) {
        if (toMeasure == null) {
            return Geometry.getDimension((Rectangle)outerBounds, (boolean)horizontal);
        }
        LayoutTreeNode parent = toMeasure.getParent();
        if (parent == null) {
            return Geometry.getDimension((Rectangle)outerBounds, (boolean)horizontal);
        }
        if (parent.getSash().isHorizontal() == horizontal) {
            return PartSashContainer.measureTree(outerBounds, parent, horizontal);
        }
        boolean isLeft = parent.isLeftChild(toMeasure);
        LayoutTree otherChild = parent.getChild(!isLeft);
        if (otherChild.isVisible()) {
            int left = parent.getSash().getLeft();
            int right = parent.getSash().getRight();
            int childSize = isLeft ? left : right;
            int bias = parent.getCompressionBias();
            if (isLeft) {
                bias = -bias;
            }
            if (bias == 1) {
                return childSize;
            }
            if (bias == -1) {
                return PartSashContainer.measureTree(outerBounds, parent, horizontal) - (left + right - childSize);
            }
            return PartSashContainer.measureTree(outerBounds, parent, horizontal) * childSize / (left + right);
        }
        return PartSashContainer.measureTree(outerBounds, parent, horizontal);
    }

    protected void addChild(RelationshipInfo info) {
        LayoutPart child = info.part;
        this.children.add(child);
        if (this.root == null) {
            this.root = new LayoutTree(child);
        } else {
            int vertical = info.relationship == 1 || info.relationship == 2 ? 512 : 256;
            boolean left = info.relationship == 1 || info.relationship == 3;
            LayoutPartSash sash = new LayoutPartSash(this, vertical);
            sash.setSizes(info.left, info.right);
            if (this.parent != null && !(child instanceof PartPlaceholder)) {
                sash.createControl(this.parent);
            }
            this.root = this.root.insert(child, left, sash, info.relative);
        }
        this.childAdded(child);
        if (this.active) {
            child.createControl(this.parent);
            child.setVisible(true);
            child.setContainer(this);
            this.resizeChild(child);
        }
    }

    void addChildForPlaceholder(LayoutPart child, LayoutPart placeholder) {
        RelationshipInfo newRelationshipInfo = new RelationshipInfo();
        newRelationshipInfo.part = child;
        if (this.root != null) {
            newRelationshipInfo.relationship = 2;
            newRelationshipInfo.relative = this.root.findBottomRight();
            newRelationshipInfo.left = 200;
            newRelationshipInfo.right = 200;
        }
        RelationshipInfo[] relationships = this.computeRelation();
        int i = 0;
        while (i < relationships.length) {
            RelationshipInfo info = relationships[i];
            if (info.part == placeholder) {
                newRelationshipInfo.left = info.left;
                newRelationshipInfo.right = info.right;
                newRelationshipInfo.relationship = info.relationship;
                newRelationshipInfo.relative = info.relative;
            }
            ++i;
        }
        this.addChild(newRelationshipInfo);
        this.flushLayout();
    }

    public boolean allowsBorder() {
        return true;
    }

    protected void childAdded(LayoutPart child) {
        if (this.isDeferred()) {
            child.deferUpdates(true);
        }
    }

    protected void childRemoved(LayoutPart child) {
        if (this.isDeferred()) {
            child.deferUpdates(false);
        }
    }

    public RelationshipInfo[] computeRelation() {
        LayoutTree treeRoot = this.root;
        ArrayList<RelationshipInfo> list = new ArrayList<RelationshipInfo>();
        if (treeRoot == null) {
            return new RelationshipInfo[0];
        }
        RelationshipInfo r = new RelationshipInfo();
        r.part = treeRoot.computeRelation(list);
        list.add(0, r);
        RelationshipInfo[] result = new RelationshipInfo[list.size()];
        list.toArray(result);
        return result;
    }

    public void createControl(Composite parentWidget) {
        if (this.active) {
            return;
        }
        this.parent = this.createParent(parentWidget);
        this.parent.addControlListener(this.resizeListener);
        ArrayList children = (ArrayList)this.children.clone();
        int i = 0;
        int length = children.size();
        while (i < length) {
            LayoutPart child = (LayoutPart)children.get(i);
            child.setContainer(this);
            child.createControl(this.parent);
            child.setVisible(this.zoomedPart == null || child == this.zoomedPart);
            ++i;
        }
        if (this.root != null) {
            this.root.flushChildren();
            if (!this.isZoomed()) {
                this.root.createControl(this.parent);
            }
        }
        this.active = true;
        this.resizeSashes();
    }

    protected abstract Composite createParent(Composite var1);

    public void dispose() {
        if (!this.active) {
            return;
        }
        if (this.resizeListener != null && this.parent != null) {
            this.parent.removeControlListener(this.resizeListener);
        }
        if (this.children != null) {
            int i = 0;
            int length = this.children.size();
            while (i < length) {
                LayoutPart child = (LayoutPart)this.children.get(i);
                child.setContainer(null);
                if (child instanceof ViewStack) {
                    child.dispose();
                }
                ++i;
            }
        }
        this.disposeParent();
        this.disposeSashes();
        this.parent = null;
        this.active = false;
    }

    protected abstract void disposeParent();

    public void disposeSashes() {
        if (this.root != null) {
            this.root.disposeSashes();
        }
    }

    public void setVisible(boolean makeVisible) {
        if (makeVisible == this.getVisible()) {
            return;
        }
        if (!SwtUtil.isDisposed((Control)this.parent)) {
            this.parent.setEnabled(makeVisible);
        }
        super.setVisible(makeVisible);
        ArrayList children = (ArrayList)this.children.clone();
        int i = 0;
        int length = children.size();
        while (i < length) {
            LayoutPart child = (LayoutPart)children.get(i);
            child.setVisible(makeVisible && (this.zoomedPart == null || child == this.zoomedPart));
            ++i;
        }
    }

    public LayoutPart findBottomRight() {
        if (this.root == null) {
            return null;
        }
        return this.root.findBottomRight();
    }

    public Rectangle getBounds() {
        return this.parent.getBounds();
    }

    public LayoutPart[] getChildren() {
        LayoutPart[] result = new LayoutPart[this.children.size()];
        this.children.toArray(result);
        return result;
    }

    public Control getControl() {
        return this.parent;
    }

    public LayoutTree getLayoutTree() {
        return this.root;
    }

    public WorkbenchPage getPage() {
        return this.page;
    }

    public Composite getParent() {
        return this.parent;
    }

    protected boolean isChild(LayoutPart part) {
        return this.children.indexOf(part) >= 0;
    }

    private boolean isRelationshipCompatible(int relationship, boolean isVertical) {
        if (isVertical) {
            return relationship == 2 || relationship == 1;
        }
        return relationship == 3 || relationship == 4;
    }

    public boolean isZoomed() {
        return this.zoomedPart != null;
    }

    public void resizeChild(LayoutPart childThatChanged) {
        LayoutTree tree;
        if (this.root != null && (tree = this.root.find(childThatChanged)) != null) {
            tree.flushCache();
        }
        this.flushLayout();
    }

    public void remove(LayoutPart child) {
        if (child == this.getZoomedPart()) {
            this.childRequestZoomOut();
        }
        if (!this.isChild(child)) {
            return;
        }
        this.children.remove(child);
        if (this.root != null) {
            this.root = this.root.remove(child);
        }
        this.childRemoved(child);
        if (this.active) {
            child.setVisible(false);
            child.setContainer(null);
            this.flushLayout();
        }
    }

    public void flushLayout() {
        this.layoutDirty = true;
        super.flushLayout();
        if (this.layoutDirty) {
            this.resizeSashes();
        }
    }

    public void replace(LayoutPart oldChild, LayoutPart newChild) {
        if (!this.isChild(oldChild)) {
            return;
        }
        if (oldChild == this.getZoomedPart()) {
            if (newChild instanceof PartPlaceholder) {
                this.childRequestZoomOut();
            } else {
                this.zoomedPart.setZoomed(false);
                this.zoomedPart = newChild;
                this.zoomedPart.setZoomed(true);
            }
        }
        this.children.remove(oldChild);
        this.children.add(newChild);
        this.childAdded(newChild);
        if (this.root != null) {
            LayoutTree leaf = null;
            leaf = this.root.find(oldChild);
            if (leaf != null) {
                leaf.setPart(newChild);
            }
        }
        this.childRemoved(oldChild);
        if (this.active) {
            oldChild.setVisible(false);
            oldChild.setContainer(null);
            newChild.createControl(this.parent);
            newChild.setContainer(this);
            newChild.setVisible(this.zoomedPart == null || this.zoomedPart == newChild);
            this.resizeChild(newChild);
        }
    }

    private void resizeSashes() {
        this.layoutDirty = false;
        if (!this.active) {
            return;
        }
        if (this.isZoomed()) {
            this.getZoomedPart().setBounds(this.parent.getClientArea());
        } else if (this.root != null) {
            this.root.setBounds(this.parent.getClientArea());
        }
    }

    public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredParallel) {
        if (this.isZoomed()) {
            return this.getZoomedPart().computePreferredSize(width, availableParallel, availablePerpendicular, preferredParallel);
        }
        if (this.root != null) {
            return this.root.computePreferredSize(width, availableParallel, availablePerpendicular, preferredParallel);
        }
        return preferredParallel;
    }

    public int getSizeFlags(boolean width) {
        if (this.isZoomed()) {
            return this.getZoomedPart().getSizeFlags(width);
        }
        if (this.root != null) {
            return this.root.getSizeFlags(width);
        }
        return 0;
    }

    public void setBounds(Rectangle r) {
        this.parent.setBounds(r);
    }

    private void zoomIn(LayoutPart part) {
        if (this.isZoomed()) {
            return;
        }
        this.root.disposeSashes();
        LayoutPart[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            LayoutPart child;
            child.setVisible((child = children[i]) == part);
            ++i;
        }
        this.zoomedPart = part;
        part.setZoomed(true);
        this.layoutDirty = true;
    }

    public LayoutPart getZoomedPart() {
        return this.zoomedPart;
    }

    /*
     * Exception decompiling
     */
    public void childRequestZoomIn(LayoutPart toZoom) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 68->72)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void childRequestZoomOut() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 67->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setZoomed(boolean isZoomed) {
        LayoutPart toZoom;
        if (!isZoomed) {
            this.zoomOut();
        } else if (!this.isZoomed() && (toZoom = this.pickPartToZoom()) != null) {
            this.zoomIn(toZoom);
        }
        super.setZoomed(isZoomed);
    }

    public LayoutPart pickPartToZoom() {
        return this.findBottomRight();
    }

    private void zoomOut() {
        if (!this.isZoomed()) {
            return;
        }
        LayoutPart zoomedPart = this.zoomedPart;
        this.zoomedPart = null;
        zoomedPart.setZoomed(false);
        LayoutPart[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            LayoutPart child = children[i];
            child.setVisible(true);
            ++i;
        }
        this.root.createControl(this.getParent());
        LayoutTree node = this.root.find(zoomedPart);
        node.flushCache();
        this.layoutDirty = true;
    }

    public abstract boolean isStackType(LayoutPart var1);

    public abstract boolean isPaneType(LayoutPart var1);

    protected abstract PartStack createStack();

    public void stack(LayoutPart newPart, ILayoutContainer container) {
        this.getControl().setRedraw(false);
        this.derefPart(newPart);
        newPart.reparent(this.getParent());
        container.add(newPart);
        this.getControl().setRedraw(true);
    }

    protected abstract void setVisiblePart(ILayoutContainer var1, LayoutPart var2);

    protected abstract LayoutPart getVisiblePart(ILayoutContainer var1);

    protected void derefPart(LayoutPart sourcePart) {
        PartStack stack;
        ILayoutContainer container = sourcePart.getContainer();
        if (container != null) {
            container.remove(sourcePart);
        }
        if (container instanceof LayoutPart && this.isStackType((LayoutPart)((Object)container)) && (stack = (PartStack)container).getChildren().length == 0) {
            this.remove(stack);
            stack.dispose();
        }
    }

    protected int getVisibleChildrenCount(ILayoutContainer container) {
        if (container == null) {
            return 0;
        }
        LayoutPart[] children = container.getChildren();
        int count = 0;
        int idx = 0;
        while (idx < children.length) {
            if (!(children[idx] instanceof PartPlaceholder)) {
                ++count;
            }
            ++idx;
        }
        return count;
    }

    protected float getDockingRatio(LayoutPart dragged, LayoutPart target) {
        return 0.5f;
    }

    public void describeLayout(StringBuffer buf) {
        if (this.root == null) {
            return;
        }
        if (this.isZoomed()) {
            buf.append("zoomed ");
            this.root.describeLayout(buf);
        } else {
            buf.append("layout ");
            this.root.describeLayout(buf);
        }
    }

    void add(LayoutPart child, int relationship, int left, int right, LayoutPart relative) {
        if (child == null) {
            return;
        }
        if (relative != null && !this.isChild(relative)) {
            return;
        }
        if (relationship < 1 || relationship > 4) {
            relationship = 1;
        }
        RelationshipInfo info = new RelationshipInfo();
        info.part = child;
        info.relationship = relationship;
        info.left = left;
        info.right = right;
        info.relative = relative;
        this.addChild(info);
    }

    public boolean childIsZoomed(LayoutPart toTest) {
        return toTest == this.getZoomedPart();
    }

    public boolean allowsAutoFocus() {
        return true;
    }

    protected void startDeferringEvents() {
        super.startDeferringEvents();
        LayoutPart[] deferredChildren = this.children.toArray(new LayoutPart[this.children.size()]);
        int i = 0;
        while (i < deferredChildren.length) {
            LayoutPart child = deferredChildren[i];
            child.deferUpdates(true);
            ++i;
        }
    }

    protected void handleDeferredEvents() {
        super.handleDeferredEvents();
        LayoutPart[] deferredChildren = this.children.toArray(new LayoutPart[this.children.size()]);
        int i = 0;
        while (i < deferredChildren.length) {
            LayoutPart child = deferredChildren[i];
            child.deferUpdates(false);
            ++i;
        }
    }

    public void testInvariants() {
        super.testInvariants();
        if (this.getContainer() != null) {
            Assert.isTrue((this.getZoomedPart() != null == this.getContainer().childIsZoomed(this) ? 1 : 0) != 0);
        }
        LayoutPart[] childArray = this.getChildren();
        int idx = 0;
        while (idx < childArray.length) {
            childArray[idx].testInvariants();
            ++idx;
        }
        if (this.isZoomed()) {
            Assert.isTrue((boolean)this.children.contains(this.zoomedPart));
        }
    }

    protected static class RelationshipInfo {
        protected LayoutPart part;
        protected LayoutPart relative;
        protected int relationship;
        protected int left;
        protected int right;

        protected RelationshipInfo() {
        }

        public float getRatio() {
            int total = this.left + this.right;
            if (total > 0) {
                return (float)this.left / (float)total;
            }
            return 0.5f;
        }
    }
}

