/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

class ViewFactory
implements IExtensionChangeHandler {
    private ReferenceCounter counter;
    private HashMap mementoTable = new HashMap();
    private WorkbenchPage page;
    private IViewRegistry viewReg;
    static final String ID_SEP = ":";
    static /* synthetic */ Class class$0;

    static String getKey(String id, String secondaryId) {
        return secondaryId == null ? id : String.valueOf(id) + ID_SEP + secondaryId;
    }

    static String getKey(IViewReference viewRef) {
        return ViewFactory.getKey(viewRef.getId(), viewRef.getSecondaryId());
    }

    static String extractPrimaryId(String compoundId) {
        int i = compoundId.lastIndexOf(ID_SEP);
        if (i == -1) {
            return compoundId;
        }
        return compoundId.substring(0, i);
    }

    static String extractSecondaryId(String compoundId) {
        int i = compoundId.lastIndexOf(ID_SEP);
        if (i == -1) {
            return null;
        }
        return compoundId.substring(i + 1);
    }

    static boolean hasWildcard(String viewId) {
        return viewId.indexOf(PartPlaceholder.WILD_CARD) >= 0;
    }

    public ViewFactory(WorkbenchPage page, IViewRegistry reg) {
        this.page = page;
        this.viewReg = reg;
        this.counter = new ReferenceCounter();
        page.getExtensionTracker().registerHandler((IExtensionChangeHandler)this, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus busyRestoreView(IViewReference ref_) {
        ViewReference ref = (ViewReference)ref_;
        IStatus partStatus = Status.OK_STATUS;
        if (ref.getPart(false) != null) {
            return Status.OK_STATUS;
        }
        if (ref.creationInProgress) {
            IStatus result = WorkbenchPlugin.getStatus((Throwable)((Object)new PartInitException(NLS.bind((String)"Warning: Detected attempt by view {0} to create itself recursively (this is probably, but not necessarily, a bug)", (Object)ref.getId()))));
            WorkbenchPlugin.log(result);
            return result;
        }
        try {
            ref.creationInProgress = true;
            partStatus = this.busyRestoreViewHelper(ref);
            if (ref.getPart(false) == null) {
                StatusUtil.newStatus(partStatus, NLS.bind((String)WorkbenchMessages.ViewFactory_initException, (Object)partStatus.getMessage()));
                IStatus logStatus = StatusUtil.newStatus(partStatus, NLS.bind((String)"Unable to create view ID {0}: {1}", (Object)ref.getId(), (Object)partStatus.getMessage()));
                WorkbenchPlugin.log(logStatus);
                String label = ref_.getId();
                IViewDescriptor desc = this.viewReg.find(ref.getId());
                if (desc != null) {
                    label = desc.getLabel();
                }
                PartPane pane = ref.getPane();
                new ViewSite(ref, null, this.page, ref_.getId(), "org.eclipse.ui", label);
                Composite parent = (Composite)pane.getControl();
                Composite content = new Composite(parent, 524288);
                content.setLayout((Layout)new FillLayout());
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            ref.creationInProgress = false;
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        ref.creationInProgress = false;
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus busyRestoreViewHelper(ViewReference ref) {
        IStatus partStatus = Status.OK_STATUS;
        if (partStatus.getSeverity() != 0) {
            return partStatus;
        }
        String key = ViewFactory.getKey(ref);
        IMemento stateMem = this.getViewState(key);
        IViewDescriptor desc = this.viewReg.find(ref.getId());
        if (desc == null) {
            return new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.ViewFactory_couldNotCreate, null);
        }
        PartPane pane = ref.getPane();
        pane.createControl(this.page.getClientComposite());
        String label = desc.getLabel();
        Composite content = null;
        IWorkbenchPart initializedView = null;
        PartSite site = null;
        try {
            IConfigurationElement element;
            Object var12_17;
            IViewPart view = null;
            try {
                UIStats.start(0, label);
                view = desc.createView();
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                UIStats.end(0, view, label);
                throw throwable;
            }
            {
                var12_17 = null;
            }
            UIStats.end(0, view, label);
            site = new ViewSite(ref, view, this.page, desc);
            try {
                UIStats.start(2, label);
                view.init((IViewSite)((Object)site), stateMem);
                initializedView = view;
            }
            catch (Throwable throwable) {
                var12_17 = null;
                UIStats.end(2, view, label);
                throw throwable;
            }
            {
                var12_17 = null;
            }
            UIStats.end(2, view, label);
            if (view.getSite() != site) {
                return WorkbenchPlugin.getStatus(WorkbenchMessages.ViewFactory_siteException, null);
            }
            int style = 0;
            if (view instanceof WorkbenchPart) {
                style = ((WorkbenchPart)((Object)view)).getOrientation();
            }
            Composite parent = (Composite)pane.getControl();
            content = new Composite(parent, style | 0x80000);
            content.setLayout((Layout)new FillLayout());
            try {
                UIStats.start(1, label);
                view.createPartControl(content);
                parent.layout(true);
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                UIStats.end(1, view, label);
                throw throwable;
            }
            {
                Object var14_25 = null;
            }
            UIStats.end(1, view, label);
            ref.setPart(view);
            ref.refreshFromPart();
            ref.releaseReferences();
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.core.runtime.IConfigurationElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            if ((element = (IConfigurationElement)desc.getAdapter(clazz)) != null) {
                this.page.getExtensionTracker().registerObject(element.getDeclaringExtension(), (Object)view, 2);
            }
            this.page.addPart(ref);
            this.page.firePartOpened(view);
            return partStatus;
        }
        catch (Exception e) {
            if (content != null) {
                try {
                    content.dispose();
                }
                catch (RuntimeException re) {
                    WorkbenchPlugin.log(re);
                }
            }
            if (initializedView != null) {
                try {
                    initializedView.dispose();
                }
                catch (RuntimeException re) {
                    WorkbenchPlugin.log(re);
                }
            }
            if (site == null) return WorkbenchPlugin.getStatus(e);
            try {
                site.dispose();
                return WorkbenchPlugin.getStatus(e);
            }
            catch (RuntimeException re) {
                WorkbenchPlugin.log(re);
            }
            return WorkbenchPlugin.getStatus(e);
        }
    }

    public IViewReference createView(String id) throws PartInitException {
        return this.createView(id, null);
    }

    public IViewReference createView(String id, String secondaryId) throws PartInitException {
        IViewDescriptor desc = this.viewReg.find(id);
        if (desc == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_couldNotCreate, (Object)id));
        }
        if (secondaryId != null && !desc.getAllowMultiple()) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_noMultiple, (Object)id));
        }
        String key = ViewFactory.getKey(id, secondaryId);
        IViewReference ref = (IViewReference)this.counter.get(key);
        if (ref == null) {
            IMemento memento = (IMemento)this.mementoTable.get(key);
            ref = new ViewReference(id, secondaryId, memento);
            this.counter.put(key, ref);
        } else {
            this.counter.addRef(key);
        }
        return ref;
    }

    private void destroyView(IViewPart view) {
        PartSite site = (PartSite)view.getSite();
        PartPane pane = site.getPane();
        pane.dispose();
        site.dispose();
    }

    public IViewReference getView(String id) {
        return this.getView(id, null);
    }

    public IViewReference getView(String id, String secondaryId) {
        String key = ViewFactory.getKey(id, secondaryId);
        return (IViewReference)this.counter.get(key);
    }

    public IViewRegistry getViewRegistry() {
        return this.viewReg;
    }

    public IViewReference[] getViews() {
        List list = this.counter.values();
        IViewReference[] array = new IViewReference[list.size()];
        list.toArray(array);
        return array;
    }

    public WorkbenchPage getWorkbenchPage() {
        return this.page;
    }

    public boolean hasView(IViewReference viewRef) {
        return this.hasView(viewRef.getId(), viewRef.getSecondaryId());
    }

    public boolean hasView(String id) {
        return this.hasView(id, null);
    }

    public boolean hasView(String id, String secondaryId) {
        return this.getView(id, secondaryId) != null;
    }

    public void releaseView(IViewReference viewRef) {
        IViewPart view;
        String key = ViewFactory.getKey(viewRef);
        IViewReference ref = (IViewReference)this.counter.get(key);
        if (ref == null) {
            return;
        }
        int count = this.counter.removeRef(key);
        if (count <= 0 && (view = (IViewPart)ref.getPart(false)) != null) {
            this.destroyView(view);
        }
    }

    public IStatus restoreState(IMemento memento) {
        IMemento[] mem = memento.getChildren("view");
        int i = 0;
        while (i < mem.length) {
            this.restoreViewState(mem[i]);
            ++i;
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus restoreView(IViewReference ref) {
        IStatus[] result = new IStatus[]{this.busyRestoreView(ref)};
        return result[0];
    }

    public IStatus saveState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.ViewFactory_problemsSavingViews, null);
        IViewReference[] refs = this.getViews();
        int i = 0;
        while (i < refs.length) {
            this.saveViewState(memento, refs[i], result);
            ++i;
        }
        return result;
    }

    public IMemento saveViewState(IMemento memento, IViewReference ref, MultiStatus res) {
        final MultiStatus result = res;
        final IMemento viewMemento = memento.createChild("view");
        viewMemento.putString("id", ViewFactory.getKey(ref));
        if (ref instanceof ViewReference) {
            viewMemento.putString("partName", ((ViewReference)ref).getPartName());
        }
        final IViewReference viewRef = ref;
        final IViewPart view = (IViewPart)ref.getPart(false);
        if (view != null) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    view.saveState(viewMemento.createChild("viewState"));
                }

                public void handleException(Throwable e) {
                    result.add((IStatus)new Status(4, "org.eclipse.ui", 0, NLS.bind((String)WorkbenchMessages.ViewFactory_couldNotSave, (Object)viewRef.getTitle()), e));
                }
            });
        } else {
            IMemento mem = this.getViewState(ViewFactory.getKey(ref));
            if (mem != null) {
                IMemento child = viewMemento.createChild("viewState");
                child.putMemento(mem);
            }
        }
        return viewMemento;
    }

    public void restoreViewState(IMemento memento) {
        String compoundId = memento.getString("id");
        this.mementoTable.put(compoundId, memento);
    }

    private IMemento getViewState(String key) {
        IMemento memento = (IMemento)this.mementoTable.get(key);
        if (memento == null) {
            return null;
        }
        return memento.getChild("viewState");
    }

    public void removeExtension(IExtension source, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IViewPart) {
                IViewPart part = (IViewPart)objects[i];
                this.page.hideView(part);
            }
            ++i;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
    }

    private class ViewReference
    extends WorkbenchPartReference
    implements IViewReference {
        private String secondaryId;
        private boolean create = true;
        private boolean creationInProgress = false;

        public ViewReference(String id, IMemento memento) {
            this(id, null, memento);
        }

        public ViewReference(String id, String secondaryId, IMemento memento) {
            ViewDescriptor desc = (ViewDescriptor)ViewFactory.this.viewReg.find(id);
            ImageDescriptor iDesc = null;
            String title = null;
            if (desc != null) {
                iDesc = desc.getImageDescriptor();
                title = desc.getLabel();
            }
            String name = null;
            if (memento != null) {
                name = memento.getString("partName");
            }
            if (name == null) {
                name = title;
            }
            this.init(id, title, null, iDesc, name, null);
            this.secondaryId = secondaryId;
        }

        protected PartPane createPane() {
            return new ViewPane(this, ViewFactory.this.page);
        }

        public void dispose() {
            super.dispose();
            this.create = false;
        }

        public IWorkbenchPage getPage() {
            return ViewFactory.this.page;
        }

        public IWorkbenchPart getPart(boolean restore) {
            if (this.part != null) {
                return this.part;
            }
            if (!this.create) {
                return null;
            }
            if (restore) {
                ViewFactory.this.restoreView(this);
            }
            return this.part;
        }

        public String getRegisteredName() {
            if (this.part != null && this.part.getSite() != null) {
                return this.part.getSite().getRegisteredName();
            }
            IViewRegistry reg = ViewFactory.this.viewReg;
            IViewDescriptor desc = reg.find(this.getId());
            if (desc != null) {
                return desc.getLabel();
            }
            return this.getTitle();
        }

        protected String computePartName() {
            if (this.part instanceof IWorkbenchPart2) {
                return super.computePartName();
            }
            return this.getRegisteredName();
        }

        protected String computeContentDescription() {
            if (this.part instanceof IWorkbenchPart2) {
                return super.computeContentDescription();
            }
            String rawTitle = this.getRawTitle();
            if (!Util.equals(rawTitle, this.getRegisteredName())) {
                return rawTitle;
            }
            return "";
        }

        public String getSecondaryId() {
            return this.secondaryId;
        }

        public IViewPart getView(boolean restore) {
            return (IViewPart)this.getPart(restore);
        }

        public boolean isFastView() {
            return ViewFactory.this.page.isFastView(this);
        }
    }
}

