/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;

public final class WorkbenchWindowConfigurer
implements IWorkbenchWindowConfigurer {
    private WorkbenchWindow window;
    private int shellStyle = 1264;
    private String windowTitle;
    private boolean showFastViewBars = false;
    private boolean showPerspectiveBar = false;
    private boolean showStatusLine = true;
    private boolean showToolBar = true;
    private boolean showMenuBar = true;
    private boolean showProgressIndicator = false;
    private Map extraData = new HashMap(1);
    private ArrayList transferTypes = new ArrayList(3);
    private Point initialSize = new Point(1024, 768);

    WorkbenchWindowConfigurer(WorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
        if (this.windowTitle == null) {
            this.windowTitle = "";
        }
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public IWorkbenchConfigurer getWorkbenchConfigurer() {
        return Workbench.getInstance().getWorkbenchConfigurer();
    }

    String basicGetTitle() {
        return this.windowTitle;
    }

    public String getTitle() {
        Shell shell = this.window.getShell();
        if (shell != null) {
            this.windowTitle = shell.getText();
            return this.windowTitle;
        }
        return this.windowTitle;
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException();
        }
        this.windowTitle = title;
        Shell shell = this.window.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(title);
        }
    }

    public boolean getShowFastViewBars() {
        return this.showFastViewBars;
    }

    public void setShowFastViewBars(boolean show) {
        this.showFastViewBars = show;
    }

    public boolean getShowPerspectiveBar() {
        return this.showPerspectiveBar;
    }

    public boolean getShowStatusLine() {
        return this.showStatusLine;
    }

    public void setShowStatusLine(boolean show) {
        this.showStatusLine = show;
    }

    public boolean getShowProgressIndicator() {
        return this.showProgressIndicator;
    }

    public void setShowProgressIndicator(boolean show) {
        this.showProgressIndicator = show;
    }

    public Object getData(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.extraData.get(key);
    }

    public void setData(String key, Object data) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (data != null) {
            this.extraData.put(key, data);
        } else {
            this.extraData.remove(key);
        }
    }

    public void addEditorAreaTransfer(Transfer tranfer) {
        if (tranfer != null && !this.transferTypes.contains(tranfer)) {
            this.transferTypes.add(tranfer);
            Transfer[] transfers = new Transfer[this.transferTypes.size()];
            this.transferTypes.toArray(transfers);
            this.window.getPages();
        }
    }

    public void configureEditorAreaDropListener() {
        IWorkbenchPage[] pages = this.window.getPages();
        int i = 0;
        while (i < pages.length) {
            WorkbenchPage cfr_ignored_0 = (WorkbenchPage)pages[i];
            ++i;
        }
    }

    Transfer[] getTransfers() {
        Transfer[] transfers = new Transfer[this.transferTypes.size()];
        this.transferTypes.toArray(transfers);
        return transfers;
    }

    public int getShellStyle() {
        return this.shellStyle;
    }

    public void setShellStyle(int shellStyle) {
        this.shellStyle = shellStyle;
    }

    public Point getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Point size) {
        this.initialSize = size;
    }

    public void createDefaultContents(Shell shell) {
        this.window.createDefaultContents(shell);
    }

    public Control createStatusLineControl(Composite parent) {
        return null;
    }

    public Control createPageComposite(Composite parent) {
        return this.window.createPageComposite(parent);
    }
}

