/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ShowMessage {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int INFORMATION = 2;
    public static final int QUESTION = 3;
    public static final int WARNING = 4;
    public String OK_LABEL = JFaceResources.getString((String)"ok");
    public String CANCEL_LABEL = JFaceResources.getString((String)"cancel");
    private static final String NESTING_INDENT = "  ";
    static String originalMessage;

    public static int openInformation(Shell parent, String title, String message) {
        return ShowMessage.openBox(parent, title, message, 34);
    }

    public static int openError(Shell parent, String title, String message) {
        return ShowMessage.openBox(parent, title, message, 33);
    }

    public static boolean openQuestion(Shell parent, String title, String message) {
        return ShowMessage.openBox(parent, title, message, 193) == 64;
    }

    public static int openWarning(Shell parent, String title, String message) {
        return ShowMessage.openBox(parent, title, message, 40);
    }

    public static int openBox(Shell parent, String title, String message, int style) {
        Shell shell = null;
        if (parent != null) {
            shell = parent;
        } else {
            Display display = new Display();
            shell = new Shell(display);
        }
        MessageBox mb = new MessageBox(shell, style);
        mb.setText(title);
        mb.setMessage(message);
        return mb.open();
    }

    public static void printError(String message, IStatus status) {
        originalMessage = message == null ? status.getMessage() : JFaceResources.format((String)"Reason", (Object[])new Object[]{message, status.getMessage()});
        ShowMessage.printError(status, 0, false);
    }

    public static void printError(IStatus buildingStatus, int nesting, boolean includeStatus) {
        String message;
        StringBuffer sb;
        Throwable t = buildingStatus.getException();
        boolean isCoreException = t instanceof CoreException;
        boolean incrementNesting = false;
        if (includeStatus) {
            sb = new StringBuffer();
            int i = 0;
            while (i < nesting) {
                sb.append(NESTING_INDENT);
                ++i;
            }
            message = buildingStatus.getMessage();
            sb.append(message);
            System.out.println(sb.toString());
            incrementNesting = true;
        }
        if (!isCoreException && t != null) {
            sb = new StringBuffer();
            int i = 0;
            while (i < nesting) {
                sb.append(NESTING_INDENT);
                ++i;
            }
            message = t.getLocalizedMessage();
            if (message == null) {
                message = t.toString();
            }
            sb.append(message);
            System.out.println(sb.toString());
            incrementNesting = true;
        }
        if (incrementNesting) {
            ++nesting;
        }
        if (isCoreException) {
            CoreException ce = (CoreException)t;
            IStatus eStatus = ce.getStatus();
            if (originalMessage == null || originalMessage.indexOf(eStatus.getMessage()) == -1) {
                ShowMessage.printError(eStatus, nesting, true);
            }
        }
        IStatus[] children = buildingStatus.getChildren();
        int i = 0;
        while (i < children.length) {
            ShowMessage.printError(children[i], nesting, true);
            ++i;
        }
    }
}

