/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.DateEditor;
import org.eclipse.ercp.swt.mobile.MultiPageDialog;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBaseEntry;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CalendarEditEntryDialog
implements SelectionListener,
ModifyListener {
    MultiPageDialog dialog;
    Canvas page1;
    RowLayout layout;
    int lastScrollBarSelection = 0;
    Text description;
    Text location;
    Combo timedCombo;
    DateEditor startdate;
    DateEditor enddate;
    DateEditor duration;
    CaptionedControl startdateCT;
    CaptionedControl enddateCT;
    CaptionedControl durationCT;
    Text notes;
    Command commandDelete;
    Command commandDone;
    CalendarDataBaseEntry calendardatabaseentry;
    boolean update = false;
    boolean isNewEntry;
    FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            if (e.widget == CalendarEditEntryDialog.this.description) {
                CalendarEditEntryDialog.this.page1.getVerticalBar().setSelection(CalendarEditEntryDialog.this.page1.getVerticalBar().getMinimum());
                CalendarEditEntryDialog.this.updateCanvas();
            } else if (e.widget == CalendarEditEntryDialog.this.duration) {
                CalendarEditEntryDialog.this.page1.getVerticalBar().setSelection(CalendarEditEntryDialog.this.page1.getVerticalBar().getMaximum());
                CalendarEditEntryDialog.this.updateCanvas();
            } else if (e.widget == CalendarEditEntryDialog.this.location || e.widget == CalendarEditEntryDialog.this.startdate || e.widget == CalendarEditEntryDialog.this.enddate || e.widget == CalendarEditEntryDialog.this.timedCombo) {
                Rectangle rc = ((Control)e.widget).getParent().getBounds();
                Rectangle clientArea = CalendarEditEntryDialog.this.page1.getClientArea();
                int selection = CalendarEditEntryDialog.this.page1.getVerticalBar().getSelection();
                if (rc.y < selection) {
                    CalendarEditEntryDialog.this.page1.getVerticalBar().setSelection(rc.y);
                    CalendarEditEntryDialog.this.updateCanvas();
                } else if (rc.y + rc.height > selection + clientArea.height) {
                    CalendarEditEntryDialog.this.page1.getVerticalBar().setSelection(rc.y);
                    CalendarEditEntryDialog.this.updateCanvas();
                }
            }
        }

        public void focusLost(FocusEvent e) {
        }
    };
    SelectionListener scrollBarListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == CalendarEditEntryDialog.this.page1.getVerticalBar()) {
                CalendarEditEntryDialog.this.updateCanvas();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public CalendarEditEntryDialog(Shell parent) {
        this.dialog = new MultiPageDialog(parent);
    }

    public boolean open(CalendarDataBaseEntry entry, boolean isNewEntry) {
        this.calendardatabaseentry = entry;
        this.isNewEntry = isNewEntry;
        this.update = !isNewEntry;
        this.dialog.setText(Messages.getString("CalendarEditEntryDialog.0"));
        Composite p1 = this.dialog.createPage(Messages.getString("CalendarEditEntryDialog.1"), null);
        this.page1 = new Canvas(p1, 512);
        this.page1.setSize(p1.getClientArea().width, p1.getClientArea().height);
        this.layout = new RowLayout();
        this.layout.type = 512;
        this.layout.wrap = false;
        this.page1.setLayout((Layout)this.layout);
        CaptionedControl descriptionCT = new CaptionedControl((Composite)this.page1, 0x2000000);
        descriptionCT.setText(Messages.getString("CalendarEditEntryDialog.3"));
        this.description = new Text((Composite)descriptionCT, 4);
        this.description.setText(entry.getDescription());
        CaptionedControl locationCT = new CaptionedControl((Composite)this.page1, 0x2000000);
        locationCT.setText(Messages.getString("CalendarEditEntryDialog.4"));
        this.location = new Text((Composite)locationCT, 4);
        this.location.setText(entry.getLocation());
        CaptionedControl timedCT = new CaptionedControl((Composite)this.page1, 0x2000000);
        timedCT.setText(Messages.getString("CalendarEditEntryDialog.5"));
        this.timedCombo = new Combo((Composite)timedCT, 8);
        this.timedCombo.add(Messages.getString("CalendarEditEntryDialog.6"));
        this.timedCombo.add(Messages.getString("CalendarEditEntryDialog.7"));
        this.timedCombo.select(0);
        this.timedCombo.addSelectionListener((SelectionListener)this);
        this.startdateCT = new CaptionedControl((Composite)this.page1, 0x2000000);
        this.startdateCT.setText(Messages.getString("CalendarEditEntryDialog.8"));
        this.startdate = new DateEditor((Composite)this.startdateCT, 0, 34);
        this.startdate.setDate(entry.getStartDate());
        this.startdate.addModifyListener((ModifyListener)this);
        this.enddateCT = new CaptionedControl((Composite)this.page1, 0x2000000);
        this.enddateCT.setText(Messages.getString("CalendarEditEntryDialog.9"));
        this.enddate = new DateEditor((Composite)this.enddateCT, 0, 34);
        this.enddate.setDate(entry.getEndDate());
        this.enddate.addModifyListener((ModifyListener)this);
        this.durationCT = new CaptionedControl((Composite)this.page1, 0x2000000);
        this.durationCT.setText(Messages.getString("CalendarEditEntryDialog.10"));
        this.duration = new DateEditor((Composite)this.durationCT, 0, 36);
        int offset = this.enddate.getTime() - this.startdate.getTime();
        this.duration.setTime(offset);
        this.duration.addModifyListener((ModifyListener)this);
        this.description.addFocusListener(this.focusListener);
        this.location.addFocusListener(this.focusListener);
        this.timedCombo.addFocusListener(this.focusListener);
        this.startdate.addFocusListener(this.focusListener);
        this.enddate.addFocusListener(this.focusListener);
        this.duration.addFocusListener(this.focusListener);
        this.commandDelete = new Command((Control)p1.getShell(), 1, 2);
        this.commandDelete.setText(Messages.getString("CalendarEditEntryDialog.11"));
        this.commandDelete.addSelectionListener((SelectionListener)this);
        this.commandDone = new Command((Control)p1.getShell(), 7, 0);
        this.commandDone.setText(Messages.getString("CalendarEditEntryDialog.12"));
        this.commandDone.addSelectionListener((SelectionListener)this);
        this.page1.layout();
        Rectangle containerArea = this.getChildrenBounds((Composite)this.page1);
        Rectangle clientArea = this.page1.getClientArea();
        this.page1.getVerticalBar().setMaximum(containerArea.height);
        this.page1.getVerticalBar().setMinimum(0);
        this.page1.getVerticalBar().setThumb(containerArea.height / 3);
        this.page1.getVerticalBar().setPageIncrement(clientArea.height / 5);
        this.page1.getVerticalBar().setIncrement(clientArea.height / 10);
        this.page1.getVerticalBar().addSelectionListener(this.scrollBarListener);
        Composite p2 = this.dialog.createPage(Messages.getString("CalendarEditEntryDialog.13"), null);
        this.notes = new Text(p2, 2112);
        this.notes.setSize(p2.getClientArea().width, p2.getClientArea().height);
        this.notes.setText(entry.getNotes() != null ? entry.getNotes() : "");
        this.dialog.setSelection(0);
        this.dialog.open();
        return this.update;
    }

    private Rectangle getChildrenBounds(Composite parent) {
        Rectangle containerArea = null;
        Control[] childrenControls = this.page1.getChildren();
        int i = 0;
        while (i < childrenControls.length) {
            if (containerArea == null) {
                containerArea = new Rectangle(childrenControls[i].getBounds().x, childrenControls[i].getBounds().y, childrenControls[i].getBounds().width, childrenControls[i].getBounds().height);
            } else {
                containerArea.add(childrenControls[i].getBounds());
            }
            ++i;
        }
        containerArea.y -= this.layout.marginTop;
        containerArea.height += this.layout.marginTop + this.layout.marginBottom;
        return containerArea;
    }

    private void updateCanvas() {
        int selection = this.page1.getVerticalBar().getSelection();
        Rectangle containerArea = this.getChildrenBounds((Composite)this.page1);
        this.page1.scroll(containerArea.x, containerArea.y + (this.lastScrollBarSelection - selection), containerArea.x, containerArea.y, containerArea.width, containerArea.height, true);
        this.lastScrollBarSelection = selection;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.commandDelete) {
            String s = this.isNewEntry ? Messages.getString("CalendarEditEntryDialog.16") : Messages.getString("CalendarEditEntryDialog.17");
            MessageBox box = new MessageBox(this.dialog.getParent(), 292);
            box.setMessage(s);
            if (box.open() == 32) {
                this.update = false;
                this.quit();
            }
        } else if (e.widget == this.commandDone) {
            this.update = true;
            this.updateEntry();
            this.quit();
        } else if (e.widget == this.timedCombo) {
            if (this.timedCombo.getSelectionIndex() == 0) {
                this.startdateCT.setEnabled(true);
                this.enddateCT.setEnabled(true);
                this.durationCT.setEnabled(true);
            } else {
                this.startdateCT.setEnabled(false);
                this.enddateCT.setEnabled(false);
                this.durationCT.setEnabled(false);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void quit() {
        this.commandDelete.dispose();
        this.commandDone.dispose();
        this.dialog.close();
    }

    private void updateEntry() {
        this.calendardatabaseentry.setDescription(this.description.getText());
        this.calendardatabaseentry.setLocation(this.location.getText());
        this.calendardatabaseentry.setStartDate(this.startdate.getDate());
        this.calendardatabaseentry.setEndDate(this.enddate.getDate());
        this.calendardatabaseentry.setNotes(this.notes.getText());
    }

    public void modifyText(ModifyEvent arg0) {
        if (arg0.widget == this.startdate) {
            int time;
            int start = this.startdate.getTime();
            if (start + (time = this.duration.getTime()) < 86400) {
                this.enddate.setTime(start + time);
            } else {
                this.enddate.setTime(86399);
                this.duration.setTime(86399 - start);
            }
        } else if (arg0.widget == this.enddate) {
            int start = this.startdate.getTime();
            int end = this.enddate.getTime();
            int time = this.duration.getTime();
            if (end >= start) {
                this.duration.setTime(end - start);
            } else {
                start = end - time;
                if (start >= 0) {
                    this.startdate.setTime(start);
                } else {
                    this.startdate.setTime(0);
                    this.duration.setTime(end);
                }
            }
        } else if (arg0.widget == this.duration) {
            int start = this.startdate.getTime();
            int end = this.enddate.getTime();
            int time = this.duration.getTime();
            end = start + time;
            if (end < 86400) {
                this.enddate.setTime(end);
            } else {
                this.enddate.setTime(86399);
                this.duration.setTime(86399 - start);
            }
        }
    }
}

