/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Label;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class LabelShowCaseAnimatedGif {
    final ImageLoader loader = new ImageLoader();
    final Display display;
    private Runnable runnable;
    private Label label;
    private Image frameImage;
    int imageNumber = 0;

    public LabelShowCaseAnimatedGif(Composite parent, String filename) {
        this.label = new Label(parent, 0);
        this.loader.load(this.getClass().getResourceAsStream(filename));
        this.frameImage = new Image((Device)parent.getDisplay(), this.loader.data[0]);
        this.label.setImage(this.frameImage);
        this.label.setSize(this.frameImage.getBounds().width, this.frameImage.getBounds().height);
        this.display = parent.getDisplay();
        if (this.loader.data.length <= 1) {
            return;
        }
        this.runnable = new Runnable(){

            public void run() {
                if (LabelShowCaseAnimatedGif.this.runnable != null) {
                    if (LabelShowCaseAnimatedGif.this.label.isDisposed()) {
                        return;
                    }
                    Image oldImage = LabelShowCaseAnimatedGif.this.label.getImage();
                    LabelShowCaseAnimatedGif.this.imageNumber = LabelShowCaseAnimatedGif.this.imageNumber == LabelShowCaseAnimatedGif.this.loader.data.length - 1 ? 0 : LabelShowCaseAnimatedGif.this.imageNumber + 1;
                    ImageData nextFrameData = LabelShowCaseAnimatedGif.this.loader.data[LabelShowCaseAnimatedGif.this.imageNumber];
                    LabelShowCaseAnimatedGif.this.frameImage = new Image((Device)LabelShowCaseAnimatedGif.this.display, nextFrameData);
                    LabelShowCaseAnimatedGif.this.label.setImage(LabelShowCaseAnimatedGif.this.frameImage);
                    oldImage.dispose();
                    if (LabelShowCaseAnimatedGif.this.runnable != null) {
                        int delayTime = LabelShowCaseAnimatedGif.this.loader.data[LabelShowCaseAnimatedGif.this.imageNumber].delayTime;
                        LabelShowCaseAnimatedGif.this.display.timerExec(delayTime * 10, (Runnable)this);
                    } else {
                        LabelShowCaseAnimatedGif.this.frameImage.dispose();
                    }
                } else {
                    LabelShowCaseAnimatedGif.this.frameImage.dispose();
                }
            }
        };
    }

    Label getLabel() {
        return this.label;
    }

    public void run() {
        int delayTime = this.loader.data[this.imageNumber].delayTime;
        if (this.runnable != null) {
            this.display.timerExec(delayTime * 10, this.runnable);
        }
    }

    public void stop() {
        this.runnable = null;
        this.label.dispose();
    }
}

