/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;

public class InstallLogParser {
    private IPath logPath;
    private BufferedReader buffRead;
    private InstallConfiguration currentConfiguration;
    private HashMap installConfigMap;
    private Comparator comparator;
    private static final String FEATURE_INSTALL = "feature-install";
    private static final String FEATURE_REMOVE = "feature-remove";
    private static final String SITE_INSTALL = "site-install";
    private static final String SITE_REMOVE = "site-remove";
    private static final String UNCONFIGURE = "feature-disable";
    private static final String CONFIGURE = "feature-enable";
    private static final String REVERT = "revert";
    private static final String RECONCILIATION = "reconciliation";
    private static final String PRESERVED = "preserve-configuration";
    private static final String ACTIVITY = "!ACTIVITY";
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";

    public InstallLogParser() {
        String string = ConfiguratorUtils.getCurrentPlatformConfiguration().getConfigurationLocation().getFile();
        this.logPath = new Path(string).removeLastSegments(1).append("install.log");
        this.installConfigMap = new HashMap();
        try {
            InstallConfiguration[] installConfigurationArray = (InstallConfiguration[])SiteManager.getLocalSite().getConfigurationHistory();
            int n = 0;
            while (n < installConfigurationArray.length) {
                if (!installConfigurationArray[n].isCurrent()) {
                    this.installConfigMap.put(new Long(installConfigurationArray[n].getCreationDate().getTime()), installConfigurationArray[n]);
                }
                ++n;
            }
            InstallConfiguration installConfiguration = this.getConfigCopy((InstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration());
            this.installConfigMap.put(new Long(installConfiguration.getCreationDate().getTime()), installConfiguration);
        }
        catch (CoreException coreException) {
            UpdateCore.log(coreException);
        }
        catch (MalformedURLException malformedURLException) {
            UpdateCore.log(malformedURLException);
        }
        this.comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                Date date;
                Date date2 = ((InstallConfiguration)object).getCreationDate();
                return date2.before(date = ((InstallConfiguration)object2).getCreationDate()) ? 1 : -1;
            }
        };
    }

    private InstallConfiguration getConfigCopy(InstallConfiguration installConfiguration) throws CoreException, MalformedURLException {
        InstallConfiguration installConfiguration2 = new InstallConfiguration(installConfiguration, installConfiguration.getURL(), installConfiguration.getLabel());
        installConfiguration2.setCreationDate(installConfiguration.getCreationDate());
        return installConfiguration2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseInstallationLog() {
        try {
            try {
                this.openLog();
                this.parseLog();
            }
            catch (CoreException coreException) {
                UpdateUtils.logException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.closeLog();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.closeLog();
            return;
        }
    }

    private void openLog() throws CoreException {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.logPath.toOSString());
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            this.buffRead = new BufferedReader(inputStreamReader);
        }
        catch (Exception exception) {
            this.throwCoreException(exception);
        }
    }

    private void throwCoreException(Throwable throwable) throws CoreException {
        throw new CoreException((IStatus)new Status(4, UpdateUtils.getPluginId(), 4, Messages.InstallLogParser_errors, throwable));
    }

    private void parseLog() throws CoreException {
        try {
            while (this.buffRead.ready()) {
                CharSequence charSequence;
                String string;
                StringTokenizer stringTokenizer = new StringTokenizer(this.buffRead.readLine());
                while (!stringTokenizer.hasMoreElements()) {
                    if (!this.buffRead.ready()) {
                        return;
                    }
                    stringTokenizer = new StringTokenizer(this.buffRead.readLine());
                }
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equals(ACTIVITY)) {
                    string = stringTokenizer.nextToken();
                    StringBuffer stringBuffer = new StringBuffer();
                    charSequence = stringTokenizer.nextToken(".");
                    stringTokenizer.nextToken(" ");
                    while (stringTokenizer.countTokens() > 2) {
                        stringBuffer.append(" ");
                        stringBuffer.append(stringTokenizer.nextToken());
                    }
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    this.createActivity(string3, string, (String)charSequence, string4, stringBuffer.toString(), this.currentConfiguration);
                    continue;
                }
                string = stringTokenizer.nextToken();
                charSequence = new StringBuffer();
                while (stringTokenizer.countTokens() > 0) {
                    if (((StringBuffer)charSequence).length() != 0) {
                        ((StringBuffer)charSequence).append(" ");
                    }
                    ((StringBuffer)charSequence).append(stringTokenizer.nextToken());
                }
                this.currentConfiguration = (InstallConfiguration)this.installConfigMap.get(new Long(string));
            }
        }
        catch (Exception exception) {
            this.throwCoreException(exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeLog() {
        try {
            try {
                if (this.buffRead != null) {
                    this.buffRead.close();
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.buffRead = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.buffRead = null;
            return;
        }
    }

    private IActivity createActivity(String string, String string2, String string3, String string4, String string5, InstallConfiguration installConfiguration) {
        ConfigurationActivity configurationActivity = new ConfigurationActivity();
        int n = 0;
        if (FEATURE_INSTALL.equals(string)) {
            n = 1;
        } else if (FEATURE_REMOVE.equals(string)) {
            n = 2;
        } else if (SITE_INSTALL.equals(string)) {
            n = 3;
        } else if (SITE_REMOVE.equals(string)) {
            n = 4;
        } else if (UNCONFIGURE.equals(string)) {
            n = 5;
        } else if (CONFIGURE.equals(string)) {
            n = 6;
        } else if (REVERT.equals(string)) {
            n = 7;
        } else if (RECONCILIATION.equals(string)) {
            n = 8;
        } else if (PRESERVED.equals(string)) {
            n = 9;
        }
        configurationActivity.setAction(n);
        try {
            long l = Long.parseLong(string2);
            configurationActivity.setDate(new Date(l));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                configurationActivity.setDate(new SimpleDateFormat().parse(string3));
            }
            catch (ParseException parseException) {}
        }
        configurationActivity.setStatus(SUCCESS.equals(string4) ? 0 : 1);
        configurationActivity.setLabel(string5);
        configurationActivity.setInstallConfigurationModel(installConfiguration);
        if (installConfiguration != null && !this.configContainsActivity(installConfiguration, configurationActivity)) {
            installConfiguration.addActivity(configurationActivity);
        }
        return configurationActivity;
    }

    private boolean configContainsActivity(InstallConfiguration installConfiguration, IActivity iActivity) {
        IActivity[] iActivityArray = installConfiguration.getActivities();
        int n = 0;
        while (n < iActivityArray.length) {
            if (iActivity.equals(iActivityArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public InstallConfiguration[] getConfigurations() {
        Collection collection = this.installConfigMap.values();
        InstallConfiguration[] installConfigurationArray = collection.toArray(new InstallConfiguration[collection.size()]);
        Arrays.sort(installConfigurationArray, this.comparator);
        return installConfigurationArray;
    }
}

