/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.update.internal.configurator.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPrintHandler {
    public static final String XML_COMMENT_END_TAG = "-->";
    public static final String XML_COMMENT_BEGIN_TAG = "<!--";
    public static final String XML_HEAD = "<?xml version=\"1.0\" encoding=\"";
    public static final String XML_HEAD_END_TAG = "?>";
    public static final String XML_DBL_QUOTES = "\"";
    public static final String XML_SPACE = " ";
    public static final String XML_BEGIN_TAG = "<";
    public static final String XML_END_TAG = ">";
    public static final String XML_EQUAL = "=";
    public static final String XML_SLASH = "/";

    public static void printBeginElement(Writer writer, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(XML_BEGIN_TAG);
        stringBuffer.append(string).append(XML_END_TAG).append("\n");
        writer.write(stringBuffer.toString());
    }

    public static void printEndElement(Writer writer, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(XML_BEGIN_TAG);
        stringBuffer.append(XML_SLASH).append(string).append(XML_END_TAG).append("\n");
        writer.write(stringBuffer.toString());
    }

    public static void printText(Writer writer, String string) throws IOException {
        writer.write(XMLPrintHandler.encode(string).toString());
    }

    public static void printComment(Writer writer, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(XML_COMMENT_BEGIN_TAG);
        stringBuffer.append(XMLPrintHandler.encode(string).toString()).append(XML_COMMENT_END_TAG).append("\n");
        writer.write(stringBuffer.toString());
    }

    public static void printHead(Writer writer, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(XML_HEAD);
        stringBuffer.append(string).append(XML_DBL_QUOTES).append(XML_HEAD_END_TAG).append("\n");
        writer.write(stringBuffer.toString());
    }

    public static String wrapAttributeForPrint(String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(XML_SPACE);
        stringBuffer.append(string).append(XML_EQUAL).append(XML_DBL_QUOTES).append(XMLPrintHandler.encode(string2).toString()).append(XML_DBL_QUOTES);
        return stringBuffer.toString();
    }

    public static void printNode(Writer writer, Node node, String string) throws Exception {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                XMLPrintHandler.printHead(writer, string);
                XMLPrintHandler.printNode(writer, ((Document)node).getDocumentElement(), string);
                break;
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    int n = 0;
                    while (n < namedNodeMap.getLength()) {
                        Node node2 = namedNodeMap.item(n);
                        stringBuffer.append(XMLPrintHandler.wrapAttributeForPrint(node2.getNodeName(), node2.getNodeValue()));
                        ++n;
                    }
                }
                XMLPrintHandler.printBeginElement(writer, stringBuffer.toString());
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    int n = nodeList.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        XMLPrintHandler.printNode(writer, nodeList.item(n2), string);
                        ++n2;
                    }
                }
                XMLPrintHandler.printEndElement(writer, node.getNodeName());
                break;
            }
            case 3: {
                writer.write(XMLPrintHandler.encode(node.getNodeValue()).toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException(Messages.XMLPrintHandler_unsupportedNodeType);
            }
        }
    }

    public static StringBuffer encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer;
    }
}

