/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PerformanceStatsProcessor;
import org.eclipse.core.runtime.Platform;

public class PerformanceStats {
    private static final PerformanceStats EMPTY_STATS = new PerformanceStats("", "");
    public static final boolean ENABLED;
    private static final long NOT_STARTED = -1L;
    private static final Map statMap;
    private static final Map thresholdMap;
    private static final boolean TRACE_SUCCESS;
    private String blame;
    private String blamePluginId;
    private String context;
    private long currentStart = -1L;
    private String event;
    private boolean isFailure;
    private int runCount = 0;
    private long runningTime = 0L;

    static {
        statMap = Collections.synchronizedMap(new HashMap());
        thresholdMap = Collections.synchronizedMap(new HashMap());
        ENABLED = InternalPlatform.getDefault().getBooleanOption("org.eclipse.core.runtime/perf", false);
        TRACE_SUCCESS = InternalPlatform.getDefault().getBooleanOption("org.eclipse.core.runtime/perf/success", ENABLED);
    }

    public static void addListener(PerformanceListener performanceListener) {
        if (ENABLED) {
            PerformanceStatsProcessor.addListener(performanceListener);
        }
    }

    public static void clear() {
        statMap.clear();
    }

    public static PerformanceStats[] getAllStats() {
        return statMap.values().toArray(new PerformanceStats[statMap.values().size()]);
    }

    public static PerformanceStats getStats(String string, Object object) {
        if (!ENABLED || string == null || object == null) {
            return EMPTY_STATS;
        }
        PerformanceStats performanceStats = new PerformanceStats(string, object);
        if (!TRACE_SUCCESS) {
            return performanceStats;
        }
        PerformanceStats performanceStats2 = (PerformanceStats)statMap.get(performanceStats);
        if (performanceStats2 != null) {
            return performanceStats2;
        }
        statMap.put(performanceStats, performanceStats);
        return performanceStats;
    }

    public static boolean isEnabled(String string) {
        if (!ENABLED) {
            return false;
        }
        String string2 = Platform.getDebugOption(string);
        return string2 != null && !string2.equalsIgnoreCase("false") && !string2.equalsIgnoreCase("-1");
    }

    public static void printStats() {
        if (!ENABLED) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(System.out);
        PerformanceStatsProcessor.printStats(printWriter);
        printWriter.flush();
        printWriter.close();
    }

    public static void printStats(PrintWriter printWriter) {
        if (!ENABLED) {
            return;
        }
        PerformanceStatsProcessor.printStats(printWriter);
    }

    public static void removeListener(PerformanceListener performanceListener) {
        if (ENABLED) {
            PerformanceStatsProcessor.removeListener(performanceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStats(String string, Object object) {
        Map map = statMap;
        synchronized (map) {
            Iterator iterator = statMap.keySet().iterator();
            while (iterator.hasNext()) {
                PerformanceStats performanceStats = (PerformanceStats)iterator.next();
                if (!performanceStats.getEvent().equals(string) || !performanceStats.getBlame().equals(object)) continue;
                iterator.remove();
            }
        }
    }

    private PerformanceStats(String string, Object object) {
        this(string, object, null);
    }

    private PerformanceStats(String string, Object object, String string2) {
        this.event = string;
        this.blame = object instanceof String ? (String)object : object.getClass().getName();
        this.blamePluginId = InternalPlatform.getDefault().getBundleId(object);
        this.context = string2;
    }

    public void addRun(long l, String string) {
        if (!ENABLED) {
            return;
        }
        ++this.runCount;
        this.runningTime += l;
        if (l > this.getThreshold(this.event)) {
            PerformanceStatsProcessor.failed(this.createFailureStats(string, l), this.blamePluginId, l);
        }
        if (TRACE_SUCCESS) {
            PerformanceStatsProcessor.changed(this);
        }
    }

    private PerformanceStats createFailureStats(String string, long l) {
        PerformanceStats performanceStats = new PerformanceStats(this.event, this.blame, string);
        PerformanceStats performanceStats2 = (PerformanceStats)statMap.get(performanceStats);
        if (performanceStats2 == null) {
            statMap.put(performanceStats, performanceStats);
        } else {
            performanceStats = performanceStats2;
        }
        performanceStats.isFailure = true;
        ++performanceStats.runCount;
        performanceStats.runningTime += l;
        return performanceStats;
    }

    public void endRun() {
        if (!ENABLED || this.currentStart == -1L) {
            return;
        }
        this.addRun(System.currentTimeMillis() - this.currentStart, this.context);
        this.currentStart = -1L;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PerformanceStats)) {
            return false;
        }
        PerformanceStats performanceStats = (PerformanceStats)object;
        if (!this.event.equals(performanceStats.event)) {
            return false;
        }
        if (!this.getBlameString().equals(performanceStats.getBlameString())) {
            return false;
        }
        return this.context == null ? performanceStats.context == null : this.context.equals(performanceStats.context);
    }

    public Object getBlame() {
        return this.blame;
    }

    public String getBlameString() {
        return this.blame;
    }

    public String getContext() {
        return this.context;
    }

    public String getEvent() {
        return this.event;
    }

    public int getRunCount() {
        return this.runCount;
    }

    public long getRunningTime() {
        return this.runningTime;
    }

    private long getThreshold(String string) {
        Long l = (Long)thresholdMap.get(string);
        if (l == null) {
            String string2 = InternalPlatform.getDefault().getOption(string);
            if (string2 != null) {
                try {
                    l = new Long(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (l == null) {
                l = new Long(Long.MAX_VALUE);
            }
            thresholdMap.put(string, l);
        }
        return l;
    }

    public int hashCode() {
        int n = this.event.hashCode() * 37 + this.getBlameString().hashCode();
        if (this.context != null) {
            n = n * 37 + this.context.hashCode();
        }
        return n;
    }

    public boolean isFailure() {
        return this.isFailure;
    }

    public void reset() {
        this.runningTime = 0L;
        this.runCount = 0;
    }

    public void startRun() {
        if (ENABLED) {
            this.startRun(null);
        }
    }

    public void startRun(String string) {
        if (!ENABLED) {
            return;
        }
        this.context = string;
        this.currentStart = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("PerformanceStats(");
        stringBuffer.append(this.event);
        stringBuffer.append(',');
        stringBuffer.append(this.blame);
        if (this.context != null) {
            stringBuffer.append(',');
            stringBuffer.append(this.context);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static abstract class PerformanceListener {
        protected PerformanceListener() {
        }

        public void eventFailed(PerformanceStats performanceStats, long l) {
        }

        public void eventsOccurred(PerformanceStats[] performanceStatsArray) {
        }
    }
}

