/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.dom;

import org.eclipse.ercp.xml.dom.DocumentImpl;
import org.eclipse.ercp.xml.dom.ElementImpl;
import org.eclipse.ercp.xml.dom.NSNodeImpl;
import org.eclipse.ercp.xml.dom.NodeImpl;
import org.eclipse.ercp.xml.dom.NodeListImpl;
import org.eclipse.ercp.xml.parser.EXmlMsg;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class TreeNode
extends NSNodeImpl {
    protected TreeNode nextSibling = null;
    protected TreeNode previousSibling = null;
    protected TreeNode parentNode = null;
    protected TreeNode firstChild = null;
    protected TreeNode lastChild = null;
    protected int length = 0;

    public TreeNode(DocumentImpl documentImpl) {
        super(documentImpl);
    }

    public TreeNode(DocumentImpl documentImpl, String string) {
        super(documentImpl, string);
    }

    public TreeNode(DocumentImpl documentImpl, String string, String string2) {
        super(documentImpl, string, string2);
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        block9: {
            try {
                if (node != null) break block9;
                return null;
            }
            catch (ClassCastException classCastException) {
                throw new DOMException(3, EXmlMsg.getDefault().getString(59));
            }
        }
        this.checkHierarchy(node);
        this.checkOwnerDocument(node);
        TreeNode treeNode = (TreeNode)node;
        if (node2 == null) {
            if (this.firstChild == null) {
                this.firstChild = this.lastChild = treeNode;
            } else {
                this.lastChild.nextSibling = treeNode;
                treeNode.previousSibling = this.lastChild;
                this.lastChild = treeNode;
            }
            treeNode.parentNode = this;
        } else {
            if (node2.getParentNode() != this) {
                throw new DOMException(8, EXmlMsg.getDefault().getString(32));
            }
            TreeNode treeNode2 = (TreeNode)node2;
            treeNode.previousSibling = treeNode2.previousSibling;
            treeNode.nextSibling = treeNode2;
            treeNode2.previousSibling = treeNode;
            treeNode.parentNode = this;
            if (this.firstChild == treeNode2) {
                this.firstChild = treeNode;
            }
        }
        ++this.length;
        return node;
    }

    public Node removeChild(Node node) throws DOMException {
        TreeNode treeNode = (TreeNode)node;
        if (treeNode.previousSibling != null) {
            treeNode.previousSibling.nextSibling = treeNode.nextSibling;
        }
        if (treeNode.nextSibling != null) {
            treeNode.nextSibling.previousSibling = treeNode.previousSibling;
        }
        if (treeNode.parentNode.firstChild == node) {
            treeNode.parentNode.firstChild = treeNode.nextSibling;
        }
        if (treeNode.parentNode.lastChild == node) {
            treeNode.parentNode.lastChild = treeNode.previousSibling;
        }
        --this.length;
        return node;
    }

    public Node appendChild(Node node) throws DOMException {
        return this.insertBefore(node, null);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.insertBefore(node, node2);
        this.removeChild(node2);
        return node2;
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public boolean hasChildNodes() {
        return this.firstChild != null;
    }

    public int getLength() {
        return this.length;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public Node item(int n) {
        TreeNode treeNode = this.firstChild;
        int n2 = 0;
        while (n2 < n && treeNode != null) {
            treeNode = treeNode.nextSibling;
            ++n2;
        }
        return treeNode;
    }

    public NodeList getElementsByTagName(String string) {
        NodeListImpl nodeListImpl = new NodeListImpl();
        this.getElementByTagName(string, nodeListImpl);
        return nodeListImpl;
    }

    protected void getElementByTagName(String string, NodeListImpl nodeListImpl) {
        TreeNode treeNode = this.firstChild;
        while (treeNode != null) {
            if (treeNode.getNodeType() == 1) {
                ((ElementImpl)treeNode).getElementByTagName(string, nodeListImpl);
            }
            treeNode = treeNode.nextSibling;
        }
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        NodeListImpl nodeListImpl = new NodeListImpl();
        this.getElementsByTagNameNS(string, string2, nodeListImpl);
        return nodeListImpl;
    }

    void getElementsByTagNameNS(String string, String string2, NodeListImpl nodeListImpl) {
        TreeNode treeNode = this.firstChild;
        while (treeNode != null) {
            if (treeNode.getNodeType() == 1) {
                ((ElementImpl)treeNode).getElementsByTagNameNS(string, string2, nodeListImpl);
            }
            treeNode = treeNode.nextSibling;
        }
    }

    public void normalize() {
        Node node = this.getFirstChild();
        Text text = null;
        while (node != null) {
            Node node2 = node.getNextSibling();
            switch (node.getNodeType()) {
                case 3: {
                    if (node.getNodeValue().length() == 0) {
                        this.removeChild(node);
                        break;
                    }
                    if (text == null) {
                        text = (Text)node;
                        break;
                    }
                    text.appendData(node.getNodeValue());
                    this.removeChild(node);
                    break;
                }
                case 1: {
                    node.normalize();
                    break;
                }
            }
            node = node2;
        }
    }

    private void checkOwnerDocument(Node node) throws DOMException {
        Document document = node.getOwnerDocument();
        Document document2 = this.getOwnerDocument();
        if (document2 == null && this instanceof DocumentImpl) {
            document2 = (DocumentImpl)this;
        }
        if (document == null) {
            ((NodeImpl)node).setOwnerDocument((DocumentImpl)document2);
            return;
        }
        if (document != document2) {
            throw new DOMException(4, EXmlMsg.getDefault().getString(30));
        }
    }

    private void checkHierarchy(Node node) {
        if (!(node instanceof TreeNode)) {
            throw new DOMException(3, EXmlMsg.getDefault().getString(59));
        }
        Node node2 = this;
        while (node2 != null) {
            if (node2 == node) {
                throw new DOMException(3, EXmlMsg.getDefault().getString(59));
            }
            node2 = node2.getParentNode();
        }
    }
}

