/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.ercp.swt.mobile.SortedList;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;

public class PropertiesScreen
extends AbsScreen {
    private Composite namePane;
    private Label featureName;
    private SortedList menuList;
    private Text propertiesArea;
    IFeature selectedFeature;
    StringBuffer generalContent = null;
    StringBuffer pluginsContent = null;
    StringBuffer requiredByContent = null;

    public PropertiesScreen(NormalView normalView) {
        super(normalView);
    }

    public void createScreen() {
        this.init(null);
        this.namePane = new Composite(this.screen, 0);
        this.namePane.setLayoutData((Object)new GridData(768));
        this.namePane.setLayout((Layout)new RowLayout(256));
        new Label(this.namePane, 0).setText(UIMessages.PropertiesOf);
        this.featureName = new Label(this.namePane, 0);
        if (this.view.parent.getClientArea().width > this.view.parent.getClientArea().height) {
            Composite composite = new Composite(this.screen, 0);
            composite.setLayout((Layout)new FormLayout());
            composite.setLayoutData((Object)new GridData(1808));
            FormData formData = new FormData();
            FormData formData2 = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(50, -2);
            formData2.top = new FormAttachment(0, 0);
            formData2.bottom = new FormAttachment(100, 0);
            formData2.left = new FormAttachment(50, 2);
            formData2.right = new FormAttachment(100, 0);
            this.menuList = new SortedList(composite, 512);
            this.menuList.setLayoutData((Object)formData);
            this.menuList.addSelectionListener((SelectionListener)this);
            this.menuList.add(UIMessages.Copyright);
            this.menuList.add(UIMessages.GeneralInfo);
            this.menuList.add(UIMessages.License);
            this.menuList.add(UIMessages.Status);
            this.menuList.add(UIMessages.IncludedPlugins);
            this.menuList.add(UIMessages.RequiredBy);
            this.propertiesArea = new Text(composite, 2626);
            this.propertiesArea.setLayoutData((Object)formData2);
            this.propertiesArea.setEditable(false);
            this.separator();
            this.setButtons(1, 0, 0);
            this.screen.layout();
        } else {
            this.menuList = new SortedList(this.screen, 512);
            this.menuList.setLayoutData((Object)new GridData(768));
            this.menuList.addSelectionListener((SelectionListener)this);
            this.menuList.add(UIMessages.Copyright);
            this.menuList.add(UIMessages.GeneralInfo);
            this.menuList.add(UIMessages.License);
            this.menuList.add(UIMessages.Status);
            this.separator();
            this.propertiesArea = new Text(this.screen, 2626);
            this.propertiesArea.setLayoutData((Object)new GridData(1808));
            this.propertiesArea.setEditable(false);
            this.separator();
            this.setButtons(1, 0, 0);
            this.screen.layout();
            this.menuList.add(UIMessages.IncludedPlugins);
            this.menuList.add(UIMessages.RequiredBy);
        }
    }

    protected void refresh() {
        this.selectedFeature = (IFeature)this.view.availableFeatures.elementAt(0);
        this.generalContent = null;
        this.pluginsContent = null;
        this.requiredByContent = null;
        this.featureName.setText(this.selectedFeature.getLabel());
        this.namePane.layout();
        this.menuList.setSelection(new String[]{UIMessages.Copyright});
        this.showCopyright();
    }

    protected void action() {
        this.setDefaultFocus();
        this.screen.pack();
    }

    protected void setDefaultFocus() {
        this.menuList.setFocus();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.menuList) {
            String[] stringArray = this.menuList.getSelection();
            if (UIMessages.Copyright.equals(stringArray[0])) {
                this.showCopyright();
            } else if (UIMessages.GeneralInfo.equals(stringArray[0])) {
                this.showGeneralInfo();
            } else if (UIMessages.License.equals(stringArray[0])) {
                this.showLicense();
            } else if (UIMessages.Status.equals(stringArray[0])) {
                this.showStatus();
            } else if (UIMessages.IncludedPlugins.equals(stringArray[0])) {
                this.showIncludingPlugins();
            } else if (UIMessages.RequiredBy.equals(stringArray[0])) {
                this.showRequiredBy();
            }
        }
        if (selectionEvent.widget == this.backButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(10, false);
        }
    }

    private void showCopyright() {
        IURLEntry iURLEntry = this.selectedFeature.getCopyright();
        if (iURLEntry != null) {
            this.propertiesArea.setText(iURLEntry.getAnnotation());
        } else {
            this.propertiesArea.setText("");
        }
    }

    private void showGeneralInfo() {
        if (this.generalContent != null) {
            this.propertiesArea.setText(this.generalContent.toString());
            return;
        }
        this.generalContent = new StringBuffer();
        this.generalContent.append(UIMessages.Name).append(this.selectedFeature.getLabel()).append("\n");
        VersionedIdentifier versionedIdentifier = this.selectedFeature.getVersionedIdentifier();
        if (versionedIdentifier != null) {
            this.generalContent.append(String.valueOf(UIMessages.Identifier) + versionedIdentifier.getIdentifier()).append("\n");
            this.generalContent.append(UIMessages.Version).append(versionedIdentifier.getVersion()).append("\n");
        } else {
            this.generalContent.append(UIMessages.Identifier).append("\n");
            this.generalContent.append(UIMessages.Version).append("\n");
        }
        this.generalContent.append(UIMessages.Provider).append(this.selectedFeature.getProvider()).append("\n");
        this.generalContent.append(UIMessages.Size).append(this.selectedFeature.getInstallSize()).append("\n");
        this.generalContent.append("\n");
        this.generalContent.append(UIMessages.SupportedPlatforms).append("\n");
        this.generalContent.append("   ").append(UIMessages.OperatingSystem).append(this.selectedFeature.getOS() != null ? this.selectedFeature.getOS() : "").append("\n");
        this.generalContent.append("   ").append(UIMessages.CPUArchitecture).append(this.selectedFeature.getOSArch() != null ? this.selectedFeature.getOSArch() : "").append("\n");
        this.generalContent.append("   ").append(UIMessages.WindowingSystem).append(this.selectedFeature.getWS() != null ? this.selectedFeature.getWS() : "").append("\n");
        this.generalContent.append("   ").append(UIMessages.Languages).append(this.selectedFeature.getNL() != null ? this.selectedFeature.getNL() : "").append("\n");
        this.generalContent.append("\n");
        this.generalContent.append(UIMessages.Description).append("\n");
        IURLEntry iURLEntry = this.selectedFeature.getDescription();
        if (iURLEntry != null) {
            this.generalContent.append("   ").append(iURLEntry.getAnnotation()).append("\n");
        } else {
            this.generalContent.append("");
        }
        this.propertiesArea.setText(this.generalContent.toString());
    }

    private void showLicense() {
        IURLEntry iURLEntry = this.selectedFeature.getLicense();
        if (iURLEntry != null) {
            this.propertiesArea.setText(iURLEntry.getAnnotation());
        } else {
            this.propertiesArea.setText("");
        }
    }

    private void showStatus() {
        try {
            switch (SiteManager.getLocalSite().getFeatureStatus(this.selectedFeature).getCode()) {
                case 0: 
                case 1: {
                    this.propertiesArea.setText(UIMessages.StatusHappy);
                    break;
                }
                case -1: {
                    this.propertiesArea.setText(UIMessages.StatusDisabled);
                    break;
                }
                default: {
                    this.propertiesArea.setText(UIMessages.StatusUnhappy);
                    break;
                }
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private void showIncludingPlugins() {
        if (this.pluginsContent != null) {
            this.propertiesArea.setText(this.pluginsContent.toString());
            return;
        }
        this.pluginsContent = new StringBuffer();
        IPluginEntry[] iPluginEntryArray = this.selectedFeature.getPluginEntries();
        int n = 0;
        while (n < iPluginEntryArray.length) {
            VersionedIdentifier versionedIdentifier = iPluginEntryArray[n].getVersionedIdentifier();
            if (versionedIdentifier != null) {
                this.pluginsContent.append(String.valueOf(versionedIdentifier.getIdentifier()) + " (" + versionedIdentifier.getVersion() + ")");
                this.pluginsContent.append("\n");
            }
            ++n;
        }
        this.propertiesArea.setText(this.pluginsContent.toString());
    }

    private void showRequiredBy() {
        if (this.requiredByContent != null) {
            this.propertiesArea.setText(this.requiredByContent.toString());
            return;
        }
        this.requiredByContent = new StringBuffer();
        IPluginEntry[] iPluginEntryArray = this.selectedFeature.getPluginEntries();
        IFeature iFeature = null;
        boolean bl = false;
        int n = 0;
        while (n < this.view.installedFeatures.size()) {
            try {
                IImport[] iImportArray;
                IFeatureReference iFeatureReference = (IFeatureReference)this.view.installedFeatures.get(n);
                bl = false;
                if (!this.selectedFeature.getVersionedIdentifier().equals((Object)iFeatureReference.getVersionedIdentifier()) && (iImportArray = (iFeature = iFeatureReference.getFeature(null)).getImports()).length != 0) {
                    int n2 = 0;
                    while (n2 < iImportArray.length && !bl) {
                        int n3 = 0;
                        while (n3 < iPluginEntryArray.length) {
                            if (iImportArray[n2].getVersionedIdentifier().getIdentifier().equals(iPluginEntryArray[n3].getVersionedIdentifier().getIdentifier())) {
                                this.requiredByContent.append(String.valueOf(iFeature.getLabel()) + " (" + iFeature.getVersionedIdentifier().getVersion() + ")\n");
                                bl = true;
                                break;
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            ++n;
        }
        this.propertiesArea.setText(this.requiredByContent.toString());
    }
}

