/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class BundleDeltaImpl
implements BundleDelta {
    private BundleDescription bundleDescription;
    private int type;

    public BundleDeltaImpl(BundleDescription bundleDescription) {
        this(bundleDescription, 0);
    }

    public BundleDeltaImpl(BundleDescription bundleDescription, int n) {
        this.bundleDescription = bundleDescription;
        this.type = n;
    }

    public BundleDescription getBundle() {
        return this.bundleDescription;
    }

    public int getType() {
        return this.type;
    }

    protected void setBundle(BundleDescription bundleDescription) {
        this.bundleDescription = bundleDescription;
    }

    protected void setType(int n) {
        this.type = n;
    }

    public String toString() {
        return String.valueOf(this.bundleDescription.getSymbolicName()) + '_' + this.bundleDescription.getVersion() + " (" + BundleDeltaImpl.toTypeString(this.type) + ")";
    }

    private static String toTypeString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append("ADDED,");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("REMOVED,");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("RESOLVED,");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("UNRESOLVED,");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("LINKAGE_CHANGED,");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("UPDATED,");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("REMOVAL_PENDING,");
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("REMOVAL_COMPLETE,");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return ((Object)stringBuffer).toString();
    }

    public int compareTo(Object object) {
        long l = this.getBundle().getBundleId() - ((BundleDelta)object).getBundle().getBundleId();
        return l < 0L ? -1 : (l > 0L ? 1 : 0);
    }
}

